/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorRegistry;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.type.ItemType;

public abstract class AccumulatorFn
extends SystemFunction {
    public abstract Phase getPhase();

    private Accumulator a(String string, AccumulatorRegistry object) {
        StructuredQName structuredQName;
        try {
            structuredQName = StructuredQName.fromLexicalQName(string, false, true, this.getRetainedStaticContext());
        }
        catch (XPathException xPathException) {
            throw new XPathException("Invalid accumulator name: " + xPathException.getMessage(), "XTDE3340");
        }
        if ((object = object == null ? null : ((AccumulatorRegistry)object).getAccumulator(structuredQName)) == null) {
            throw new XPathException("Accumulator " + string + " has not been declared", "XTDE3340");
        }
        return object;
    }

    @Override
    public ItemType getResultItemType(Expression[] expressionArray) {
        try {
            if (expressionArray[0] instanceof StringLiteral) {
                Object object = this.getRetainedStaticContext().getPackageData().getAccumulatorRegistry();
                object = this.a(((StringLiteral)expressionArray[0]).getStringValue(), (AccumulatorRegistry)object);
                return ((Accumulator)object).getType().getPrimaryType();
            }
        }
        catch (Exception exception) {}
        return super.getResultItemType(expressionArray);
    }

    @Override
    public int getCardinality(Expression[] expressionArray) {
        try {
            if (expressionArray[0] instanceof StringLiteral) {
                Object object = this.getRetainedStaticContext().getPackageData().getAccumulatorRegistry();
                object = this.a(((StringLiteral)expressionArray[0]).getStringValue(), (AccumulatorRegistry)object);
                return ((Accumulator)object).getType().getCardinality();
            }
        }
        catch (Exception exception) {}
        return super.getCardinality(expressionArray);
    }

    @Override
    public Sequence<?> call(XPathContext object, Sequence[] object2) {
        object2 = object2[0].head().getStringValue();
        XPathContext xPathContext = object;
        Phase phase = this.getPhase();
        object = this;
        Object object3 = ((SystemFunction)object).getRetainedStaticContext().getPackageData().getAccumulatorRegistry();
        object = super.a((String)object2, (AccumulatorRegistry)object3);
        Item<?> item = xPathContext.getContextItem();
        if (item == null) {
            throw new XPathException("No context item for evaluation of accumulator function", "XTDE3350", xPathContext);
        }
        if (!(item instanceof NodeInfo)) {
            throw new XPathException("Context item for evaluation of accumulator function must be a node", "XTTE3360", xPathContext);
        }
        int n2 = ((NodeInfo)item).getNodeKind();
        if (n2 == 2 || n2 == 13) {
            throw new XPathException("Context item for evaluation of accumulator function must not be an attribute or namespace node", "XTTE3360", xPathContext);
        }
        if ((object3 = ((AccumulatorRegistry)object3).getStreamingAccumulatorValue((NodeInfo)item, (Accumulator)object, phase)) != null) {
            return object3;
        }
        object3 = ((NodeInfo)item).getTreeInfo();
        XsltController xsltController = (XsltController)xPathContext.getController();
        if (!((Accumulator)object).isUniversallyApplicable() && !xsltController.getAccumulatorManager().isApplicable((TreeInfo)object3, (Accumulator)object)) {
            throw new XPathException("Accumulator " + (String)object2 + " is not applicable to the current document", "XTDE3362");
        }
        object2 = xsltController.getAccumulatorManager();
        object = object2.getAccumulatorData((TreeInfo)object3, (Accumulator)object, xPathContext);
        return object.getValue((NodeInfo)item, phase == Phase.AFTER);
    }

    public static class AccumulatorAfter
    extends AccumulatorFn {
        @Override
        public Phase getPhase() {
            return Phase.AFTER;
        }

        @Override
        public String getStreamerName() {
            return "AccumulatorAfter";
        }
    }

    public static class AccumulatorBefore
    extends AccumulatorFn {
        @Override
        public Phase getPhase() {
            return Phase.BEFORE;
        }
    }

    public static enum Phase {
        AFTER,
        BEFORE;

    }
}

