/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Properties;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.ma.arrays.ArrayFunctionSet;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.arrays.SquareArrayConstructor;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class ApplyFn
extends SystemFunction {
    private String a;

    public void setDynamicFunctionCall(String string) {
        this.a = string;
    }

    public boolean isDynamicFunctionCall() {
        return this.a != null;
    }

    @Override
    public ItemType getResultItemType(Expression[] object) {
        if ((object = object[0].getItemType()) instanceof MapType) {
            return ((MapType)object).getValueType().getPrimaryType();
        }
        if (object instanceof ArrayItemType) {
            return ((ArrayItemType)object).getMemberType().getPrimaryType();
        }
        if (object instanceof FunctionItemType) {
            return ((FunctionItemType)object).getResultType().getPrimaryType();
        }
        if (object instanceof AnyFunctionType) {
            return AnyItemType.getInstance();
        }
        return AnyItemType.getInstance();
    }

    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo, Expression ... expressionArray) {
        if (expressionArray.length == 2 && expressionArray[1] instanceof SquareArrayConstructor) {
            Expression expression = expressionArray[0];
            if (expression.getItemType() instanceof MapType) {
                return ApplyFn.a(expressionVisitor, MapFunctionSet.getInstance(), contextItemStaticInfo, expressionArray);
            }
            if (expression.getItemType() instanceof ArrayItemType) {
                return ApplyFn.a(expressionVisitor, ArrayFunctionSet.getInstance(), contextItemStaticInfo, expressionArray);
            }
        }
        return null;
    }

    private static Expression a(ExpressionVisitor expressionVisitor, BuiltInFunctionSet object, ContextItemStaticInfo contextItemStaticInfo, Expression[] object2) {
        Expression expression = object2[0];
        object2 = ((SquareArrayConstructor)object2[1]).getOperanda().getOperand(0).getChildExpression();
        object = ((BuiltInFunctionSet)object).makeFunction("get", 2).makeFunctionCall(new Expression[]{expression, object2});
        ((Expression)object).setRetainedStaticContext(expression.getRetainedStaticContext());
        return ((Expression)object).typeCheck(expressionVisitor, contextItemStaticInfo);
    }

    @Override
    public Sequence<?> call(XPathContext xPathContext, Sequence[] object) {
        Sequence<?> sequence;
        int n2;
        Function function = (Function)object[0].head();
        object = (ArrayItem)object[1].head();
        if (function.getArity() != object.arrayLength()) {
            String string = this.isDynamicFunctionCall() ? "XPTY0004" : "FOAP0001";
            XPathException xPathException = new XPathException("Number of arguments required for dynamic call to " + function.getDescription() + " is " + function.getArity() + "; number supplied = " + object.arrayLength(), string);
            xPathException.setIsTypeError(this.isDynamicFunctionCall());
            xPathException.setXPathContext(xPathContext);
            throw xPathException;
        }
        TypeHierarchy typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
        FunctionItemType functionItemType = function.getFunctionItemType();
        Sequence[] sequenceArray = new Sequence[object.arrayLength()];
        if (functionItemType == AnyFunctionType.ANY_FUNCTION) {
            for (n2 = 0; n2 < sequenceArray.length; ++n2) {
                sequenceArray[n2] = object.get(n2);
            }
        } else {
            for (n2 = 0; n2 < sequenceArray.length; ++n2) {
                sequence = functionItemType.getArgumentTypes()[n2];
                RoleDiagnostic roleDiagnostic = this.isDynamicFunctionCall() ? new RoleDiagnostic(0, "result of " + this.a, n2) : new RoleDiagnostic(0, "fn:apply", n2 + 1);
                sequence = typeHierarchy.applyFunctionConversionRules(object.get(n2), (SequenceType)((Object)sequence), roleDiagnostic, ExplicitLocation.UNKNOWN_LOCATION);
                sequenceArray[n2] = sequence.materialize();
            }
        }
        Sequence<?> sequence2 = ApplyFn.dynamicCall(function, xPathContext, sequenceArray);
        if (function.isTrustedResultType()) {
            return sequence2;
        }
        sequence = new RoleDiagnostic(5, "fn:apply", -1);
        return typeHierarchy.applyFunctionConversionRules(sequence2, functionItemType.getResultType(), (RoleDiagnostic)((Object)sequence), ExplicitLocation.UNKNOWN_LOCATION);
    }

    @Override
    public void exportAttributes(ExpressionPresenter expressionPresenter) {
        expressionPresenter.emitAttribute("dyn", this.a);
    }

    @Override
    public void importAttributes(Properties properties) {
        this.a = properties.getProperty("dyn");
    }
}

