/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Fold;
import net.sf.saxon.functions.FoldingFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.YearMonthDurationValue;

public class Average
extends FoldingFunction {
    @Override
    public int getCardinality(Expression[] expressionArray) {
        if (!Cardinality.allowsZero(expressionArray[0].getCardinality())) {
            return 16384;
        }
        return super.getCardinality(expressionArray);
    }

    @Override
    public Fold getFold(XPathContext xPathContext, Sequence ... sequenceArray) {
        return new a(this, xPathContext);
    }

    private final class a
    implements Fold {
        private XPathContext a;
        private AtomicValue b;
        private boolean c = true;
        private ConversionRules d;
        private StringConverter e;
        private int f = 0;
        private /* synthetic */ Average g;

        public a(Average average, XPathContext xPathContext) {
            this.g = average;
            this.a = xPathContext;
            this.d = xPathContext.getConfiguration().getConversionRules();
            this.e = BuiltInAtomicType.DOUBLE.getStringConverter(this.d);
        }

        @Override
        public final void processItem(Item<?> atomicValue) {
            if ((atomicValue = (AtomicValue)atomicValue) instanceof UntypedAtomicValue) {
                atomicValue = ((Converter)this.e).convert((UntypedAtomicValue)atomicValue).asAtomic();
            }
            ++this.f;
            if (this.c) {
                if (atomicValue instanceof NumericValue || atomicValue instanceof DayTimeDurationValue || atomicValue instanceof YearMonthDurationValue) {
                    this.b = atomicValue;
                    this.c = false;
                    return;
                }
                if (atomicValue instanceof DurationValue) {
                    throw new XPathException("Input to avg() contains a duration (" + Err.depict(atomicValue) + ") that is neither an xs:dayTimeDuration nor an xs:yearMonthDuration", "FORG0006");
                }
                throw new XPathException("Input to avg() contains a value (" + Err.depict(atomicValue) + ") that is neither numeric, nor a duration", "FORG0006");
            }
            if (this.b instanceof NumericValue) {
                if (!(atomicValue instanceof NumericValue)) {
                    throw new XPathException("Input to avg() contains a mix of numeric and non-numeric values", "FORG0006");
                }
                this.b = ArithmeticExpression.compute(this.b, 0, atomicValue, this.a);
                return;
            }
            if (this.b instanceof DurationValue) {
                if (!(atomicValue instanceof DurationValue)) {
                    throw new XPathException("Input to avg() contains a mix of duration and non-duration values", "FORG0006");
                }
                try {
                    this.b = ((DurationValue)this.b).add((DurationValue)atomicValue);
                    return;
                }
                catch (XPathException xPathException) {
                    if ("XPTY0004".equals(xPathException.getErrorCodeLocalPart())) {
                        xPathException.setErrorCode("FORG0006");
                    }
                    throw xPathException;
                }
            }
            throw new XPathException("Input to avg() contains a value (" + Err.depict(this.b) + ") that is neither numeric, nor a duration", "FORG0006");
        }

        @Override
        public final boolean isFinished() {
            return this.b instanceof DoubleValue && this.b.isNaN();
        }

        @Override
        public final Sequence<?> result() {
            if (this.c) {
                return EmptySequence.getInstance();
            }
            if (this.b instanceof NumericValue) {
                return ArithmeticExpression.compute(this.b, 3, new Int64Value(this.f), this.a);
            }
            return ((DurationValue)this.b).divide(this.f);
        }
    }
}

