/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.Count;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;

public class BooleanFn
extends SystemFunction {
    @Override
    public void supplyTypeInformation(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo, Expression[] expressionArray) {
        if ((object = TypeChecker.ebvError(expressionArray[0], ((ExpressionVisitor)object).getConfiguration().getTypeHierarchy())) != null) {
            throw object;
        }
    }

    public static Expression rewriteEffectiveBooleanValue(Expression expression, ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        Object object = expressionVisitor.getConfiguration();
        object = ((Configuration)object).getTypeHierarchy();
        boolean bl2 = expressionVisitor.isOptimizeForStreaming();
        if ((expression = ExpressionTool.unsortedIfHomogeneous(expression, bl2)) instanceof Literal) {
            object = ((Literal)expression).getValue();
            if (object instanceof BooleanValue) {
                return expression;
            }
            return Literal.makeLiteral(BooleanValue.get(ExpressionTool.effectiveBooleanValue(object.iterate())), expression);
        }
        if (expression instanceof ValueComparison) {
            object = (ValueComparison)expression;
            if (((ValueComparison)object).getResultWhenEmpty() == null) {
                ((ValueComparison)object).setResultWhenEmpty(BooleanValue.FALSE);
            }
            return expression;
        }
        if (expression.isCallOn(BooleanFn.class)) {
            return ((SystemFunctionCall)expression).getArg(0);
        }
        if (((TypeHierarchy)object).isSubType(expression.getItemType(), BuiltInAtomicType.BOOLEAN) && expression.getCardinality() == 16384) {
            return expression;
        }
        if (expression.isCallOn(Count.class)) {
            object = SystemFunction.makeCall("exists", expression.getRetainedStaticContext(), ((SystemFunctionCall)expression).getArg(0));
            assert (object != null);
            ExpressionTool.copyLocationInfo(expression, (Expression)object);
            return ((Expression)object).optimize(expressionVisitor, contextItemStaticInfo);
        }
        if (expression.getItemType() instanceof NodeTest) {
            object = SystemFunction.makeCall("exists", expression.getRetainedStaticContext(), expression);
            assert (object != null);
            ExpressionTool.copyLocationInfo(expression, (Expression)object);
            return ((Expression)object).optimize(expressionVisitor, contextItemStaticInfo);
        }
        return null;
    }

    public BooleanValue call(XPathContext xPathContext, Sequence[] sequenceArray) {
        boolean bl2 = ExpressionTool.effectiveBooleanValue(sequenceArray[0].iterate());
        return BooleanValue.get(bl2);
    }

    @Override
    public Expression makeFunctionCall(Expression[] expressionArray) {
        BooleanFn booleanFn = this;
        return new SystemFunctionCall(booleanFn, booleanFn, expressionArray){
            private /* synthetic */ BooleanFn a;
            {
                this.a = booleanFn;
                super(booleanFn2, expressionArray);
            }

            @Override
            public final Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
                Expression expression;
                Expression expression2 = super.optimize(expressionVisitor, contextItemStaticInfo);
                if (expression2 == this && (expression = BooleanFn.rewriteEffectiveBooleanValue(this.getArg(0), expressionVisitor, contextItemStaticInfo)) != null) {
                    if ((expression = expression.optimize(expressionVisitor, contextItemStaticInfo)).getItemType() == BuiltInAtomicType.BOOLEAN && expression.getCardinality() == 16384) {
                        expression.setParentExpression(this.getParentExpression());
                        return expression;
                    }
                    this.setArg(0, expression);
                    this.adoptChildExpression(expression);
                    return this;
                }
                return expression2;
            }

            @Override
            public final boolean effectiveBooleanValue(XPathContext xPathContext) {
                try {
                    return this.getArg(0).effectiveBooleanValue(xPathContext);
                }
                catch (XPathException xPathException) {
                    XPathException xPathException2 = xPathException;
                    xPathException.maybeSetLocation(this.getLocation());
                    xPathException2.maybeSetContext(xPathContext);
                    throw xPathException2;
                }
            }

            public final /* synthetic */ Item evaluateItem(XPathContext object) {
                XPathContext xPathContext = object;
                object = this;
                return BooleanValue.get(((Expression)object).effectiveBooleanValue(xPathContext));
            }
        };
    }

    @Override
    public String getCompilerName() {
        return "BooleanFnCompiler";
    }

    @Override
    public String getStreamerName() {
        return "BooleanFn";
    }
}

