/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.function.IntPredicate;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class CodepointsToString
extends SystemFunction
implements Callable {
    public static CharSequence unicodeToString(SequenceIterator sequenceIterator, IntPredicate intPredicate) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        NumericValue numericValue;
        while ((numericValue = (NumericValue)sequenceIterator.next()) != null) {
            long l2 = numericValue.longValue();
            if (l2 < 0L || l2 > Integer.MAX_VALUE || !intPredicate.test((int)l2)) {
                throw new XPathException("codepoints-to-string(): invalid XML character [x" + Integer.toHexString((int)l2) + ']', "FOCH0001");
            }
            fastStringBuffer.appendWideChar((int)l2);
        }
        return fastStringBuffer.condense();
    }

    public StringValue call(XPathContext xPathContext, Sequence[] object) {
        object = object[0].iterate();
        return new StringValue(CodepointsToString.unicodeToString((SequenceIterator)object, xPathContext.getConfiguration().getValidCharacterChecker()));
    }

    @Override
    public String getStreamerName() {
        return "CodepointsToString";
    }
}

