/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Properties;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.EqualityComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.functions.CollatingFunctionFree;
import net.sf.saxon.functions.StatefulSystemFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;

public abstract class CollatingFunctionFixed
extends SystemFunction
implements StatefulSystemFunction {
    private String a;
    private StringCollator b = null;
    private AtomicComparer c = null;

    public boolean isSubstringMatchingFunction() {
        return false;
    }

    public StringCollator getStringCollator() {
        return this.b;
    }

    @Override
    public void setRetainedStaticContext(RetainedStaticContext retainedStaticContext) {
        super.setRetainedStaticContext(retainedStaticContext);
        if (this.a == null) {
            this.a = retainedStaticContext.getDefaultCollationName();
            try {
                this.a();
                return;
            }
            catch (XPathException xPathException) {}
        }
    }

    public void setCollationName(String string) {
        this.a = string;
        this.a();
    }

    private void a() {
        this.b = this.getRetainedStaticContext().getConfiguration().getCollation(this.a);
        if (this.b == null) {
            throw new XPathException("Unknown collation " + this.a, "FOCH0002");
        }
        if (this.isSubstringMatchingFunction()) {
            if (this.b instanceof SimpleCollation) {
                this.b = ((SimpleCollation)this.b).getSubstringMatcher();
            }
            if (!(this.b instanceof SubstringMatcher)) {
                throw new XPathException("The collation requested for " + this.getFunctionName().getDisplayName() + " does not support substring matching", "FOCH0004");
            }
        }
    }

    protected void preAllocateComparer(AtomicType atomicType, AtomicType atomicType2, StaticContext staticContext) {
        this.getStringCollator();
        if (atomicType == ErrorType.getInstance() || atomicType2 == ErrorType.getInstance()) {
            this.c = EqualityComparer.getInstance();
            return;
        }
        this.c = GenericAtomicComparer.makeAtomicComparer((BuiltInAtomicType)atomicType.getBuiltInBaseType(), (BuiltInAtomicType)atomicType2.getBuiltInBaseType(), this.b, staticContext.makeEarlyEvaluationContext());
    }

    public AtomicComparer getPreAllocatedAtomicComparer() {
        return this.c;
    }

    public AtomicComparer getAtomicComparer(XPathContext xPathContext) {
        if (this.c != null) {
            return this.c.provideContext(xPathContext);
        }
        return new GenericAtomicComparer(this.getStringCollator(), xPathContext);
    }

    @Override
    public void exportAttributes(ExpressionPresenter expressionPresenter) {
        if (!this.a.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            expressionPresenter.emitAttribute("collation", this.a);
        }
    }

    @Override
    public void importAttributes(Properties object) {
        if ((object = ((Properties)object).getProperty("collation")) != null) {
            this.setCollationName((String)object);
        }
    }

    @Override
    public CollatingFunctionFixed copy() {
        SystemFunction systemFunction = SystemFunction.makeFunction(this.getFunctionName().getLocalPart(), this.getRetainedStaticContext(), this.getArity());
        if (systemFunction instanceof CollatingFunctionFree) {
            try {
                systemFunction = ((CollatingFunctionFree)systemFunction).bindCollation(this.a);
            }
            catch (XPathException xPathException) {
                throw new AssertionError((Object)xPathException);
            }
        }
        if (systemFunction instanceof CollatingFunctionFixed) {
            ((CollatingFunctionFixed)systemFunction).a = this.a;
            ((CollatingFunctionFixed)systemFunction).c = this.c;
            ((CollatingFunctionFixed)systemFunction).b = this.b;
            return (CollatingFunctionFixed)systemFunction;
        }
        throw new IllegalStateException();
    }
}

