/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;

public class CollatingFunctionFree
extends SystemFunction {
    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor expressionArray, ContextItemStaticInfo object, Expression ... expressionArray2) {
        object = expressionArray2[expressionArray2.length - 1];
        if (object instanceof Literal) {
            Object object2;
            String string = ((Literal)object).getValue().getStringValue();
            try {
                object2 = new URI(string);
                if (!((URI)object2).isAbsolute()) {
                    object2 = ResolveURI.makeAbsolute(string, this.getStaticBaseUriString());
                    string = ((URI)object2).toASCIIString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                expressionArray.getStaticContext().issueWarning("Cannot resolve relative collation URI " + string, ((Expression)object).getLocation());
            }
            object2 = this.bindCollation(string);
            expressionArray = new Expression[expressionArray2.length - 1];
            System.arraycopy(expressionArray2, 0, expressionArray, 0, expressionArray.length);
            return ((SystemFunction)object2).makeFunctionCall(expressionArray);
        }
        return null;
    }

    public CollatingFunctionFixed bindCollation(String string) {
        Object object = this.getRetainedStaticContext().getConfiguration();
        object = (CollatingFunctionFixed)((Configuration)object).makeSystemFunction(this.getFunctionName().getLocalPart(), this.getArity() - 1);
        ((SystemFunction)object).setRetainedStaticContext(this.getRetainedStaticContext());
        ((CollatingFunctionFixed)object).setCollationName(string);
        return object;
    }

    public static String expandCollationURI(String string, URI uRI) {
        try {
            URI uRI2 = new URI(string);
            if (!uRI2.isAbsolute()) {
                if (uRI == null) {
                    throw new XPathException("Cannot resolve relative collation URI '" + string + "': unknown or invalid base URI", "FOCH0002");
                }
                uRI2 = uRI.resolve(uRI2);
                string = uRI2.toString();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XPathException("Collation name '" + string + "' is not a valid URI", "FOCH0002");
        }
        return string;
    }

    @Override
    public Sequence<?> call(XPathContext xPathContext, Sequence[] sequenceArray) {
        CollatingFunctionFree collatingFunctionFree = this;
        int n2 = collatingFunctionFree.getArity() - 1;
        Object object = sequenceArray[n2].head().getStringValue();
        object = CollatingFunctionFree.expandCollationURI((String)object, this.getRetainedStaticContext().getStaticBaseUri());
        object = this.bindCollation((String)object);
        Sequence[] sequenceArray2 = new Sequence[sequenceArray.length - 1];
        System.arraycopy(sequenceArray, 0, sequenceArray2, 0, n2);
        if (n2 + 1 < this.getArity()) {
            System.arraycopy(sequenceArray, n2 + 1, sequenceArray2, n2, this.getArity() - n2);
        }
        return object.call(xPathContext, sequenceArray2);
    }

    @Override
    public String getStreamerName() {
        try {
            return this.bindCollation("http://www.w3.org/2005/xpath-functions/collation/codepoint").getStreamerName();
        }
        catch (XPathException xPathException) {
            throw new AssertionError((Object)xPathException);
        }
    }
}

