/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.IriToUri;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceCollection;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.wrapper.SpaceStrippedDocument;
import net.sf.saxon.value.ExternalObject;
import net.sf.saxon.value.ObjectValue;

public class CollectionFn
extends SystemFunction
implements Callable {
    public static String EMPTY_COLLECTION_URI = "http://saxon.sf.net/collection/empty";
    public static final ResourceCollection EMPTY_COLLECTION = new a(EMPTY_COLLECTION_URI);

    @Override
    public int getSpecialProperties(Expression[] expressionArray) {
        return super.getSpecialProperties(expressionArray) & 0xFF7FFFFF | 0x80000;
    }

    private String a(String string, XPathContext object) {
        block10: {
            if (string == null) {
                string = object.getConfiguration().getDefaultCollection();
            } else {
                try {
                    object = new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    string = IriToUri.iriToUri(string).toString();
                    try {
                        object = new URI(string);
                    }
                    catch (URISyntaxException uRISyntaxException2) {
                        throw new XPathException(uRISyntaxException2.getMessage(), "FODC0004");
                    }
                }
                try {
                    if (((URI)object).isAbsolute()) {
                        string = ((URI)object).toString();
                        break block10;
                    }
                    object = this.getRetainedStaticContext().getStaticBaseUriString();
                    if (object != null) {
                        string = new URI((String)object).resolve(string).toString();
                        break block10;
                    }
                    throw new XPathException("Relative collection URI cannot be resolved: no base URI available", "FODC0002");
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new XPathException(uRISyntaxException.getMessage(), "FODC0004");
                }
            }
        }
        return string;
    }

    @Override
    public Sequence<?> call(XPathContext xPathContext, Sequence[] object) {
        boolean bl2;
        Object object2;
        object = this.getArity() == 0 ? xPathContext.getController().getDefaultCollection() : ((object = object[0].head()) == null ? xPathContext.getController().getDefaultCollection() : object.getStringValue());
        if (object == null) {
            throw new XPathException("No default collection has been defined", "FODC0002");
        }
        object = this.a((String)object, xPathContext);
        Object object3 = this.getRetainedStaticContext().getPackageData();
        Object object4 = NoElementsSpaceStrippingRule.getInstance();
        Object object5 = object;
        if (((PackageData)object3).getHostLanguage() == 50 && (object4 = ((StylesheetPackage)object3).getSpaceStrippingRule()) != NoElementsSpaceStrippingRule.getInstance()) {
            object5 = ((StylesheetPackage)object3).getPackageName() + ((StylesheetPackage)object3).getPackageVersion() + " " + (String)object;
        }
        if ((object2 = (GroundedValue)xPathContext.getController().getUserData("saxon:collections", (String)object5)) != null) {
            return object2;
        }
        object2 = xPathContext.getController().getCollectionFinder();
        object = object2.findCollection(xPathContext, (String)object);
        if (object == null) {
            object = new a(EMPTY_COLLECTION_URI);
        }
        if (object3 instanceof StylesheetPackage && object4 != NoElementsSpaceStrippingRule.getInstance() && object instanceof AbstractResourceCollection && (bl2 = object.stripWhitespace((SpaceStrippingRule)object4))) {
            object4 = null;
        }
        Object object6 = xPathContext;
        object2 = object;
        object3 = this;
        object2 = object2.getResources((XPathContext)object6);
        object3 = new SequenceIterator<Item<?>>((CollectionFn)object3, (Iterator)object2){
            private /* synthetic */ Iterator a;
            private /* synthetic */ CollectionFn b;
            {
                this.b = collectionFn;
                this.a = iterator;
            }

            @Override
            public final Item next() {
                try {
                    if (this.a.hasNext()) {
                        return new ObjectValue(this.a.next());
                    }
                    return null;
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    throw XPathException.makeXPathException(exception);
                }
            }

            @Override
            public final void close() {
                if (this.a instanceof Closeable) {
                    try {
                        ((Closeable)((Object)this.a)).close();
                        return;
                    }
                    catch (IOException iOException) {
                        throw new UncheckedXPathException(new XPathException(iOException));
                    }
                }
            }

            @Override
            public final int getProperties() {
                return 0;
            }
        };
        object3 = xPathContext.getConfiguration().getMultithreadedItemMappingIterator(object3, item -> ((Resource)((ExternalObject)item).getObject()).getItem(xPathContext));
        if (object4 != null) {
            object6 = arg_0 -> CollectionFn.a((SpaceStrippingRule)object4, arg_0);
            object3 = new ItemMappingIterator<Item, Item>((SequenceIterator<Item>)object3, (ItemMappingFunction<Item, Item>)object6);
        }
        if (object.isStable(xPathContext) || xPathContext.getConfiguration().getBooleanProperty(Feature.STABLE_COLLECTION_URI)) {
            object4 = xPathContext.getController();
            object6 = ((Controller)object4).getDocumentPool();
            object2 = object3.materialize();
            object = object2.iterate();
            while ((object3 = object.next()) != null) {
                if (!(object3 instanceof NodeInfo) || ((NodeInfo)object3).getNodeKind() != 9) continue;
                Object object7 = ((NodeInfo)object3).getSystemId();
                object7 = new DocumentURI((String)object7);
                object3 = object3 instanceof TreeInfo ? (TreeInfo)object3 : new GenericTreeInfo(((Controller)object4).getConfiguration(), (NodeInfo)object3);
                ((DocumentPool)object6).add((TreeInfo)object3, (DocumentURI)object7);
            }
            xPathContext.getController().setUserData("saxon:collections", (String)object5, object2);
            return object2;
        }
        return new LazySequence<Item>((SequenceIterator<Item>)object3);
    }

    private static /* synthetic */ Item a(SpaceStrippingRule spaceStrippingRule, Item item) {
        TreeInfo treeInfo;
        if (item instanceof NodeInfo && ((NodeInfo)item).getNodeKind() == 9 && (treeInfo = ((NodeInfo)item).getTreeInfo()).getSpaceStrippingRule() != spaceStrippingRule) {
            return new SpaceStrippedDocument(treeInfo, spaceStrippingRule).getRootNode();
        }
        return item;
    }

    private static final class a
    implements ResourceCollection {
        private String a;

        public a(String string) {
            this.a = string;
        }

        @Override
        public final String getCollectionURI() {
            return this.a;
        }

        @Override
        public final Iterator<String> getResourceURIs(XPathContext xPathContext) {
            return new ArrayList().iterator();
        }

        public final Iterator<Resource> getResources(XPathContext xPathContext) {
            return new ArrayList().iterator();
        }

        @Override
        public final boolean isStable(XPathContext xPathContext) {
            return true;
        }

        @Override
        public final boolean stripWhitespace(SpaceStrippingRule spaceStrippingRule) {
            return false;
        }
    }
}

