/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Arrays;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.oper.OperandArray;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class Concat
extends SystemFunction {
    @Override
    protected Sequence<?> resultIfEmpty(int n2) {
        return null;
    }

    @Override
    public OperandRole[] getOperandRoles() {
        OperandRole[] operandRoleArray = new OperandRole[this.getArity()];
        OperandRole operandRole = new OperandRole(0, OperandUsage.ABSORPTION);
        for (int i2 = 0; i2 < this.getArity(); ++i2) {
            operandRoleArray[i2] = operandRole;
        }
        return operandRoleArray;
    }

    @Override
    public FunctionItemType getFunctionItemType() {
        Object[] objectArray = new SequenceType[this.getArity()];
        Arrays.fill(objectArray, SequenceType.OPTIONAL_ATOMIC);
        return new SpecificFunctionType((SequenceType[])objectArray, SequenceType.SINGLE_STRING);
    }

    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo, Expression ... expressionArray) {
        if (OperandArray.every(expressionArray, expression -> expression.getCardinality() == 16384 && expression.getItemType() == BuiltInAtomicType.BOOLEAN)) {
            expressionVisitor.getStaticContext().issueWarning("Did you intend to apply string concatenation to boolean operands? Perhaps you intended 'or' rather than '||'. To suppress this warning, use string() on the arguments.", expressionArray[0].getLocation());
        }
        Concat concat = this;
        return new SystemFunctionCall.Optimized(concat, concat, expressionArray){
            private /* synthetic */ Concat a;
            {
                this.a = concat;
                super(concat2, expressionArray);
            }

            @Override
            public final CharSequence evaluateAsString(XPathContext xPathContext) {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
                for (Operand operand : ((Expression)this).operands()) {
                    Item<?> iterable = operand.getChildExpression().evaluateItem(xPathContext);
                    if (iterable == null) continue;
                    fastStringBuffer.append(iterable.getStringValueCS());
                }
                return fastStringBuffer;
            }

            public final Item evaluateItem(XPathContext xPathContext) {
                return new StringValue(((Expression)this).evaluateAsString(xPathContext));
            }
        };
    }

    public StringValue call(XPathContext object, Sequence[] sequenceArray) {
        object = new FastStringBuffer(64);
        for (Sequence sequence : sequenceArray) {
            Object sequence2 = sequence.head();
            if (sequence2 == null) continue;
            ((FastStringBuffer)object).append(sequence2.getStringValueCS());
        }
        return new StringValue((CharSequence)object);
    }

    @Override
    public SequenceType getRequiredType(int n2) {
        return this.getDetails().argumentTypes[0];
    }

    @Override
    public String getCompilerName() {
        return "ConcatCompiler";
    }
}

