/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.functions.ConstantFunction;
import net.sf.saxon.functions.ContextAccessorFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class ContextItemAccessorFunction
extends ContextAccessorFunction {
    @Override
    public Function bindContext(XPathContext object) {
        Item<?> item = object.getContextItem();
        if (item == null) {
            object = (xPathContext, sequenceArray) -> {
                throw new XPathException("Context item for " + this.getFunctionName().getDisplayName() + " is absent", "XPDY0002");
            };
            item = new SpecificFunctionType(new SequenceType[0], SequenceType.ANY_SEQUENCE);
            return new CallableFunction(0, (Callable)object, (FunctionItemType)((Object)item));
        }
        object = new ConstantFunction(this.evaluate(item, (XPathContext)object));
        ((SystemFunction)object).setDetails(this.getDetails());
        ((SystemFunction)object).setRetainedStaticContext(this.getRetainedStaticContext());
        return object;
    }

    public GroundedValue evaluate(Item item, XPathContext xPathContext) {
        SystemFunction systemFunction = SystemFunction.makeFunction(this.getDetails().name.getLocalPart(), this.getRetainedStaticContext(), 1);
        return systemFunction.call(xPathContext, new Sequence[]{item}).materialize();
    }

    @Override
    public Sequence<?> call(XPathContext xPathContext, Sequence[] sequenceArray) {
        return this.evaluate(xPathContext.getContextItem(), xPathContext);
    }

    @Override
    public Expression makeFunctionCall(Expression[] object) {
        object = new ContextItemExpression();
        return SystemFunction.makeCall(this.getFunctionName().getLocalPart(), this.getRetainedStaticContext(), new Expression[]{object});
    }

    public Expression makeContextItemExplicit() {
        Expression[] expressionArray = new Expression[]{new ContextItemExpression()};
        return SystemFunction.makeCall(this.getFunctionName().getLocalPart(), this.getRetainedStaticContext(), expressionArray);
    }

    public static class Number_0
    extends ContextItemAccessorFunction {
        @Override
        public Expression makeFunctionCall(Expression[] object) {
            object = new ContextItemExpression();
            object = SystemFunction.makeCall("data", this.getRetainedStaticContext(), new Expression[]{object});
            return SystemFunction.makeCall(this.getFunctionName().getLocalPart(), this.getRetainedStaticContext(), new Expression[]{object});
        }

        @Override
        public GroundedValue evaluate(Item object, XPathContext xPathContext) {
            SystemFunction systemFunction = SystemFunction.makeFunction(this.getDetails().name.getLocalPart(), this.getRetainedStaticContext(), 1);
            object = object.atomize();
            switch (object.getLength()) {
                case 0: {
                    return DoubleValue.NaN;
                }
                case 1: {
                    return systemFunction.call(xPathContext, new Sequence[]{object.head()}).materialize();
                }
            }
            object = new XPathException("When number() is called with no arguments, the atomized value of the context node must not be a sequence of several atomic values", "XPTY0004");
            ((XPathException)object).setIsTypeError(true);
            throw object;
        }
    }

    public static class StringAccessor
    extends ContextItemAccessorFunction {
        @Override
        public Expression makeFunctionCall(Expression[] object) {
            object = new ContextItemExpression();
            object = SystemFunction.makeCall("string", this.getRetainedStaticContext(), new Expression[]{object});
            return SystemFunction.makeCall(this.getFunctionName().getLocalPart(), this.getRetainedStaticContext(), new Expression[]{object});
        }

        @Override
        public GroundedValue evaluate(Item item, XPathContext xPathContext) {
            SystemFunction systemFunction = SystemFunction.makeFunction(this.getDetails().name.getLocalPart(), this.getRetainedStaticContext(), 1);
            item = new StringValue(item.getStringValueCS());
            return systemFunction.call(xPathContext, new Sequence[]{item}).materialize();
        }
    }
}

