/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public class Count
extends SystemFunction {
    @Override
    public IntegerValue[] getIntegerBounds() {
        return new IntegerValue[]{Int64Value.ZERO, Expression.MAX_SEQUENCE_LENGTH};
    }

    public static int count(SequenceIterator sequenceIterator) {
        if ((sequenceIterator.getProperties() & 2) != 0) {
            return ((LastPositionFinder)((Object)sequenceIterator)).getLength();
        }
        int n2 = 0;
        while (sequenceIterator.next() != null) {
            ++n2;
        }
        return n2;
    }

    public static int steppingCount(SequenceIterator sequenceIterator) {
        int n2 = 0;
        while (sequenceIterator.next() != null) {
            ++n2;
        }
        return n2;
    }

    public IntegerValue call(XPathContext object, Sequence[] sequenceArray) {
        object = sequenceArray[0];
        int n2 = object instanceof GroundedValue ? ((GroundedValue)object).getLength() : Count.count(object.iterate());
        return Int64Value.makeIntegerValue(n2);
    }

    @Override
    public String getCompilerName() {
        return "CountCompiler";
    }

    @Override
    public String getStreamerName() {
        return "Count";
    }
}

