/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashSet;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.SameNameTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.tiny.WhitespaceTextImpl;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class DeepEqual
extends CollatingFunctionFixed {
    public static final int INCLUDE_NAMESPACES = 1;
    public static final int INCLUDE_PREFIXES = 2;
    public static final int INCLUDE_COMMENTS = 4;
    public static final int INCLUDE_PROCESSING_INSTRUCTIONS = 8;
    public static final int EXCLUDE_WHITESPACE_TEXT_NODES = 16;
    public static final int COMPARE_STRING_VALUES = 32;
    public static final int COMPARE_ANNOTATIONS = 64;
    public static final int WARNING_IF_FALSE = 128;
    public static final int JOIN_ADJACENT_TEXT_NODES = 256;
    public static final int COMPARE_ID_FLAGS = 512;
    public static final int EXCLUDE_VARIETY = 1024;

    public static boolean deepEqual(SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2, AtomicComparer atomicComparer, XPathContext xPathContext, int n2) {
        UnfailingErrorListener unfailingErrorListener;
        String string;
        boolean bl2;
        block14: {
            bl2 = true;
            string = null;
            unfailingErrorListener = xPathContext.getErrorListener();
            try {
                if ((n2 & 0x100) != 0) {
                    sequenceIterator = DeepEqual.a(sequenceIterator);
                    sequenceIterator2 = DeepEqual.a(sequenceIterator2);
                }
                int n3 = 0;
                int n4 = 0;
                while (true) {
                    Object object = sequenceIterator.next();
                    Object object2 = sequenceIterator2.next();
                    if (object == null && object2 == null) break block14;
                    ++n3;
                    ++n4;
                    if (object == null || object2 == null) {
                        bl2 = false;
                        string = object == null ? "Second sequence is longer (first sequence length = " + n4 + ")" : "First sequence is longer (second sequence length = " + n3 + ")";
                        if (object instanceof WhitespaceTextImpl || object2 instanceof WhitespaceTextImpl) {
                            string = string + " (the first extra node is whitespace text)";
                        }
                        break block14;
                    }
                    if (object instanceof Function || object2 instanceof Function) {
                        if (!(object instanceof Function) || !(object2 instanceof Function)) {
                            new StringBuilder("if one item is a function then both must be functions (position ").append(n3).append(")");
                            return false;
                        }
                        boolean bl3 = ((Function)object).deepEquals((Function)object2, xPathContext, atomicComparer, n2);
                        if (bl3) continue;
                        bl2 = false;
                        string = "functions at position " + n3 + " differ";
                        break block14;
                    }
                    if (object instanceof ObjectValue || object2 instanceof ObjectValue) {
                        if (object.equals(object2)) continue;
                        return false;
                    }
                    if (object instanceof NodeInfo) {
                        if (object2 instanceof NodeInfo) {
                            if (DeepEqual.deepEquals((NodeInfo)object, (NodeInfo)object2, atomicComparer, xPathContext.getConfiguration(), unfailingErrorListener, n2)) continue;
                            bl2 = false;
                            string = "nodes at position " + n3 + " differ";
                        } else {
                            bl2 = false;
                            string = "comparing a node to an atomic value at position " + n3;
                        }
                        break block14;
                    }
                    if (object2 instanceof NodeInfo) {
                        bl2 = false;
                        string = "comparing an atomic value to a node at position " + n3;
                        break block14;
                    }
                    object = (AtomicValue)object;
                    object2 = (AtomicValue)object2;
                    if (!(((AtomicValue)object).isNaN() && ((AtomicValue)object2).isNaN() || atomicComparer.comparesEqual((AtomicValue)object, (AtomicValue)object2))) break;
                }
                bl2 = false;
                string = "atomic values at position " + n3 + " differ";
            }
            catch (ClassCastException classCastException) {
                bl2 = false;
                string = "sequences contain non-comparable values";
            }
        }
        if (!bl2) {
            DeepEqual.a(unfailingErrorListener, string, n2, null, null);
        }
        return bl2;
    }

    public static boolean deepEquals(NodeInfo nodeInfo, NodeInfo nodeInfo2, AtomicComparer atomicComparer, Configuration configuration, UnfailingErrorListener unfailingErrorListener, int n2) {
        if (nodeInfo.equals(nodeInfo2)) {
            return true;
        }
        if (nodeInfo.getNodeKind() != nodeInfo2.getNodeKind()) {
            DeepEqual.a(unfailingErrorListener, "node kinds differ: comparing " + DeepEqual.a(nodeInfo) + " to " + DeepEqual.a(nodeInfo2), n2, nodeInfo, nodeInfo2);
            return false;
        }
        switch (nodeInfo.getNodeKind()) {
            case 1: {
                Object object;
                Object object2;
                Iterable<NodeInfo> iterable;
                Object object3;
                Object object4;
                if (!Navigator.haveSameName(nodeInfo, nodeInfo2)) {
                    DeepEqual.a(unfailingErrorListener, "element names differ: " + NameOfNode.makeName(nodeInfo).getStructuredQName().getEQName() + " != " + NameOfNode.makeName(nodeInfo2).getStructuredQName().getEQName(), n2, nodeInfo, nodeInfo2);
                    return false;
                }
                if ((n2 & 2) != 0 && !nodeInfo.getPrefix().equals(nodeInfo2.getPrefix())) {
                    DeepEqual.a(unfailingErrorListener, "element prefixes differ: " + nodeInfo.getPrefix() + " != " + nodeInfo2.getPrefix(), n2, nodeInfo, nodeInfo2);
                    return false;
                }
                Object object5 = nodeInfo.iterateAxis((byte)2);
                if (!SequenceTool.sameLength((SequenceIterator)object5, (SequenceIterator)(object4 = nodeInfo2.iterateAxis((byte)2)))) {
                    DeepEqual.a(unfailingErrorListener, "elements have different number of attributes", n2, nodeInfo, nodeInfo2);
                    return false;
                }
                object5 = nodeInfo.iterateAxis((byte)2);
                while ((object4 = object5.next()) != null) {
                    object3 = nodeInfo2.iterateAxis((byte)2, new SameNameTest((NodeInfo)object4));
                    iterable = object3.next();
                    if (iterable == null) {
                        DeepEqual.a(unfailingErrorListener, "one element has an attribute " + NameOfNode.makeName((NodeInfo)object4).getStructuredQName().getEQName() + ", the other does not", n2, nodeInfo, nodeInfo2);
                        return false;
                    }
                    if (DeepEqual.deepEquals((NodeInfo)object4, (NodeInfo)iterable, atomicComparer, configuration, unfailingErrorListener, n2)) continue;
                    DeepEqual.deepEquals((NodeInfo)object4, (NodeInfo)iterable, atomicComparer, configuration, unfailingErrorListener, n2);
                    DeepEqual.a(unfailingErrorListener, "elements have different values for the attribute " + NameOfNode.makeName((NodeInfo)object4).getStructuredQName().getEQName(), n2, nodeInfo, nodeInfo2);
                    return false;
                }
                if ((n2 & 1) != 0) {
                    object3 = new HashSet(10);
                    iterable = new HashSet(10);
                    object5 = nodeInfo.iterateAxis((byte)8);
                    while ((object4 = object5.next()) != null) {
                        object2 = new NamespaceBinding(object4.getLocalPart(), object4.getStringValue());
                        ((HashSet)object3).add(object2);
                    }
                    object2 = nodeInfo2.iterateAxis((byte)8);
                    while ((object = object2.next()) != null) {
                        object5 = new NamespaceBinding(object.getLocalPart(), object.getStringValue());
                        ((HashSet)iterable).add(object5);
                    }
                    if (!((AbstractSet)object3).equals(iterable)) {
                        DeepEqual.a(unfailingErrorListener, "elements have different in-scope namespaces: " + DeepEqual.a((HashSet<NamespaceBinding>)object3) + " versus " + DeepEqual.a(iterable), n2, nodeInfo, nodeInfo2);
                        return false;
                    }
                }
                if ((n2 & 0x40) != 0 && !nodeInfo.getSchemaType().equals(nodeInfo2.getSchemaType())) {
                    DeepEqual.a(unfailingErrorListener, "elements have different type annotation", n2, nodeInfo, nodeInfo2);
                    return false;
                }
                if ((n2 & 0x400) == 0) {
                    int n3;
                    int n4;
                    if (nodeInfo.getSchemaType().isComplexType() != nodeInfo2.getSchemaType().isComplexType()) {
                        DeepEqual.a(unfailingErrorListener, "one element has complex type, the other simple", n2, nodeInfo, nodeInfo2);
                        return false;
                    }
                    if (nodeInfo.getSchemaType().isComplexType() && (n4 = ((ComplexType)nodeInfo.getSchemaType()).getVariety()) != (n3 = ((ComplexType)nodeInfo2.getSchemaType()).getVariety())) {
                        DeepEqual.a(unfailingErrorListener, "both elements have complex type, but a different variety", n2, nodeInfo, nodeInfo2);
                        return false;
                    }
                }
                if ((n2 & 0x20) == 0) {
                    boolean bl2;
                    SchemaType schemaType = nodeInfo.getSchemaType();
                    SchemaType schemaType2 = nodeInfo2.getSchemaType();
                    boolean bl3 = schemaType.isSimpleType() || ((ComplexType)schemaType).isSimpleContent();
                    boolean bl4 = bl2 = schemaType2.isSimpleType() || ((ComplexType)schemaType2).isSimpleContent();
                    if (bl3 != bl2) {
                        DeepEqual.a(unfailingErrorListener, "one element has a simple type, the other does not", n2, nodeInfo, nodeInfo2);
                        return false;
                    }
                    if (bl3) {
                        object2 = nodeInfo.atomize().iterate();
                        object = nodeInfo2.atomize().iterate();
                        return DeepEqual.deepEqual((SequenceIterator)object2, (SequenceIterator)object, atomicComparer, configuration.getConversionContext(), n2);
                    }
                }
                if ((n2 & 0x200) != 0) {
                    if (nodeInfo.isId() != nodeInfo2.isId()) {
                        DeepEqual.a(unfailingErrorListener, "one element is an ID, the other is not", n2, nodeInfo, nodeInfo2);
                        return false;
                    }
                    if (nodeInfo.isIdref() != nodeInfo2.isIdref()) {
                        DeepEqual.a(unfailingErrorListener, "one element is an IDREF, the other is not", n2, nodeInfo, nodeInfo2);
                        return false;
                    }
                }
            }
            case 9: {
                Object object;
                AxisIterator axisIterator = nodeInfo.iterateAxis((byte)3);
                AxisIterator axisIterator2 = nodeInfo2.iterateAxis((byte)3);
                while (true) {
                    NodeInfo nodeInfo3;
                    NodeInfo nodeInfo4;
                    if ((nodeInfo4 = axisIterator.next()) != null && DeepEqual.a(nodeInfo4, n2)) {
                        continue;
                    }
                    while ((nodeInfo3 = axisIterator2.next()) != null && DeepEqual.a(nodeInfo3, n2)) {
                    }
                    if (nodeInfo4 == null || nodeInfo3 == null) {
                        boolean bl5 = nodeInfo4 == nodeInfo3;
                        if (!bl5) {
                            object = "the first operand contains a node with " + (nodeInfo4 == null ? "fewer" : "more") + " children than the second";
                            if (nodeInfo4 instanceof WhitespaceTextImpl || nodeInfo3 instanceof WhitespaceTextImpl) {
                                object = (String)object + " (the first extra child is whitespace text)";
                            }
                            DeepEqual.a(unfailingErrorListener, (String)object, n2, nodeInfo, nodeInfo2);
                        }
                        return bl5;
                    }
                    if (!DeepEqual.deepEquals(nodeInfo4, nodeInfo3, atomicComparer, configuration, unfailingErrorListener, n2)) break;
                }
                return false;
            }
            case 2: {
                if (!Navigator.haveSameName(nodeInfo, nodeInfo2)) {
                    DeepEqual.a(unfailingErrorListener, "attribute names differ: " + NameOfNode.makeName(nodeInfo).getStructuredQName().getEQName() + " != " + NameOfNode.makeName(nodeInfo).getStructuredQName().getEQName(), n2, nodeInfo, nodeInfo2);
                    return false;
                }
                if ((n2 & 2) != 0 && !nodeInfo.getPrefix().equals(nodeInfo2.getPrefix())) {
                    DeepEqual.a(unfailingErrorListener, "attribute prefixes differ: " + nodeInfo.getPrefix() + " != " + nodeInfo2.getPrefix(), n2, nodeInfo, nodeInfo2);
                    return false;
                }
                if ((n2 & 0x40) != 0 && !nodeInfo.getSchemaType().equals(nodeInfo2.getSchemaType())) {
                    DeepEqual.a(unfailingErrorListener, "attributes have different type annotations", n2, nodeInfo, nodeInfo2);
                    return false;
                }
                boolean bl6 = (n2 & 0x20) == 0 ? DeepEqual.deepEqual(nodeInfo.atomize().iterate(), nodeInfo2.atomize().iterate(), atomicComparer, configuration.getConversionContext(), 0) : atomicComparer.comparesEqual(new StringValue(nodeInfo.getStringValueCS()), new StringValue(nodeInfo2.getStringValueCS()));
                if (!bl6) {
                    DeepEqual.a(unfailingErrorListener, "attribute values differ", n2, nodeInfo, nodeInfo2);
                    return false;
                }
                if ((n2 & 0x200) != 0) {
                    if (nodeInfo.isId() != nodeInfo2.isId()) {
                        DeepEqual.a(unfailingErrorListener, "one attribute is an ID, the other is not", n2, nodeInfo, nodeInfo2);
                        return false;
                    }
                    if (nodeInfo.isIdref() != nodeInfo2.isIdref()) {
                        DeepEqual.a(unfailingErrorListener, "one attribute is an IDREF, the other is not", n2, nodeInfo, nodeInfo2);
                        return false;
                    }
                }
                return true;
            }
            case 7: 
            case 13: {
                if (!nodeInfo.getLocalPart().equals(nodeInfo2.getLocalPart())) {
                    DeepEqual.a(unfailingErrorListener, Type.displayTypeName(nodeInfo) + " names differ", n2, nodeInfo, nodeInfo2);
                    return false;
                }
            }
            case 3: 
            case 8: {
                boolean bl7 = atomicComparer.comparesEqual((AtomicValue)nodeInfo.atomize(), (AtomicValue)nodeInfo2.atomize());
                if (!bl7 && (n2 & 0x80) != 0) {
                    String string = nodeInfo.atomize().getStringValue();
                    String string2 = nodeInfo2.atomize().getStringValue();
                    String string3 = "";
                    if (string.length() != string2.length()) {
                        string3 = "lengths (" + string.length() + "," + string2.length() + ")";
                    }
                    if (string.length() < 10 && string2.length() < 10) {
                        string3 = " (\"" + string + "\" vs \"" + string2 + "\")";
                    } else {
                        int n5 = Math.min(string.length(), string2.length());
                        if (string.substring(0, n5).equals(string2.substring(0, n5))) {
                            string3 = string3 + " different at char " + n5 + "(\"" + StringValue.diagnosticDisplay((string.length() > string2.length() ? string : string2).substring(n5)) + "\")";
                        } else if (string.charAt(0) != string2.charAt(0)) {
                            string3 = string3 + " different at start (\"" + string.substring(0, Math.min(string.length(), 10)) + "\", \"" + string2.substring(0, Math.min(string2.length(), 10)) + "\")";
                        } else {
                            for (int i2 = 1; i2 < n5; ++i2) {
                                if (string.substring(0, i2).equals(string2.substring(0, i2))) continue;
                                string3 = string3 + " different at char " + (i2 - 1) + "(\"" + string.substring(i2 - 1, Math.min(string.length(), i2 + 10)) + "\", \"" + string2.substring(i2 - 1, Math.min(string2.length(), i2 + 10)) + "\")";
                                break;
                            }
                        }
                    }
                    DeepEqual.a(unfailingErrorListener, Type.displayTypeName(nodeInfo) + " values differ (" + Navigator.getPath(nodeInfo) + ", " + Navigator.getPath(nodeInfo2) + "): " + string3, n2, nodeInfo, nodeInfo2);
                }
                return bl7;
            }
        }
        throw new IllegalArgumentException("Unknown node type");
    }

    private static boolean a(NodeInfo nodeInfo, int n2) {
        int n3 = nodeInfo.getNodeKind();
        if (n3 == 8) {
            return (n2 & 4) == 0;
        }
        if (n3 == 7) {
            return (n2 & 8) == 0;
        }
        if (n3 == 3) {
            return (n2 & 0x10) != 0 && Whitespace.isWhite(nodeInfo.getStringValueCS());
        }
        return false;
    }

    private static void a(UnfailingErrorListener unfailingErrorListener, String string, int n2, NodeInfo nodeInfo, NodeInfo nodeInfo2) {
        if ((n2 & 0x80) != 0) {
            unfailingErrorListener.warning(new XPathException("deep-equal() " + (nodeInfo != null && nodeInfo2 != null ? "comparing " + Navigator.getPath(nodeInfo) + " to " + Navigator.getPath(nodeInfo2) + ": " : ": ") + string));
        }
    }

    private static String a(NodeInfo nodeInfo) {
        if (nodeInfo instanceof NodeInfo && nodeInfo.getNodeKind() == 3 && Whitespace.isWhite(nodeInfo.getStringValueCS())) {
            return "whitespace text() node";
        }
        return Type.displayTypeName(nodeInfo);
    }

    private static String a(HashSet<NamespaceBinding> object) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
        object = ((HashSet)object).iterator();
        while (object.hasNext()) {
            NamespaceBinding namespaceBinding = (NamespaceBinding)object.next();
            fastStringBuffer.append(namespaceBinding.getPrefix());
            fastStringBuffer.append("=");
            fastStringBuffer.append(namespaceBinding.getURI());
            fastStringBuffer.append(" ");
        }
        FastStringBuffer fastStringBuffer2 = fastStringBuffer;
        fastStringBuffer2.setLength(fastStringBuffer2.length() - 1);
        return fastStringBuffer.toString();
    }

    private static ListIterator a(SequenceIterator sequenceIterator) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>(20);
        boolean bl2 = false;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        while ((object = sequenceIterator.next()) != null) {
            if (object instanceof NodeInfo && ((NodeInfo)object).getNodeKind() == 3) {
                fastStringBuffer.append(object.getStringValueCS());
                bl2 = true;
                continue;
            }
            if (bl2) {
                Orphan orphan = new Orphan(null);
                orphan.setNodeKind((short)3);
                orphan.setStringValue(fastStringBuffer.toString());
                arrayList.add(orphan);
                fastStringBuffer.setLength(0);
            }
            bl2 = false;
            arrayList.add(object);
        }
        if (bl2) {
            object = new Orphan(null);
            ((Orphan)object).setNodeKind((short)3);
            ((Orphan)object).setStringValue(fastStringBuffer.toString());
            arrayList.add(object);
        }
        object = new SequenceExtent(arrayList);
        return ((SequenceExtent)object).iterate();
    }

    public BooleanValue call(XPathContext xPathContext, Sequence[] sequenceArray) {
        GenericAtomicComparer genericAtomicComparer = new GenericAtomicComparer(this.getStringCollator(), xPathContext);
        boolean bl2 = DeepEqual.deepEqual(sequenceArray[0].iterate(), sequenceArray[1].iterate(), genericAtomicComparer, xPathContext, 0);
        return BooleanValue.get(bl2);
    }

    @Override
    public String getStreamerName() {
        return "DeepEqual";
    }
}

