/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.HashSet;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.value.AtomicValue;

public class DistinctValues
extends CollatingFunctionFixed {
    @Override
    public String getStreamerName() {
        return "DistinctValues";
    }

    public Sequence<AtomicValue> call(XPathContext xPathContext, Sequence[] sequenceArray) {
        StringCollator stringCollator = this.getStringCollator();
        return SequenceTool.toLazySequence(new DistinctIterator(sequenceArray[0].iterate(), stringCollator, xPathContext));
    }

    public static class DistinctIterator
    implements SequenceIterator<AtomicValue> {
        private SequenceIterator<? extends AtomicValue> a;
        private StringCollator b;
        private XPathContext c;
        private HashSet<AtomicMatchKey> d = new HashSet(40);

        public DistinctIterator(SequenceIterator<? extends AtomicValue> sequenceIterator, StringCollator stringCollator, XPathContext xPathContext) {
            this.a = sequenceIterator;
            this.b = stringCollator;
            this.c = xPathContext;
        }

        @Override
        public AtomicValue next() {
            AtomicValue atomicValue;
            AtomicMatchKey atomicMatchKey;
            int n2 = this.c.getImplicitTimezone();
            do {
                if ((atomicValue = this.a.next()) != null) continue;
                return null;
            } while (!this.d.add(atomicMatchKey = atomicValue.isNaN() ? AtomicMatchKey.NaN_MATCH_KEY : atomicValue.getXPathComparable(false, this.b, n2)));
            return atomicValue;
        }

        @Override
        public void close() {
            this.a.close();
        }

        @Override
        public int getProperties() {
            return 0;
        }
    }
}

