/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.sort.DocumentOrderIterator;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.RelativeURIResolver;
import net.sf.saxon.lib.StandardErrorHandler;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.NonDelegatingURIResolver;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.value.Cardinality;
import org.xml.sax.ErrorHandler;

public class DocumentFn
extends SystemFunction
implements Callable {
    private Location a;

    @Override
    public int getCardinality(Expression[] object) {
        if (Cardinality.allowsMany((object = object[0]).getCardinality())) {
            return 57344;
        }
        return 24576;
    }

    @Override
    public int getSpecialProperties(Expression[] expressionArray) {
        return 0x8A0000;
    }

    @Override
    public Expression makeFunctionCall(Expression ... expressionArray) {
        this.a = expressionArray[0].getLocation();
        Expression expression = Doc.maybePreEvaluate(this, expressionArray);
        if (expression == null) {
            return super.makeFunctionCall(expressionArray);
        }
        return expression;
    }

    @Override
    public Sequence<?> call(XPathContext object, Sequence[] object2) {
        int n2 = this.getArity();
        SequenceIterator sequenceIterator = object2[0].iterate();
        String string = null;
        if (n2 == 2 && (string = (object2 = (NodeInfo)object2[1].head()).getBaseURI()) == null) {
            throw new XPathException("The second argument to document() is a node with no base URI", "XTDE1162");
        }
        object2 = new a((XPathContext)object);
        new a((XPathContext)object).a = string;
        object2.b = this.getStaticBaseUriString();
        object2.d = this.getRetainedStaticContext().getPackageData();
        object2.c = this.a;
        object = new ItemMappingIterator(sequenceIterator, object2);
        return SequenceTool.toLazySequence(new DocumentOrderIterator((SequenceIterator<?>)object, GlobalOrderComparer.getInstance()));
    }

    public static NodeInfo makeDoc(String object, String object2, PackageData object3, ParseOptions parseOptions, XPathContext xPathContext, Location location, boolean bl2) {
        Controller controller;
        Configuration configuration = xPathContext.getConfiguration();
        int n2 = ((String)object).indexOf(35);
        String string = null;
        if (n2 >= 0) {
            if (n2 == ((String)object).length() - 1) {
                object = ((String)object).substring(0, n2);
            } else {
                string = ((String)object).substring(n2 + 1);
                object = ((String)object).substring(0, n2);
                if (!NameChecker.isValidNCName(string)) {
                    XPathException xPathException = new XPathException("The fragment identifier " + Err.wrap(string) + " is not a valid NCName");
                    xPathException.setErrorCode("XTRE1160");
                    xPathException.setXPathContext(xPathContext);
                    xPathException.setLocator(location);
                    throw xPathException;
                }
            }
        }
        if ((controller = xPathContext.getController()) == null) {
            throw new XPathException("doc() function is not available in this environment");
        }
        DocumentURI documentURI = DocumentFn.computeDocumentKey((String)object, (String)object2, (PackageData)object3, xPathContext);
        Object object4 = configuration.getGlobalDocumentPool().find(documentURI);
        if (object4 != null) {
            return object4.getRootNode();
        }
        DocumentPool documentPool = controller.getDocumentPool();
        Object object5 = controller;
        synchronized (object5) {
            object4 = documentPool.find(documentURI);
            if (object4 != null) {
                return DocumentFn.a((TreeInfo)object4, string, xPathContext, location);
            }
            if (controller instanceof XsltController && !((XsltController)controller).checkUniqueOutputDestination(documentURI)) {
                documentPool.markUnavailable(documentURI);
                object = new XPathException("Cannot read a document that was written during the same transformation: " + documentURI);
                ((XPathException)object).setXPathContext(xPathContext);
                ((XPathException)object).setErrorCode("XTRE1500");
                ((TransformerException)object).setLocator(location);
                throw object;
            }
            if (documentPool.isMarkedUnavailable(documentURI)) {
                object = new XPathException("Document has been marked not available: " + documentURI);
                ((XPathException)object).setXPathContext(xPathContext);
                ((XPathException)object).setErrorCode("FODC0002");
                ((TransformerException)object).setLocator(location);
                throw object;
            }
        }
        try {
            object5 = DocumentFn.resolveURI((String)object, (String)object2, documentURI.toString(), xPathContext);
            object5 = configuration.getSourceResolver().resolveSource((Source)object5, configuration);
            if (object5 instanceof NodeInfo || object5 instanceof DOMSource) {
                object2 = controller.prepareInputTree((Source)object5);
                object = object2.getTreeInfo();
            } else {
                object2 = controller.makeBuilder();
                ((Builder)object2).setUseEventLocation(true);
                if (object2 instanceof TinyBuilder) {
                    ((TinyBuilder)object2).setStatistics(configuration.getTreeStatistics().SOURCE_DOCUMENT_STATISTICS);
                }
                object = object2;
                if (parseOptions == null) {
                    parseOptions = new ParseOptions(((Builder)object2).getPipelineConfiguration().getParseOptions());
                    if (object3 instanceof StylesheetPackage && (object4 = ((StylesheetPackage)object3).getSpaceStrippingRule()) != NoElementsSpaceStrippingRule.getInstance()) {
                        parseOptions.setSpaceStrippingRule((SpaceStrippingRule)object4);
                    }
                    parseOptions.setSchemaValidationMode(controller.getSchemaValidationMode());
                }
                ((Builder)object2).getPipelineConfiguration().setParseOptions(parseOptions);
                if (parseOptions.isLineNumbering()) {
                    ((Builder)object2).setLineNumbering(true);
                }
                if (bl2) {
                    object4 = new StandardErrorHandler(controller.getErrorListener());
                    ((StandardErrorHandler)object4).setSilent(true);
                    parseOptions.setErrorHandler((ErrorHandler)object4);
                }
                if (object3 instanceof StylesheetPackage && ((StylesheetPackage)object3).isStripsTypeAnnotations()) {
                    object = configuration.getAnnotationStripper((Receiver)object);
                }
                if ((object4 = controller.getPathMapForDocumentProjection()) != null && (object3 = ((PathMap)object4).getRootForDocument(documentURI.toString())) != null && !((PathMap.PathMapNode)object3).isReturnable() && !((PathMap.PathMapNode)object3).hasUnknownDependencies()) {
                    parseOptions.addFilter(configuration.makeDocumentProjector((PathMap.PathMapRoot)object3));
                }
                object.setPipelineConfiguration(((Builder)object2).getPipelineConfiguration());
                try {
                    Sender.send((Source)object5, (Receiver)object, parseOptions);
                    object = ((Builder)object2).getCurrentRoot().getTreeInfo();
                    ((Builder)object2).reset();
                }
                catch (XPathException xPathException) {
                    object3 = xPathException;
                    if (xPathException.getErrorCodeLocalPart() == null || ((XPathException)object3).getErrorCodeLocalPart().equals("SXXP0003")) {
                        ((XPathException)object3).setErrorCode("FODC0002");
                    }
                    throw object3;
                }
                finally {
                    if (parseOptions.isPleaseCloseAfterUse()) {
                        ParseOptions.close((Source)object5);
                    }
                }
            }
            object2 = controller;
            synchronized (object2) {
                object4 = documentPool.find(documentURI);
                if (object4 != null) {
                    return DocumentFn.a((TreeInfo)object4, string, xPathContext, location);
                }
                controller.registerDocument((TreeInfo)object, documentURI);
                if (controller instanceof XsltController) {
                    ((XsltController)controller).addUnavailableOutputDestination(documentURI);
                }
            }
            return DocumentFn.a((TreeInfo)object, string, xPathContext, location);
        }
        catch (TransformerException transformerException) {
            documentPool.markUnavailable(documentURI);
            object = XPathException.makeXPathException(transformerException);
            ((XPathException)object).maybeSetLocation(location);
            object2 = transformerException.getException() instanceof URISyntaxException ? "FODC0005" : "FODC0002";
            ((XPathException)object).maybeSetErrorCode((String)object2);
            throw object;
        }
    }

    public static Source resolveURI(String object, String string, String string2, XPathContext xPathContext) {
        Object object2;
        URIResolver uRIResolver = xPathContext.getURIResolver();
        if (string == null) {
            try {
                object2 = new URI((String)object);
                if (!((URI)object2).isAbsolute()) {
                    throw new XPathException("Relative URI passed to document() function (" + (String)object + "); but no base URI is available", "XTDE1162");
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new XPathException("Invalid URI passed to document() function: " + (String)object, "FODC0005");
            }
        }
        try {
            object2 = uRIResolver instanceof RelativeURIResolver && string2 != null ? ((RelativeURIResolver)uRIResolver).dereference(string2) : uRIResolver.resolve((String)object, string);
        }
        catch (Exception exception) {
            object = new XPathException("Exception thrown by URIResolver", exception);
            if (xPathContext.getConfiguration().getBooleanProperty(Feature.TRACE_EXTERNAL_FUNCTIONS)) {
                exception.printStackTrace();
            }
            throw object;
        }
        if (object2 instanceof StreamSource && ((StreamSource)object2).getInputStream() == null && ((StreamSource)object2).getReader() == null) {
            object2 = object2.getSystemId();
            uRIResolver = xPathContext.getController().getStandardURIResolver();
            try {
                object2 = uRIResolver.resolve((String)object2, "");
            }
            catch (TransformerException transformerException) {
                object = transformerException;
                throw XPathException.makeXPathException(transformerException);
            }
        }
        if (object2 == null && !(uRIResolver instanceof NonDelegatingURIResolver)) {
            uRIResolver = xPathContext.getController().getStandardURIResolver();
            try {
                object2 = uRIResolver instanceof RelativeURIResolver && string2 != null ? ((RelativeURIResolver)uRIResolver).dereference(string2) : uRIResolver.resolve((String)object, string);
            }
            catch (TransformerException transformerException) {
                object2 = transformerException;
                throw XPathException.makeXPathException(transformerException);
            }
        }
        return object2;
    }

    protected static DocumentURI computeDocumentKey(String string, String string2, PackageData packageData, XPathContext object) {
        URIResolver uRIResolver = ((Controller)(object = object.getController())).getURIResolver();
        if (uRIResolver == null) {
            uRIResolver = ((Controller)object).getStandardURIResolver();
        }
        return DocumentFn.computeDocumentKey(string, string2, packageData, uRIResolver, true);
    }

    public static DocumentURI computeDocumentKey(String string, String string2, PackageData packageData, URIResolver object, boolean bl2) {
        Object object2;
        if (object instanceof RelativeURIResolver) {
            try {
                object = ((RelativeURIResolver)object).makeAbsolute(string, string2);
            }
            catch (TransformerException transformerException) {
                object = "/" + string;
            }
        } else {
            string = ResolveURI.escapeSpaces(string);
            if (string2 == null) {
                try {
                    object = new URI(string).toString();
                }
                catch (URISyntaxException uRISyntaxException) {
                    object = "/" + string;
                }
            } else if (string.isEmpty()) {
                object = string2;
            } else {
                try {
                    object2 = new URI(string2).resolve(string);
                    object = ((URI)object2).toString();
                }
                catch (IllegalArgumentException | URISyntaxException exception) {
                    object = string2 + "/../" + string;
                }
            }
        }
        if (bl2 && packageData instanceof StylesheetPackage && ((StylesheetPackage)packageData).getSpaceStrippingRule() != NoElementsSpaceStrippingRule.getInstance() && (object2 = ((StylesheetPackage)packageData).getPackageName()) != null) {
            object = (String)object2 + " " + ((StylesheetPackage)packageData).getPackageVersion() + " " + (String)object;
        }
        return new DocumentURI((String)object);
    }

    public static NodeInfo preLoadDoc(String object, String object2, Configuration configuration, SourceLocator sourceLocator) {
        Object object3;
        String string;
        int n2 = ((String)object).indexOf(35);
        if (n2 >= 0) {
            throw new XPathException("Fragment identifier not supported for preloaded documents");
        }
        Object object4 = configuration.getURIResolver();
        if (object4 instanceof RelativeURIResolver) {
            try {
                string = ((RelativeURIResolver)object4).makeAbsolute((String)object, (String)object2);
            }
            catch (TransformerException transformerException) {
                string = "/" + (String)object;
                object2 = "";
            }
        } else if (object2 == null) {
            try {
                string = new URI((String)object).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                string = "/" + (String)object;
                object2 = "";
            }
        } else if (((String)object).isEmpty()) {
            string = object2;
        } else {
            try {
                object3 = new URI((String)object2).resolve((String)object);
                string = ((URI)object3).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                string = (String)object2 + "/../" + (String)object;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = (String)object2 + "/../" + (String)object;
            }
        }
        object3 = configuration.getGlobalDocumentPool().find(string);
        if (object3 != null) {
            return object3.getRootNode();
        }
        try {
            object3 = null;
            if (object4 != null) {
                try {
                    object3 = object4.resolve((String)object, (String)object2);
                }
                catch (Exception exception) {
                    object2 = new XPathException("Exception thrown by URIResolver", exception);
                    if (configuration.getBooleanProperty(Feature.TRACE_EXTERNAL_FUNCTIONS)) {
                        exception.printStackTrace();
                    }
                    ((TransformerException)object2).setLocator(sourceLocator);
                    throw object2;
                }
            }
            if (object3 == null && !(object4 instanceof NonDelegatingURIResolver)) {
                object4 = configuration.getSystemURIResolver();
                object3 = object4.resolve((String)object, (String)object2);
            }
            object3 = configuration.getSourceResolver().resolveSource((Source)object3, configuration);
            object = configuration.buildDocumentTree((Source)object3);
            configuration.getGlobalDocumentPool().add((TreeInfo)object, string);
            return object.getRootNode();
        }
        catch (TransformerException transformerException) {
            object4 = transformerException;
            object3 = XPathException.makeXPathException(transformerException);
            ((TransformerException)object3).setLocator(sourceLocator);
            ((XPathException)object3).setErrorCode("FODC0002");
            throw new XPathException((Throwable)object4);
        }
    }

    public static void sendDoc(String object, String string, XPathContext object2, Location location, Receiver receiver, ParseOptions parseOptions) {
        Object object3;
        Object object4;
        PipelineConfiguration pipelineConfiguration = receiver.getPipelineConfiguration();
        if (pipelineConfiguration == null) {
            pipelineConfiguration = object2.getController().makePipelineConfiguration();
            pipelineConfiguration.setXPathContext((XPathContext)object2);
            receiver.setPipelineConfiguration(pipelineConfiguration);
        }
        if (string == null) {
            try {
                object4 = new URI((String)object).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                object4 = "/" + (String)object;
                string = "";
            }
        } else if (((String)object).isEmpty()) {
            object4 = string;
        } else {
            try {
                object3 = new URI(string).resolve((String)object);
                object4 = ((URI)object3).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                object4 = string + "/../" + (String)object;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object4 = string + "/../" + (String)object;
            }
        }
        object3 = object2.getController();
        object2 = ((Controller)object3).getDocumentPool().find((String)object4);
        object4 = null;
        if (object2 != null) {
            object4 = object2.getRootNode();
        } else {
            try {
                object2 = ((Controller)object3).getURIResolver();
                if (object2 != null) {
                    object4 = object2.resolve((String)object, string);
                }
                if (object4 == null) {
                    object2 = ((Controller)object3).getStandardURIResolver();
                    object4 = object2.resolve((String)object, string);
                }
                if (object4 instanceof NodeInfo || object4 instanceof DOMSource) {
                    object = ((Controller)object3).prepareInputTree((Source)object4);
                    object4 = object.getRoot();
                }
            }
            catch (TransformerException transformerException) {
                object2 = transformerException;
                object = XPathException.makeXPathException(transformerException);
                ((TransformerException)object).setLocator(location);
                ((XPathException)object).maybeSetErrorCode("FODC0005");
                throw object;
            }
        }
        if (((Controller)object3).getConfiguration().isTiming()) {
            ((Controller)object3).getConfiguration().getLogger().info("Streaming input document " + object4.getSystemId());
        }
        receiver.setPipelineConfiguration(pipelineConfiguration);
        try {
            Sender.send((Source)object4, receiver, parseOptions);
            return;
        }
        catch (XPathException xPathException) {
            object2 = xPathException;
            xPathException.maybeSetLocation(location);
            ((XPathException)object2).maybeSetErrorCode("FODC0002");
            throw object2;
        }
    }

    private static NodeInfo a(TreeInfo treeInfo, String object, XPathContext xPathContext, Location location) {
        if (object == null) {
            return treeInfo.getRootNode();
        }
        if (!NameChecker.isValidNCName((CharSequence)object)) {
            object = new XPathException("Invalid fragment identifier in URI");
            ((XPathException)object).setXPathContext(xPathContext);
            ((XPathException)object).setErrorCode("XTRE1160");
            ((TransformerException)object).setLocator(location);
            try {
                xPathContext.getController().recoverableError((XPathException)object);
            }
            catch (XPathException xPathException) {
                throw object;
            }
            return treeInfo.getRootNode();
        }
        return treeInfo.selectID((String)object, false);
    }

    private static final class a
    implements ItemMappingFunction {
        public String a;
        public String b;
        public Location c;
        public PackageData d;
        private XPathContext e;

        public a(XPathContext xPathContext) {
            this.e = xPathContext;
        }

        public final Item mapItem(Item object) {
            String string = this.a;
            if (string == null) {
                string = object instanceof NodeInfo ? ((NodeInfo)object).getBaseURI() : this.b;
            }
            try {
                return DocumentFn.makeDoc(object.getStringValue(), string, this.d, null, this.e, this.c, false);
            }
            catch (XPathException xPathException) {
                XPathException xPathException2 = xPathException;
                switch (xPathException.getErrorCodeLocalPart()) {
                    case "XTRE1160": {
                        xPathException2.setErrorCode("XTDE1160");
                        try {
                            this.e.getController().recoverableError(xPathException2);
                        }
                        catch (XPathException xPathException3) {
                            throw xPathException2;
                        }
                        object = object.getStringValue();
                        int n2 = ((String)object).indexOf(35);
                        object = ((String)object).substring(0, n2);
                        return DocumentFn.makeDoc((String)object, string, this.d, null, this.e, this.c, false);
                    }
                    case "XTDE1162": {
                        throw xPathException2;
                    }
                }
                if (!xPathException2.hasBeenReported()) {
                    xPathException2.maybeSetLocation(this.c);
                    object = xPathException2.getException() instanceof URISyntaxException ? "FODC0005" : "FODC0002";
                    xPathException2.maybeSetErrorCode((String)object);
                    try {
                        this.e.getController().recoverableError(xPathException2);
                    }
                    catch (XPathException xPathException4) {
                        throw xPathException2;
                    }
                } else {
                    throw xPathException2;
                }
                return null;
            }
        }
    }
}

