/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.StringValue;

public abstract class DynamicContextAccessor
extends SystemFunction {
    private AtomicValue a;

    public void bindContext(XPathContext xPathContext) {
        this.a = this.evaluate(xPathContext);
    }

    public abstract AtomicValue evaluate(XPathContext var1);

    public AtomicValue call(XPathContext xPathContext, Sequence[] sequenceArray) {
        if (this.a != null) {
            return this.a;
        }
        return this.evaluate(xPathContext);
    }

    @Override
    public Expression makeFunctionCall(Expression[] expressionArray) {
        DynamicContextAccessor dynamicContextAccessor = this;
        return new SystemFunctionCall(dynamicContextAccessor, dynamicContextAccessor, expressionArray){
            private /* synthetic */ DynamicContextAccessor a;
            {
                this.a = dynamicContextAccessor;
                super(dynamicContextAccessor2, expressionArray);
            }

            public final Item evaluateItem(XPathContext xPathContext) {
                return this.a.evaluate(xPathContext);
            }

            @Override
            public final int getIntrinsicDependencies() {
                return 1024;
            }
        };
    }

    public static class DefaultLanguage
    extends DynamicContextAccessor {
        @Override
        public AtomicValue evaluate(XPathContext object) {
            object = object.getConfiguration().getDefaultLanguage();
            return new StringValue((CharSequence)object, BuiltInAtomicType.LANGUAGE);
        }
    }

    public static class CurrentTime
    extends DynamicContextAccessor {
        @Override
        public AtomicValue evaluate(XPathContext object) {
            object = DateTimeValue.getCurrentDateTime((XPathContext)object);
            return ((DateTimeValue)object).toTimeValue();
        }
    }

    public static class CurrentDate
    extends DynamicContextAccessor {
        @Override
        public AtomicValue evaluate(XPathContext object) {
            object = DateTimeValue.getCurrentDateTime((XPathContext)object);
            return ((DateTimeValue)object).toDateValue();
        }
    }

    public static class CurrentDateTime
    extends DynamicContextAccessor {
        @Override
        public AtomicValue evaluate(XPathContext xPathContext) {
            return DateTimeValue.getCurrentDateTime(xPathContext);
        }
    }

    public static class ImplicitTimezone
    extends DynamicContextAccessor {
        @Override
        public AtomicValue evaluate(XPathContext object) {
            object = DateTimeValue.getCurrentDateTime((XPathContext)object);
            return ((AtomicValue)object).getComponent(AccessorFn.Component.TIMEZONE);
        }
    }
}

