/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ScalarSystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.serialize.charcode.UTF8CharacterSet;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class EncodeForUri
extends ScalarSystemFunction {
    private static int[] a = new int[]{1, 1, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1, 2, 2, 3, 4};

    @Override
    public AtomicValue evaluate(Item object, XPathContext xPathContext) {
        object = object.getStringValueCS();
        return StringValue.makeStringValue(EncodeForUri.escape((CharSequence)object, "-_.~"));
    }

    @Override
    public ZeroOrOne<? extends AtomicValue> resultWhenEmpty() {
        return ZERO_LENGTH_STRING;
    }

    public static CharSequence escape(CharSequence charSequence, String string) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9') {
                fastStringBuffer.append(c2);
                continue;
            }
            if (c2 <= ' ' || c2 >= '\u007f') {
                EncodeForUri.escapeChar(c2, i2 + 1 < charSequence.length() ? charSequence.charAt(i2 + 1) : (char)' ', fastStringBuffer);
                continue;
            }
            if (string.indexOf(c2) >= 0) {
                fastStringBuffer.append(c2);
                continue;
            }
            EncodeForUri.escapeChar(c2, ' ', fastStringBuffer);
        }
        return fastStringBuffer;
    }

    public static void escapeChar(char c2, char c3, FastStringBuffer fastStringBuffer) {
        byte[] byArray = new byte[4];
        c2 = (char)UTF8CharacterSet.getUTF8Encoding(c2, c3, byArray);
        for (c3 = '\u0000'; c3 < c2; c3 = (char)(c3 + 1)) {
            int n2 = byArray[c3] & 0xFF;
            fastStringBuffer.append('%');
            fastStringBuffer.append("0123456789ABCDEF".charAt(n2 / 16));
            fastStringBuffer.append("0123456789ABCDEF".charAt(n2 % 16));
        }
    }

    public static void checkPercentEncoding(String string) {
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 == '%') {
                int n3;
                if (n2 + 2 >= string.length()) {
                    throw new XPathException("% sign in URI must be followed by two hex digits" + Err.wrap(string));
                }
                int n4 = "0123456789abcdefABCDEF".indexOf(string.charAt(n2 + 1));
                if (n4 > 15) {
                    n4 -= 6;
                }
                if ((n3 = "0123456789abcdefABCDEF".indexOf(string.charAt(n2 + 2))) > 15) {
                    n3 -= 6;
                }
                if (n4 >= 0 && n3 >= 0) {
                    n3 = n4 << 4 | n3;
                    int n5 = a[n4];
                    if (n5 == -1) {
                        throw new XPathException("First %-encoded octet in URI is not valid as the start of a UTF-8 character: first two bits must not be '10'" + Err.wrap(string));
                    }
                    byte[] byArray = new byte[n5];
                    byte[] byArray2 = byArray;
                    byArray[0] = (byte)n3;
                    n2 += 3;
                    for (int i2 = 1; i2 < n5; ++i2) {
                        if (n2 + 2 > string.length() || string.charAt(n2) != '%') {
                            throw new XPathException("Incomplete %-encoded UTF-8 octet sequence in URI " + Err.wrap(string));
                        }
                        n4 = "0123456789abcdefABCDEF".indexOf(string.charAt(n2 + 1));
                        if (n4 > 15) {
                            n4 -= 6;
                        }
                        if ((n3 = "0123456789abcdefABCDEF".indexOf(string.charAt(n2 + 2))) > 15) {
                            n3 -= 6;
                        }
                        if (n4 < 0 || n3 < 0) {
                            throw new XPathException("Invalid %-encoded UTF-8 octet sequence in URI" + Err.wrap(string));
                        }
                        if (a[n4] != -1) {
                            throw new XPathException("In a URI, a %-encoded UTF-8 octet after the first must have '10' as the first two bits" + Err.wrap(string));
                        }
                        n3 = n4 << 4 | n3;
                        byArray2[i2] = (byte)n3;
                        n2 += 3;
                    }
                    continue;
                }
                throw new XPathException("% sign in URI must be followed by two hex digits" + Err.wrap(string));
            }
            ++n2;
        }
    }
}

