/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Arrays;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.number.AbstractNumberer;
import net.sf.saxon.expr.number.Alphanumeric;
import net.sf.saxon.expr.number.NamedTimeZone;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.expr.number.NumericGroupFormatter;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.functions.FormatInteger;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.regex.charclass.Categories;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.Whitespace;

public class FormatDate
extends SystemFunction
implements Callable {
    private static String[] a = new String[]{"AD", "AH", "AME", "AM", "AP", "AS", "BE", "CB", "CE", "CL", "CS", "EE", "FE", "ISO", "JE", "KE", "KY", "ME", "MS", "NS", "OS", "RS", "SE", "SH", "SS", "TE", "VE", "VS"};
    private static Pattern b = Pattern.compile("([YMDdWwFHhmsfZzPCE])\\s*(.*)");
    private static Pattern c;
    private static Pattern d;
    private static Pattern e;
    private static Pattern f;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CharSequence a(StringValue object, CharSequence charSequence, XPathContext xPathContext) {
        try {
            object = ((AtomicValue)object).getStringValue();
            object = StructuredQName.fromLexicalQName((CharSequence)object, false, true, this.getRetainedStaticContext());
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = new XPathException("Invalid calendar name. " + xPathException.getMessage());
            xPathException2.setErrorCode("FOFD1340");
            xPathException2.setXPathContext(xPathContext);
            throw xPathException2;
        }
        if (!((StructuredQName)object).hasURI("")) return "[Calendar: AD]" + charSequence;
        if (((String)(object = ((StructuredQName)object).getLocalPart())).equals("AD")) return charSequence;
        if (((String)object).equals("ISO")) return charSequence;
        if (Arrays.binarySearch(a, object) >= 0) {
            return "[Calendar: AD]" + charSequence;
        }
        object = new XPathException("Unknown no-namespace calendar: " + (String)object);
        ((XPathException)object).setErrorCode("FOFD1340");
        ((XPathException)object).setXPathContext(xPathContext);
        throw object;
    }

    private static CharSequence a(String object, int n2, String string, boolean bl2, Numberer numberer, XPathContext xPathContext) {
        int n3;
        NumericGroupFormatter numericGroupFormatter;
        int n4;
        int n5;
        String string2;
        String string3;
        String string4;
        block48: {
            StringBuilder stringBuilder;
            UnicodeString unicodeString;
            int n6;
            while (true) {
                int n7;
                int n8 = string.lastIndexOf(44);
                String string5 = "";
                if (n8 >= 0) {
                    string5 = string.substring(n8);
                    string = string.substring(0, n8);
                }
                string4 = string;
                string3 = null;
                if (string4.endsWith("t")) {
                    string4 = string4.substring(0, string4.length() - 1);
                    string3 = "t";
                } else if (string4.endsWith("o")) {
                    string4 = string4.substring(0, string4.length() - 1);
                    string3 = "o";
                }
                string2 = "t".equals(string3) ? "traditional" : null;
                string3 = "o".equals(string3) ? numberer.getOrdinalSuffixForDateTime((String)object) : null;
                n5 = 1;
                n4 = Integer.MAX_VALUE;
                if (d.matcher(string4).matches() && (n7 = StringValue.getStringLength(string4)) > 1) {
                    n5 = n7;
                    n4 = n7;
                }
                if ("Y".equals(object)) {
                    n4 = 0;
                    n5 = 0;
                    if (!string5.isEmpty()) {
                        n4 = FormatDate.a(string5)[1];
                    } else if (d.matcher(string4).find()) {
                        UnicodeString unicodeString2 = UnicodeString.makeUnicodeString(string4);
                        for (int i2 = 0; i2 < unicodeString2.uLength(); ++i2) {
                            n6 = unicodeString2.uCharAt(i2);
                            if (n6 == 35) {
                                ++n4;
                                continue;
                            }
                            if ((n6 < 48 || n6 > 57) && !Categories.ESCAPE_d.test(n6)) continue;
                            ++n5;
                            ++n4;
                        }
                    }
                    if (n4 <= 1) {
                        n4 = Integer.MAX_VALUE;
                    }
                    if (n4 < 4 || n4 < Integer.MAX_VALUE && n2 > 9999) {
                        n2 %= (int)Math.pow(10.0, n4);
                    }
                }
                if (string4.equals("I") || string4.equals("i")) {
                    int[] nArray = FormatDate.a(string5);
                    n5 = nArray[0];
                    String string6 = numberer.format(n2, UnicodeString.makeUnicodeString(string4), null, string2, string3);
                    StringBuilder stringBuilder2 = new StringBuilder(string6);
                    for (int i3 = StringValue.getStringLength(string6); i3 < n5; ++i3) {
                        stringBuilder2.append(' ');
                    }
                    return stringBuilder2.toString();
                }
                if (!string5.isEmpty()) {
                    int[] nArray = FormatDate.a(string5);
                    n5 = Math.max(n5, nArray[0]);
                    n4 = n4 == Integer.MAX_VALUE ? nArray[1] : Math.max(n4, nArray[1]);
                    if (bl2 && string4.endsWith("1") && n5 != string4.length()) {
                        FastStringBuffer fastStringBuffer = new FastStringBuffer(n5 + 1);
                        for (n6 = 1; n6 < n5; ++n6) {
                            fastStringBuffer.append('0');
                        }
                        fastStringBuffer.append('1');
                        string4 = fastStringBuffer.toString();
                    }
                }
                if ("P".equals(object)) {
                    if (!("N".equals(string4) || "n".equals(string4) || "Nn".equals(string4))) {
                        string4 = "n";
                    }
                    if (n4 == Integer.MAX_VALUE) {
                        n4 = 4;
                    }
                    break block48;
                }
                if ("Y".equals(object)) {
                    if (n4 < Integer.MAX_VALUE) {
                        n2 %= (int)Math.pow(10.0, n4);
                    }
                    break block48;
                }
                if (!"f".equals(object)) break block48;
                unicodeString = UnicodeString.makeUnicodeString(string);
                if (d.matcher(string4).find()) break;
                string = "1";
            }
            if (!e.matcher(string4).matches()) {
                UnicodeString unicodeString3 = FormatDate.a(unicodeString);
                UnicodeString unicodeString4 = FormatDate.a(UnicodeString.makeUnicodeString("" + n2));
                object = FormatDate.a("s", Integer.parseInt(unicodeString4.toString()), unicodeString3.toString(), false, numberer, xPathContext);
                UnicodeString unicodeString5 = FormatDate.a(UnicodeString.makeUnicodeString((CharSequence)object));
                if (unicodeString5.uLength() > n4) {
                    unicodeString5 = unicodeString5.uSubstring(0, n4);
                }
                return unicodeString5.toString();
            }
            if (!f.matcher(string4).matches()) {
                throw new XPathException("Invalid picture for fractional seconds: " + string4, "FOFD1340");
            }
            if (n2 == 0) {
                stringBuilder = new StringBuilder("0");
            } else {
                stringBuilder = new StringBuilder(("" + (n2 + 1000000)).substring(1));
                if (stringBuilder.length() > n4) {
                    stringBuilder = new StringBuilder(stringBuilder.substring(0, n4));
                }
            }
            while (stringBuilder.length() < n5) {
                stringBuilder.append('0');
            }
            while (stringBuilder.length() > n5) {
                StringBuilder stringBuilder3 = stringBuilder;
                if (stringBuilder3.charAt(stringBuilder3.length() - 1) != '0') break;
                stringBuilder = new StringBuilder(stringBuilder.substring(0, stringBuilder.length() - 1));
            }
            if ((n6 = Alphanumeric.getDigitFamily(unicodeString.uCharAt(0))) >= 0 && n6 != 48) {
                object = new int[10];
                for (int i4 = 0; i4 <= 9; ++i4) {
                    object[i4] = n6 + i4;
                }
                long l2 = Long.parseLong(stringBuilder.toString());
                n2 = stringBuilder.length();
                stringBuilder = new StringBuilder(AbstractNumberer.convertDigitSystem(l2, (int[])object, n2).toString());
            }
            return stringBuilder.toString();
        }
        if ("N".equals(string4) || "n".equals(string4) || "Nn".equals(string4)) {
            String string7 = "";
            if ("M".equals(object)) {
                string7 = numberer.monthName(n2, n5, n4);
            } else if ("F".equals(object)) {
                string7 = numberer.dayName(n2, n5, n4);
            } else if ("P".equals(object)) {
                string7 = numberer.halfDayName(n2, n5, n4);
            } else {
                string4 = "1";
            }
            if ("N".equals(string4)) {
                return string7.toUpperCase();
            }
            if ("n".equals(string4)) {
                return string7.toLowerCase();
            }
            return string7;
        }
        try {
            numericGroupFormatter = FormatInteger.getPicSeparators(string4);
        }
        catch (XPathException xPathException) {
            if ("FODF1310".equals(xPathException.getErrorCodeLocalPart())) {
                xPathException.setErrorCode("FOFD1340");
            }
            throw xPathException;
        }
        UnicodeString unicodeString = numericGroupFormatter.getAdjustedPicture();
        String string8 = numberer.format(n2, unicodeString, numericGroupFormatter, string2, string3);
        if (n3 < n5) {
            int n9 = Alphanumeric.getDigitFamily(unicodeString.uCharAt(0));
            FastStringBuffer fastStringBuffer = new FastStringBuffer(string8);
            for (n3 = StringValue.getStringLength(string8); n3 < n5; ++n3) {
                fastStringBuffer.prependWideChar(n9);
            }
            string8 = fastStringBuffer.toString();
        }
        return string8;
    }

    private static UnicodeString a(UnicodeString unicodeString) {
        int[] nArray = new int[unicodeString.uLength()];
        int n2 = unicodeString.uLength() - 1;
        int n3 = 0;
        while (n2 >= 0) {
            nArray[n3] = unicodeString.uCharAt(n2);
            --n2;
            ++n3;
        }
        return UnicodeString.makeUnicodeString(nArray);
    }

    private static int[] a(String string) {
        try {
            Object object;
            int n2 = -1;
            int n3 = -1;
            if (!"".equals(string)) {
                object = c.matcher(string);
                if (((Matcher)object).matches()) {
                    String string2 = ((Matcher)object).group(1);
                    n2 = string2 == null || "".equals(string2) || "*".equals(string2) ? 1 : Integer.parseInt(string2);
                    String string3 = ((Matcher)object).group(3);
                    n3 = string3 == null || "".equals(string3) || "*".equals(string3) ? Integer.MAX_VALUE : Integer.parseInt(string3);
                    if (n2 <= 0) {
                        throw new XPathException("Invalid min value in format picture " + Err.wrap(string, 4), "FOFD1340");
                    }
                    if (n3 <= 0 || n3 < n2) {
                        throw new XPathException("Invalid max value in format picture " + Err.wrap(string, 4), "FOFD1340");
                    }
                } else {
                    throw new XPathException("Unrecognized width specifier in format picture " + Err.wrap(string, 4), "FOFD1340");
                }
            }
            if (n2 > n3) {
                object = new XPathException("Minimum width in date/time picture exceeds maximum width");
                ((XPathException)object).setErrorCode("FOFD1340");
                throw object;
            }
            int[] nArray = new int[2];
            object = nArray;
            nArray[0] = n2;
            object[1] = n3;
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            XPathException xPathException = new XPathException("Invalid integer used as width in date/time picture");
            xPathException.setErrorCode("FOFD1340");
            throw xPathException;
        }
    }

    private static String a(DateTimeValue dateTimeValue, char c2, String string, String string2) {
        while (true) {
            int n2;
            int n3;
            int n4;
            int n5 = string.lastIndexOf(44);
            String string3 = "";
            if (n5 >= 0) {
                string3 = string.substring(n5);
                string = string.substring(0, n5);
            }
            if (!dateTimeValue.hasTimezone()) {
                if (string.equals("Z")) {
                    return "J";
                }
                return "";
            }
            if (string.isEmpty() && !string3.isEmpty()) {
                int[] nArray = FormatDate.a(string3);
                int n6 = nArray[0];
                n4 = nArray[1];
                string = n6 <= 1 ? (n4 >= 4 ? "0:00" : "0") : (n6 <= 4 ? (n4 >= 5 ? "00:00" : "00") : "00:00");
            }
            if (string.isEmpty()) {
                string = "00:00";
            }
            n5 = dateTimeValue.getTimezoneInMinutes();
            int n7 = string.endsWith("t") ? 1 : 0;
            if (n7 != 0 && n5 == 0) {
                return "Z";
            }
            if (n7 != 0) {
                string = string.substring(0, string.length() - 1);
            }
            n4 = 0;
            n7 = 0;
            int n8 = 58;
            int n9 = -1;
            int[] nArray = StringValue.expand(string);
            int[] nArray2 = nArray;
            nArray2 = nArray;
            int n10 = nArray.length;
            for (n3 = 0; n3 < n10; ++n3) {
                n2 = nArray2[n3];
                if (Character.isDigit(n2)) {
                    ++n4;
                    if (n9 >= 0) continue;
                    n9 = Alphanumeric.getDigitFamily(n2);
                    continue;
                }
                ++n7;
                n8 = n2;
            }
            nArray2 = new int[10];
            n10 = 0;
            if (n4 > 0) {
                int n11;
                if (c2 == 'z') {
                    nArray2[0] = 71;
                    nArray2[1] = 77;
                    nArray2[2] = 84;
                    n10 = 3;
                }
                n3 = n5 < 0 ? 1 : 0;
                n5 = Math.abs(n5);
                nArray2[n10++] = n3 != 0 ? 45 : 43;
                n2 = n5 / 60;
                int n12 = n5 % 60;
                c2 = n12 != 0 || n4 >= 3 || n7 > 0 ? (char)'\u0001' : '\u0000';
                boolean bl2 = n12 != 0 && n4 <= 2 || n7 > 0 && (n12 != 0 || n4 >= 3);
                int n13 = n11 = n4 <= 2 ? n4 : n4 - 2;
                if (n2 > 9 || n11 >= 2) {
                    nArray2[n10++] = n9 + n2 / 10;
                }
                nArray2[n10++] = n2 % 10 + n9;
                if (bl2) {
                    nArray2[n10++] = n8;
                }
                if (c2 != '\u0000') {
                    nArray2[n10++] = n12 / 10 + n9;
                    nArray2[n10++] = n12 % 10 + n9;
                }
                return StringValue.contract(nArray2, n10).toString();
            }
            if (string.equals("Z")) {
                n3 = n5 / 60;
                n2 = n5 % 60;
                if (n3 < -12 || n3 > 12 || n2 != 0) {
                    string = "00:00";
                    c2 = (char)90;
                    continue;
                }
                return Character.toString("YXWVUTSRQPONZABCDEFGHIKLM".charAt(n3 + 12));
            }
            if (string.charAt(0) == 'N' || string.charAt(0) == 'n') {
                return FormatDate.a(dateTimeValue, string2, string);
            }
            string = "00:00";
            c2 = (char)90;
        }
    }

    private static String a(DateTimeValue dateTimeValue, String string, String string2) {
        int n2 = 1;
        int n3 = string2.indexOf(44);
        if (n3 > 0) {
            Object object = string2.substring(n3);
            int[] nArray = FormatDate.a((String)object);
            object = nArray;
            n2 = nArray[0];
        }
        if (string2.charAt(0) == 'N' || string2.charAt(0) == 'n') {
            if (n2 <= 5) {
                String string3 = NamedTimeZone.getTimeZoneNameForDate(dateTimeValue, string);
                if (string2.charAt(0) == 'n') {
                    string3 = string3.toLowerCase();
                }
                return string3;
            }
            return NamedTimeZone.getOlsenTimeZoneName(dateTimeValue, string);
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(8);
        dateTimeValue.appendTimezone(fastStringBuffer);
        return fastStringBuffer.toString();
    }

    public ZeroOrOne<StringValue> call(XPathContext xPathContext, Sequence[] object) {
        Object object2;
        boolean bl2;
        Object object3 = object[0].head();
        if (object3 == null) {
            return ZeroOrOne.empty();
        }
        Object object4 = object[1].head().getStringValue();
        StringValue stringValue = null;
        Object object5 = null;
        Object object6 = null;
        if (this.getArity() > 2) {
            object6 = (StringValue)object[2].head();
            stringValue = (StringValue)object[3].head();
            object5 = (StringValue)object[4].head();
        }
        object = object6 == null ? null : ((AtomicValue)object6).getStringValue();
        if ((object5 = object5 == null ? null : ((AtomicValue)object5).getStringValue()) != null && ((String)object5).contains("/") && ((CalendarValue)object3).hasTimezone() && !(object3 instanceof TimeValue) && (object6 = NamedTimeZone.getNamedTimeZone((String)object5)) != null) {
            int n2 = ((TimeZone)object6).getOffset(((CalendarValue)((CalendarValue)object3).toDateTime()).getCalendar().getTimeInMillis());
            object3 = ((CalendarValue)object3).adjustTimezone(n2 / 60000);
        }
        Object object7 = object3;
        Object object8 = object4;
        Object object9 = xPathContext;
        object4 = object;
        object3 = object8;
        object = object7;
        Object object10 = object9.getConfiguration();
        boolean bl3 = bl2 = object4 == null;
        if (object4 == null) {
            object4 = ((Configuration)object10).getDefaultLanguage();
        }
        if (object5 == null) {
            object5 = ((Configuration)object10).getDefaultCountry();
        }
        if (((CalendarValue)object).hasTimezone() && ((String)object5).contains("/") && (object2 = TimeZone.getTimeZone((String)object5)) != null) {
            int n3 = ((TimeZone)object2).getOffset(((CalendarValue)((CalendarValue)object).toDateTime()).getCalendar().getTime().getTime());
            object = ((CalendarValue)object).adjustTimezone(n3 / 60000);
        }
        object2 = ((Configuration)object10).makeNumberer((String)object4, (String)object5);
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        if (!bl2 && object2.getClass() == Numberer_en.class && !((String)object4).startsWith("en")) {
            fastStringBuffer.append("[Language: en]");
        }
        if (object2.defaultedLocale() != null) {
            fastStringBuffer.append("[Language: " + object2.defaultedLocale().getLanguage() + "]");
        }
        int n4 = 0;
        while (true) {
            CharSequence charSequence;
            if (n4 < ((String)object3).length() && ((String)object3).charAt(n4) != '[') {
                fastStringBuffer.append(((String)object3).charAt(n4));
                if (((String)object3).charAt(n4) == ']' && (++n4 == ((String)object3).length() || ((String)object3).charAt(n4) != ']')) {
                    object10 = new XPathException("Closing ']' in date picture must be written as ']]'");
                    ((XPathException)object10).setErrorCode("FOFD1340");
                    ((XPathException)object10).setXPathContext((XPathContext)object9);
                    throw object10;
                }
                ++n4;
                continue;
            }
            if (n4 == ((String)object3).length()) break;
            if (++n4 < ((String)object3).length() && ((String)object3).charAt(n4) == '[') {
                fastStringBuffer.append('[');
                ++n4;
                continue;
            }
            int n5 = n4 < ((String)object3).length() ? ((String)object3).indexOf("]", n4) : -1;
            if (n5 == -1) {
                XPathException xPathException = new XPathException("Date format contains a '[' with no matching ']'");
                xPathException.setErrorCode("FOFD1340");
                xPathException.setXPathContext((XPathContext)object9);
                throw xPathException;
            }
            Object object11 = ((String)object3).substring(n4, n5);
            Object object12 = object9;
            Object object13 = object5;
            Object object14 = object2;
            Object object15 = Whitespace.removeAllWhitespace((CharSequence)object11);
            object11 = object;
            int n6 = object11 instanceof TimeValue;
            boolean bl4 = object11 instanceof DateValue;
            DateTimeValue dateTimeValue = ((CalendarValue)object11).toDateTime();
            Object object16 = b.matcher((CharSequence)object15);
            if (!((Matcher)object16).matches()) {
                object15 = new XPathException("Unrecognized date/time component [" + object15 + ']');
                ((XPathException)object15).setErrorCode("FOFD1340");
                ((XPathException)object15).setXPathContext((XPathContext)object12);
                throw object15;
            }
            object15 = ((Matcher)object16).group(1);
            if ((object16 = ((Matcher)object16).group(2)) == null) {
                object16 = "";
            }
            boolean bl5 = false;
            if ("".equals(object16) || ((String)object16).startsWith(",")) {
                bl5 = true;
                switch (((String)object15).charAt(0)) {
                    case 'F': {
                        object16 = "Nn" + (String)object16;
                        break;
                    }
                    case 'P': {
                        object16 = "n" + (String)object16;
                        break;
                    }
                    case 'C': 
                    case 'E': {
                        object16 = "N" + (String)object16;
                        break;
                    }
                    case 'm': 
                    case 's': {
                        object16 = "01" + (String)object16;
                        break;
                    }
                    case 'Z': 
                    case 'z': {
                        break;
                    }
                    default: {
                        object16 = "1" + (String)object16;
                    }
                }
            }
            switch (((String)object15).charAt(0)) {
                case 'Y': {
                    if (n6 != 0) {
                        object11 = new XPathException("In format-time(): an xs:time value does not contain a year component");
                        ((XPathException)object11).setErrorCode("FOFD1350");
                        ((XPathException)object11).setXPathContext((XPathContext)object12);
                        throw object11;
                    }
                    int n7 = dateTimeValue.getYear();
                    if (n7 < 0) {
                        n7 = 0 - n7;
                    }
                    charSequence = FormatDate.a((String)object15, n7, (String)object16, bl5, (Numberer)object14, (XPathContext)object12);
                    break;
                }
                case 'M': {
                    if (n6 != 0) {
                        object11 = new XPathException("In format-time(): an xs:time value does not contain a month component");
                        ((XPathException)object11).setErrorCode("FOFD1350");
                        ((XPathException)object11).setXPathContext((XPathContext)object12);
                        throw object11;
                    }
                    byte by = dateTimeValue.getMonth();
                    charSequence = FormatDate.a((String)object15, by, (String)object16, bl5, (Numberer)object14, (XPathContext)object12);
                    break;
                }
                case 'D': {
                    if (n6 != 0) {
                        object11 = new XPathException("In format-time(): an xs:time value does not contain a day component");
                        ((XPathException)object11).setErrorCode("FOFD1350");
                        ((XPathException)object11).setXPathContext((XPathContext)object12);
                        throw object11;
                    }
                    byte by = dateTimeValue.getDay();
                    charSequence = FormatDate.a((String)object15, by, (String)object16, bl5, (Numberer)object14, (XPathContext)object12);
                    break;
                }
                case 'd': {
                    if (n6 != 0) {
                        object11 = new XPathException("In format-time(): an xs:time value does not contain a day component");
                        ((XPathException)object11).setErrorCode("FOFD1350");
                        ((XPathException)object11).setXPathContext((XPathContext)object12);
                        throw object11;
                    }
                    int n8 = DateValue.getDayWithinYear(dateTimeValue.getYear(), dateTimeValue.getMonth(), dateTimeValue.getDay());
                    charSequence = FormatDate.a((String)object15, n8, (String)object16, bl5, (Numberer)object14, (XPathContext)object12);
                    break;
                }
                case 'W': {
                    if (n6 != 0) {
                        object11 = new XPathException("In format-time(): cannot obtain the week number from an xs:time value");
                        ((XPathException)object11).setErrorCode("FOFD1350");
                        ((XPathException)object11).setXPathContext((XPathContext)object12);
                        throw object11;
                    }
                    int n9 = DateValue.getWeekNumber(dateTimeValue.getYear(), dateTimeValue.getMonth(), dateTimeValue.getDay());
                    charSequence = FormatDate.a((String)object15, n9, (String)object16, bl5, (Numberer)object14, (XPathContext)object12);
                    break;
                }
                case 'w': {
                    if (n6 != 0) {
                        object11 = new XPathException("In format-time(): cannot obtain the week number from an xs:time value");
                        ((XPathException)object11).setErrorCode("FOFD1350");
                        ((XPathException)object11).setXPathContext((XPathContext)object12);
                        throw object11;
                    }
                    int n10 = DateValue.getWeekNumberWithinMonth(dateTimeValue.getYear(), dateTimeValue.getMonth(), dateTimeValue.getDay());
                    charSequence = FormatDate.a((String)object15, n10, (String)object16, bl5, (Numberer)object14, (XPathContext)object12);
                    break;
                }
                case 'H': {
                    if (bl4) {
                        object11 = new XPathException("In format-date(): an xs:date value does not contain an hour component");
                        ((XPathException)object11).setErrorCode("FOFD1350");
                        ((XPathException)object11).setXPathContext((XPathContext)object12);
                        throw object11;
                    }
                    object11 = (Int64Value)((AtomicValue)object11).getComponent(AccessorFn.Component.HOURS);
                    assert (object11 != null);
                    charSequence = FormatDate.a((String)object15, (int)((NumericValue)object11).longValue(), (String)object16, bl5, (Numberer)object14, (XPathContext)object12);
                    break;
                }
                case 'h': {
                    if (bl4) {
                        object11 = new XPathException("In format-date(): an xs:date value does not contain an hour component");
                        ((XPathException)object11).setErrorCode("FOFD1350");
                        ((XPathException)object11).setXPathContext((XPathContext)object12);
                        throw object11;
                    }
                    object11 = (Int64Value)((AtomicValue)object11).getComponent(AccessorFn.Component.HOURS);
                    assert (object11 != null);
                    n6 = (int)((NumericValue)object11).longValue();
                    if (n6 > 12) {
                        n6 -= 12;
                    }
                    if (n6 == 0) {
                        n6 = 12;
                    }
                    charSequence = FormatDate.a((String)object15, n6, (String)object16, bl5, (Numberer)object14, (XPathContext)object12);
                    break;
                }
                case 'm': {
                    if (bl4) {
                        object11 = new XPathException("In format-date(): an xs:date value does not contain a minutes component");
                        ((XPathException)object11).setErrorCode("FOFD1350");
                        ((XPathException)object11).setXPathContext((XPathContext)object12);
                        throw object11;
                    }
                    object11 = (Int64Value)((AtomicValue)object11).getComponent(AccessorFn.Component.MINUTES);
                    assert (object11 != null);
                    charSequence = FormatDate.a((String)object15, (int)((NumericValue)object11).longValue(), (String)object16, bl5, (Numberer)object14, (XPathContext)object12);
                    break;
                }
                case 's': {
                    if (bl4) {
                        object11 = new XPathException("In format-date(): an xs:date value does not contain a seconds component");
                        ((XPathException)object11).setErrorCode("FOFD1350");
                        ((XPathException)object11).setXPathContext((XPathContext)object12);
                        throw object11;
                    }
                    object11 = (IntegerValue)((AtomicValue)object11).getComponent(AccessorFn.Component.WHOLE_SECONDS);
                    assert (object11 != null);
                    charSequence = FormatDate.a((String)object15, (int)((NumericValue)object11).longValue(), (String)object16, bl5, (Numberer)object14, (XPathContext)object12);
                    break;
                }
                case 'f': {
                    if (bl4) {
                        object11 = new XPathException("In format-date(): an xs:date value does not contain a fractional seconds component");
                        ((XPathException)object11).setErrorCode("FOFD1350");
                        ((XPathException)object11).setXPathContext((XPathContext)object12);
                        throw object11;
                    }
                    object11 = (Int64Value)((AtomicValue)object11).getComponent(AccessorFn.Component.MICROSECONDS);
                    assert (object11 != null);
                    charSequence = FormatDate.a((String)object15, (int)((NumericValue)object11).longValue(), (String)object16, bl5, (Numberer)object14, (XPathContext)object12);
                    break;
                }
                case 'Z': 
                case 'z': {
                    if (object11 instanceof TimeValue) {
                        int n11;
                        DateTimeValue dateTimeValue2 = DateTimeValue.getCurrentDateTime((XPathContext)object12);
                        int n12 = dateTimeValue2.getYear();
                        Boolean bl6 = NamedTimeZone.inSummerTime(dateTimeValue2 = new DateTimeValue(n12, 1, 1, 0, 0, 0, 0, n11 = ((CalendarValue)object11).getTimezoneInMinutes(), false), (String)object13);
                        if (bl6 != null && bl6.booleanValue()) {
                            dateTimeValue2 = new DateTimeValue(n12, 7, 1, 0, 0, 0, 0, n11, false);
                        }
                        object11 = DateTimeValue.makeDateTimeValue(dateTimeValue2.toDateValue(), (TimeValue)object11);
                    } else {
                        object11 = ((CalendarValue)object11).toDateTime();
                    }
                    charSequence = FormatDate.a((DateTimeValue)object11, ((String)object15).charAt(0), (String)object16, (String)object13);
                    break;
                }
                case 'F': {
                    if (n6 != 0) {
                        XPathException xPathException = new XPathException("In format-time(): an xs:time value does not contain day-of-week component");
                        xPathException.setErrorCode("FOFD1350");
                        xPathException.setXPathContext((XPathContext)object12);
                        throw xPathException;
                    }
                    n6 = DateValue.getDayOfWeek(dateTimeValue.getYear(), dateTimeValue.getMonth(), dateTimeValue.getDay());
                    charSequence = FormatDate.a((String)object15, n6, (String)object16, bl5, (Numberer)object14, (XPathContext)object12);
                    break;
                }
                case 'P': {
                    if (bl4) {
                        XPathException xPathException = new XPathException("In format-date(): an xs:date value does not contain an am/pm component");
                        xPathException.setErrorCode("FOFD1350");
                        xPathException.setXPathContext((XPathContext)object12);
                        throw xPathException;
                    }
                    n6 = dateTimeValue.getHour() * 60 + dateTimeValue.getMinute();
                    charSequence = FormatDate.a((String)object15, n6, (String)object16, bl5, (Numberer)object14, (XPathContext)object12);
                    break;
                }
                case 'C': {
                    charSequence = object14.getCalendarName("AD");
                    break;
                }
                case 'E': {
                    if (n6 != 0) {
                        XPathException xPathException = new XPathException("In format-time(): an xs:time value does not contain an AD/BC component");
                        xPathException.setErrorCode("FOFD1350");
                        xPathException.setXPathContext((XPathContext)object12);
                        throw xPathException;
                    }
                    n6 = dateTimeValue.getYear();
                    charSequence = object14.getEraName(n6);
                    break;
                }
                default: {
                    XPathException xPathException = new XPathException("Unknown format-date/time component specifier '" + ((String)object16).charAt(0) + '\'');
                    xPathException.setErrorCode("FOFD1340");
                    xPathException.setXPathContext((XPathContext)object12);
                    throw xPathException;
                }
            }
            fastStringBuffer.append(charSequence);
            n4 = n5 + 1;
        }
        object9 = fastStringBuffer;
        if (stringValue != null) {
            object9 = this.a(stringValue, (CharSequence)object9, xPathContext);
        }
        return new ZeroOrOne<StringValue>(new StringValue((CharSequence)object9));
    }

    static {
        Pattern.compile("([^,]*)(,.*)?");
        c = Pattern.compile(",(\\*|[0-9]+)(\\-(\\*|[0-9]+))?");
        Pattern.compile("([A-Za-z0-9]|\\p{L}|\\p{N})*");
        d = Pattern.compile("\\p{Nd}+");
        e = Pattern.compile("[#\\p{Nd}]+");
        f = Pattern.compile("\\p{Nd}+#*");
    }
}

