/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import java.util.function.Function;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.number.Alphanumeric;
import net.sf.saxon.expr.number.IrregularGroupFormatter;
import net.sf.saxon.expr.number.NumberFormatter;
import net.sf.saxon.expr.number.NumericGroupFormatter;
import net.sf.saxon.expr.number.RegularGroupFormatter;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.StatefulSystemFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.regex.ARegularExpression;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.regex.charclass.Categories;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntHashSet;

public class FormatInteger
extends SystemFunction
implements StatefulSystemFunction {
    private static final ARegularExpression a;
    private static final ARegularExpression b;
    private static final ARegularExpression c;
    public static final String preface = "In the picture string for format-integer, ";
    private Function<IntegerValue, String> d = null;

    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo, Expression ... expressionArray) {
        boolean bl2 = true;
        if (!(expressionArray[1] instanceof Literal)) {
            bl2 = false;
        }
        if (expressionArray.length == 3 && !(expressionArray[2] instanceof Literal)) {
            bl2 = false;
        }
        if (!bl2) {
            return super.makeOptimizedFunctionCall(expressionVisitor, contextItemStaticInfo, expressionArray);
        }
        Object object = expressionVisitor.getConfiguration();
        String string = expressionArray.length == 3 ? ((Literal)expressionArray[2]).getValue().getStringValue() : ((Configuration)object).getDefaultLanguage();
        object = ((Configuration)object).makeNumberer(string, null);
        this.d = FormatInteger.a((Numberer)object, ((Literal)expressionArray[1]).getValue().getStringValue());
        return super.makeOptimizedFunctionCall(expressionVisitor, contextItemStaticInfo, expressionArray);
    }

    public StringValue call(XPathContext xPathContext, Sequence[] sequenceArray) {
        return this.a((IntegerValue)sequenceArray[0].head(), (StringValue)sequenceArray[1].head(), sequenceArray.length == 2 ? null : (StringValue)sequenceArray[2].head(), xPathContext);
    }

    private StringValue a(IntegerValue integerValue, StringValue stringValue, StringValue object, XPathContext object2) {
        object2 = object2.getConfiguration();
        if (integerValue == null) {
            return StringValue.EMPTY_STRING;
        }
        Function<IntegerValue, String> function = this.d;
        if (function == null) {
            object = object != null ? ((AtomicValue)object).getStringValue() : ((Configuration)object2).getDefaultLanguage();
            object = ((Configuration)object2).makeNumberer((String)object, null);
            function = FormatInteger.a((Numberer)object, stringValue.getStringValue());
        }
        try {
            return new StringValue(function.apply(integerValue));
        }
        catch (UncheckedXPathException uncheckedXPathException) {
            object = uncheckedXPathException;
            throw uncheckedXPathException.getXPathException();
        }
    }

    private static Function<IntegerValue, String> a(Numberer numberer, String string) {
        String string2;
        CharSequence charSequence;
        if (string.isEmpty()) {
            throw new XPathException("In the picture string for format-integer, the picture cannot be empty", "FODF1310");
        }
        int n2 = string.lastIndexOf(59);
        if (n2 >= 0) {
            charSequence = string.substring(0, n2);
            if (charSequence.isEmpty()) {
                throw new XPathException("In the picture string for format-integer, the primary format token cannot be empty", "FODF1310");
            }
            String string3 = string = n2 < string.length() - 1 ? string.substring(n2 + 1) : "";
            if (!b.matches(string)) {
                throw new XPathException("In the picture string for format-integer, the modifier is invalid", "FODF1310");
            }
        } else {
            charSequence = string;
            string = "";
        }
        n2 = string.startsWith("o") ? 1 : 0;
        boolean bl2 = string.endsWith("a");
        int n3 = string.indexOf(40);
        int n4 = string.lastIndexOf(41);
        string = n3 < 0 ? "" : string.substring(n3 + 1, n4);
        String string4 = string2 = bl2 ? "alphabetic" : "traditional";
        string = n2 != 0 ? ("".equals(string) ? "yes" : string) : "";
        UnicodeString unicodeString = UnicodeString.makeUnicodeString(charSequence);
        Categories.Category category = Categories.getCategory("Nd");
        n4 = 0;
        for (int i2 = 0; i2 < unicodeString.uLength(); ++i2) {
            if (!category.test(unicodeString.uCharAt(i2))) continue;
            n4 = 1;
            break;
        }
        if (n4 != 0) {
            if (!c.matches(charSequence)) {
                throw new XPathException("In the picture string for format-integer, the primary format token contains a decimal digit but does not meet the rules for a decimal digit pattern", "FODF1310");
            }
            NumericGroupFormatter numericGroupFormatter = FormatInteger.getPicSeparators(charSequence);
            charSequence = numericGroupFormatter.getAdjustedPicture();
            return arg_0 -> FormatInteger.a(numberer, (UnicodeString)charSequence, numericGroupFormatter, string2, string, arg_0);
        }
        UnicodeString unicodeString2 = UnicodeString.makeUnicodeString(charSequence);
        return integerValue -> {
            try {
                numberer = numberer.format(integerValue.abs().longValue(), unicodeString2, null, string2, string);
                if (integerValue.signum() < 0) {
                    return "-" + (String)((Object)numberer);
                }
                return numberer;
            }
            catch (XPathException xPathException) {
                throw new UncheckedXPathException(xPathException);
            }
        };
    }

    public static NumericGroupFormatter getPicSeparators(String string) {
        CharSequence charSequence = UnicodeString.makeUnicodeString(string);
        IntHashSet intHashSet = new IntHashSet(5);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = true;
        int n5 = -1;
        if (a.matches(string)) {
            throw new XPathException("In the picture string for format-integer, the picture is not valid (it uses '#' where disallowed)", "FODF1310");
        }
        block7: for (int i2 = ((UnicodeString)charSequence).uLength() - 1; i2 >= 0; --i2) {
            int n6 = ((UnicodeString)charSequence).uCharAt(i2);
            switch (Character.getType(n6)) {
                case 9: {
                    if (n5 == -1) {
                        n5 = Alphanumeric.getDigitFamily(n6);
                    } else if (n5 != Alphanumeric.getDigitFamily(n6)) {
                        throw new XPathException("In the picture string for format-integer, the picture mixes digits from different digit families", "FODF1310");
                    }
                    ++n2;
                    continue block7;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 10: 
                case 11: {
                    continue block7;
                }
                default: {
                    if (i2 == ((UnicodeString)charSequence).uLength() - 1) {
                        throw new XPathException("In the picture string for format-integer, the picture cannot end with a separator", "FODF1310");
                    }
                    if (n6 == 35) {
                        ++n2;
                        if (i2 == 0) continue block7;
                        switch (Character.getType(((UnicodeString)charSequence).uCharAt(i2 - 1))) {
                            case 1: 
                            case 2: 
                            case 4: 
                            case 5: 
                            case 9: 
                            case 10: 
                            case 11: {
                                throw new XPathException("In the picture string for format-integer, the picture cannot contain alphanumeric character(s) before character '#'", "FODF1310");
                            }
                        }
                        continue block7;
                    }
                    boolean bl3 = intHashSet.add(n2);
                    n4 = bl3 ? 1 : 0;
                    if (!bl3) {
                        throw new XPathException("In the picture string for format-integer, the picture contains consecutive separators", "FODF1310");
                    }
                    arrayList.add(n6);
                    if (intHashSet.size() == 1) {
                        n3 = n2;
                    } else {
                        if (n2 != n3 * intHashSet.size()) {
                            bl2 = false;
                        }
                        if ((Integer)arrayList.get(0) != n6) {
                            bl2 = false;
                        }
                    }
                    if (i2 == 0) {
                        throw new XPathException("In the picture string for format-integer, the picture cannot begin with a separator", "FODF1310");
                    }
                    n4 = n2;
                }
            }
        }
        if (bl2 && intHashSet.size() > 0 && ((UnicodeString)charSequence).uLength() - n4 - intHashSet.size() > n3) {
            bl2 = false;
        }
        UnicodeString unicodeString = charSequence;
        charSequence = new FastStringBuffer(unicodeString.uLength());
        for (n2 = 0; n2 < unicodeString.uLength(); ++n2) {
            if (!NumberFormatter.isLetterOrDigit(unicodeString.uCharAt(n2))) continue;
            ((FastStringBuffer)charSequence).appendWideChar(unicodeString.uCharAt(n2));
        }
        unicodeString = UnicodeString.makeUnicodeString(charSequence);
        if (intHashSet.isEmpty()) {
            return new RegularGroupFormatter(0, "", unicodeString);
        }
        if (bl2) {
            if (arrayList.isEmpty()) {
                return new RegularGroupFormatter(0, "", unicodeString);
            }
            FastStringBuffer fastStringBuffer = new FastStringBuffer(4);
            fastStringBuffer.appendWideChar((Integer)arrayList.get(0));
            return new RegularGroupFormatter(n3, fastStringBuffer.toString(), unicodeString);
        }
        return new IrregularGroupFormatter(intHashSet, arrayList, unicodeString);
    }

    @Override
    public SystemFunction copy() {
        FormatInteger formatInteger = (FormatInteger)SystemFunction.makeFunction(this.getFunctionName().getLocalPart(), this.getRetainedStaticContext(), this.getArity());
        ((FormatInteger)SystemFunction.makeFunction(this.getFunctionName().getLocalPart(), this.getRetainedStaticContext(), this.getArity())).d = this.d;
        return formatInteger;
    }

    private static /* synthetic */ String a(Numberer object, UnicodeString unicodeString, NumericGroupFormatter numericGroupFormatter, String string, String string2, IntegerValue integerValue) {
        try {
            object = object.format(integerValue.abs().longValue(), unicodeString, numericGroupFormatter, string, string2);
            if (integerValue.signum() < 0) {
                return "-" + (String)object;
            }
            return object;
        }
        catch (XPathException xPathException) {
            throw new UncheckedXPathException(xPathException);
        }
    }

    static {
        try {
            a = new ARegularExpression("((\\d+|\\w+)#+.*)|(#+[^\\d]+)", "", "XP20", null, null);
            b = new ARegularExpression("([co](\\(.*\\))?)?[at]?", "", "XP20", null, null);
            c = new ARegularExpression("^((\\p{Nd}|#|[^\\p{N}\\p{L}])+?)$", "", "XP20", null, null);
            return;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

