/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.StatefulSystemFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class FormatNumber
extends SystemFunction
implements Callable,
StatefulSystemFunction {
    private StructuredQName a;
    private String b;
    private DecimalSymbols c;
    private a[] d;

    @Override
    public Expression fixArguments(Expression ... object) {
        if (object[1] instanceof Literal && (((Expression[])object).length == 2 || object[2] instanceof Literal)) {
            DecimalFormatManager decimalFormatManager = this.getRetainedStaticContext().getDecimalFormatManager();
            assert (decimalFormatManager != null);
            this.b = ((Literal)object[1]).getValue().getStringValue();
            if (((Expression[])object).length == 3 && !Literal.isEmptySequence(object[2])) {
                try {
                    object = ((Literal)object[2]).getValue().getStringValue();
                    this.a = StructuredQName.fromLexicalQName((CharSequence)object, false, true, this.getRetainedStaticContext());
                }
                catch (XPathException xPathException) {
                    XPathException xPathException2 = new XPathException("Invalid decimal format name. " + xPathException.getMessage());
                    xPathException2.setErrorCode("FODF1280");
                    throw xPathException2;
                }
            }
            if (this.a == null) {
                this.c = decimalFormatManager.getDefaultDecimalFormat();
            } else {
                this.c = decimalFormatManager.getNamedDecimalFormat(this.a);
                if (this.c == null) {
                    throw new XPathException("Decimal format " + this.a.getDisplayName() + " has not been defined", "FODF1280");
                }
            }
            this.d = FormatNumber.a(this.b, this.c);
        }
        return null;
    }

    private static a[] a(String object, DecimalSymbols decimalSymbols) {
        object = StringValue.expand((CharSequence)object);
        a[] aArray = new a[2];
        if (((Object)object).length == 0) {
            XPathException xPathException = new XPathException("format-number() picture is zero-length");
            xPathException.setErrorCode("FODF1310");
            throw xPathException;
        }
        int n2 = -1;
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            if (object[i2] != decimalSymbols.getPatternSeparator()) continue;
            if (i2 == 0) {
                FormatNumber.b("first subpicture is zero-length");
            } else if (n2 >= 0) {
                FormatNumber.b("more than one pattern separator");
            } else if (n2 == ((Object)object).length - 1) {
                FormatNumber.b("second subpicture is zero-length");
            }
            n2 = i2;
        }
        if (n2 < 0) {
            aArray[0] = new a((int[])object, decimalSymbols);
            aArray[1] = null;
        } else {
            int[] nArray = new int[n2];
            System.arraycopy(object, 0, nArray, 0, n2);
            int[] nArray2 = new int[((Object)object).length - n2 - 1];
            System.arraycopy(object, n2 + 1, nArray2, 0, ((Object)object).length - n2 - 1);
            aArray[0] = new a(nArray, decimalSymbols);
            aArray[1] = new a(nArray2, decimalSymbols);
        }
        return aArray;
    }

    private static CharSequence a(NumericValue object, a[] aArray, DecimalSymbols decimalSymbols) {
        NumericValue numericValue = object;
        String string = "";
        int n2 = ((NumericValue)object).signum();
        if (n2 == 0 && ((NumericValue)object).isNegativeZero()) {
            n2 = -1;
        }
        if (n2 < 0) {
            numericValue = ((NumericValue)object).negate();
            if (aArray[1] == null) {
                object = aArray[0];
                string = "" + FormatNumber.b(decimalSymbols.getMinusSign());
            } else {
                object = aArray[1];
            }
        } else {
            object = aArray[0];
        }
        return ((a)object).a(numericValue, decimalSymbols, string);
    }

    private static void b(String string) {
        throw new XPathException("format-number picture: " + string, "FODF1310");
    }

    public static BigDecimal adjustToDecimal(double d2, int n2) {
        String string = n2 == 1 ? "00000" : "000000000";
        CharSequence charSequence = n2 == 1 ? "99999" : "999999999";
        BigDecimal bigDecimal = BigDecimal.valueOf(d2);
        BigDecimal bigDecimal2 = null;
        CharSequence charSequence2 = new FastStringBuffer(16);
        BigDecimalValue.decimalToString(bigDecimal, (FastStringBuffer)charSequence2);
        charSequence2 = ((FastStringBuffer)charSequence2).toString();
        int n3 = ((String)charSequence2).charAt(0) == '-' ? 1 : 0;
        int n4 = ((String)charSequence2).indexOf(".");
        int n5 = ((String)charSequence2).lastIndexOf(string);
        if (n5 > 0) {
            if (n4 < 0 || n5 < n4) {
                charSequence = new FastStringBuffer(((String)charSequence2).length());
                ((FastStringBuffer)charSequence).append(((String)charSequence2).substring(0, n5));
                while (n5 < ((String)charSequence2).length()) {
                    ((FastStringBuffer)charSequence).append(((String)charSequence2).charAt(n5) == '.' ? (char)'.' : '0');
                    ++n5;
                }
                bigDecimal2 = new BigDecimal(((FastStringBuffer)charSequence).toString());
            } else {
                bigDecimal2 = new BigDecimal(((String)charSequence2).substring(0, n5));
            }
        } else {
            n5 = ((String)charSequence2).indexOf((String)charSequence);
            if (n5 >= 0) {
                if (n5 == n3) {
                    charSequence = new FastStringBuffer(((String)charSequence2).length() + 1);
                    if (n3 == 1) {
                        ((FastStringBuffer)charSequence).append('-');
                    }
                    ((FastStringBuffer)charSequence).append('1');
                    for (n5 = n3; n5 < ((String)charSequence2).length(); ++n5) {
                        ((FastStringBuffer)charSequence).append(((String)charSequence2).charAt(n5) == '.' ? (char)'.' : '0');
                    }
                    bigDecimal2 = new BigDecimal(((FastStringBuffer)charSequence).toString());
                } else {
                    while (n5 >= 0 && (((String)charSequence2).charAt(n5) == '9' || ((String)charSequence2).charAt(n5) == '.')) {
                        --n5;
                    }
                    if (n5 < 0 || ((String)charSequence2).charAt(n5) == '-') {
                        return bigDecimal;
                    }
                    if (n4 < 0 || n5 < n4) {
                        charSequence = new FastStringBuffer(((String)charSequence2).length());
                        ((FastStringBuffer)charSequence).append(((String)charSequence2).substring(0, n5));
                        ((FastStringBuffer)charSequence).append((char)(((String)charSequence2).charAt(n5) + '\u0001'));
                        while (n5 < ((String)charSequence2).length()) {
                            ((FastStringBuffer)charSequence).append(((String)charSequence2).charAt(n5) == '.' ? (char)'.' : '0');
                            ++n5;
                        }
                        bigDecimal2 = new BigDecimal(((FastStringBuffer)charSequence).toString());
                    } else {
                        charSequence = ((String)charSequence2).substring(0, n5) + (char)(((String)charSequence2).charAt(n5) + '\u0001');
                        bigDecimal2 = new BigDecimal((String)charSequence);
                    }
                }
            }
        }
        if (bigDecimal2 != null && (n2 == 1 ? (double)bigDecimal2.floatValue() == d2 : bigDecimal2.doubleValue() == d2)) {
            return bigDecimal2;
        }
        return bigDecimal;
    }

    private static CharSequence b(int n2) {
        if (n2 < 65536) {
            return "" + (char)n2;
        }
        char[] cArray = new char[2];
        char[] cArray2 = cArray;
        cArray[0] = (char)((n2 -= 65536) / 1024 + 55296);
        cArray2[1] = (char)(n2 % 1024 + 56320);
        return new CharSlice(cArray2, 0, 2);
    }

    public StringValue call(XPathContext xPathContext, Sequence[] sequenceArray) {
        Object object;
        DecimalSymbols decimalSymbols;
        int n2 = sequenceArray.length;
        DecimalFormatManager decimalFormatManager = this.getRetainedStaticContext().getDecimalFormatManager();
        AtomicValue atomicValue = (AtomicValue)sequenceArray[0].head();
        if (atomicValue == null) {
            atomicValue = DoubleValue.NaN;
        }
        atomicValue = (NumericValue)atomicValue;
        if (this.b != null) {
            CharSequence charSequence = FormatNumber.a((NumericValue)atomicValue, this.d, this.c);
            return new StringValue(charSequence);
        }
        if (n2 == 2) {
            decimalSymbols = decimalFormatManager.getDefaultDecimalFormat();
        } else {
            object = sequenceArray[2].head();
            if (object == null) {
                decimalSymbols = decimalFormatManager.getDefaultDecimalFormat();
            } else {
                object = object.getStringValue();
                decimalSymbols = this.getNamedDecimalFormat(decimalFormatManager, (String)object);
            }
        }
        object = sequenceArray[1].head().getStringValue();
        object = FormatNumber.a((String)object, decimalSymbols);
        return new StringValue(FormatNumber.a((NumericValue)atomicValue, object, decimalSymbols));
    }

    protected DecimalSymbols getNamedDecimalFormat(DecimalFormatManager object, String string) {
        StructuredQName structuredQName;
        try {
            structuredQName = StructuredQName.fromLexicalQName(string, false, true, this.getRetainedStaticContext());
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = new XPathException("Invalid decimal format name. " + xPathException.getMessage());
            xPathException2.setErrorCode("FODF1280");
            throw xPathException2;
        }
        object = ((DecimalFormatManager)object).getNamedDecimalFormat(structuredQName);
        if (object == null) {
            object = new XPathException("format-number function: decimal-format '" + string + "' is not defined");
            ((XPathException)object).setErrorCode("FODF1280");
            throw object;
        }
        return object;
    }

    public static String formatExponential(DoubleValue doubleValue) {
        try {
            DecimalSymbols decimalSymbols = new DecimalSymbols(50, 31);
            decimalSymbols.setInfinity("INF");
            a[] aArray = FormatNumber.a("0.0##########################e0", decimalSymbols);
            return FormatNumber.a(doubleValue, aArray, decimalSymbols).toString();
        }
        catch (XPathException xPathException) {
            return doubleValue.getStringValue();
        }
    }

    @Override
    public FormatNumber copy() {
        FormatNumber formatNumber = (FormatNumber)SystemFunction.makeFunction(this.getFunctionName().getLocalPart(), this.getRetainedStaticContext(), this.getArity());
        ((FormatNumber)SystemFunction.makeFunction(this.getFunctionName().getLocalPart(), this.getRetainedStaticContext(), this.getArity())).a = this.a;
        formatNumber.b = this.b;
        formatNumber.c = this.c;
        formatNumber.d = this.d;
        return formatNumber;
    }

    static /* synthetic */ boolean a(int n2, int n3) {
        return n2 >= n3 && n2 < n3 + 10;
    }

    static /* synthetic */ int[] a(int[] nArray, int n2, int n3, int n4) {
        if (n2 + 1 > nArray.length) {
            nArray = Arrays.copyOf(nArray, n2 + 10);
        }
        System.arraycopy(nArray, n4, nArray, n4 + 1, n2 - n4);
        nArray[n4] = n3;
        return nArray;
    }

    private static final class a {
        private int a = 0;
        private int b = 0;
        private int c = 0;
        private int d = 0;
        private int e = 0;
        private int f = 0;
        private boolean g = false;
        private boolean h = false;
        private String i = "";
        private String j = "";
        private int[] k = null;
        private int[] l = null;
        private boolean m;
        private boolean n = true;

        /*
         * Enabled aggressive block sorting
         */
        public a(int[] nArray, DecimalSymbols decimalSymbols) {
            int n2;
            int n3;
            int n4 = decimalSymbols.getPercent();
            int n5 = decimalSymbols.getPerMille();
            int n6 = decimalSymbols.getDecimalSeparator();
            int n7 = decimalSymbols.getGroupingSeparator();
            int n8 = decimalSymbols.getDigit();
            int n9 = decimalSymbols.getZeroDigit();
            int n10 = decimalSymbols.getExponentSeparator();
            ArrayList<Integer> arrayList = null;
            ArrayList<Integer> arrayList2 = null;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            int[] nArray2 = nArray;
            int n11 = nArray.length;
            for (n3 = 0; n3 < n11; ++n3) {
                n2 = nArray2[n3];
                if (n2 != n8 && n2 != n9 && !FormatNumber.a(n2, n9)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                FormatNumber.b("subpicture contains no digit or zero-digit sign");
            }
            int n12 = 0;
            int[] nArray3 = nArray;
            n3 = nArray.length;
            block42: for (n2 = 0; n2 < n3; ++n2) {
                int n13 = nArray3[n2];
                if (n13 == n4 || n13 == n5) {
                    if (this.g || this.h) {
                        FormatNumber.b("Cannot have more than one percent or per-mille character in a sub-picture");
                    }
                    this.g = n13 == n4;
                    this.h = n13 == n5;
                    switch (n12) {
                        case 0: {
                            this.i = this.i + FormatNumber.b(n13);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            if (bl4) {
                                FormatNumber.b("Cannot have exponent-separator as well as percent or per-mille character in a sub-picture");
                            }
                        }
                        case 6: {
                            n12 = 6;
                            this.j = this.j + FormatNumber.b(n13);
                        }
                    }
                    continue;
                }
                if (n13 == n8) {
                    switch (n12) {
                        case 0: 
                        case 1: {
                            n12 = 1;
                            ++this.b;
                            break;
                        }
                        case 2: {
                            FormatNumber.b("Digit sign must not appear after a zero-digit sign in the integer part of a sub-picture");
                            break;
                        }
                        case 3: 
                        case 4: {
                            n12 = 4;
                            ++this.d;
                            break;
                        }
                        case 5: {
                            FormatNumber.b("Digit sign must not appear in the exponent part of a sub-picture");
                            break;
                        }
                        case 6: {
                            if (bl5) {
                                FormatNumber.b("There must only be one exponent separator in a sub-picture");
                                break;
                            }
                            FormatNumber.b("Passive character must not appear between active characters in a sub-picture");
                        }
                    }
                    continue;
                }
                if (n13 == n9 || FormatNumber.a(n13, n9)) {
                    switch (n12) {
                        case 0: 
                        case 1: 
                        case 2: {
                            n12 = 2;
                            ++this.a;
                            ++this.b;
                            break;
                        }
                        case 3: {
                            ++this.c;
                            ++this.d;
                            break;
                        }
                        case 4: {
                            FormatNumber.b("Zero digit sign must not appear after a digit sign in the fractional part of a sub-picture");
                            break;
                        }
                        case 5: {
                            ++this.e;
                            break;
                        }
                        case 6: {
                            if (bl5) {
                                FormatNumber.b("There must only be one exponent separator in a sub-picture");
                                break;
                            }
                            FormatNumber.b("Passive character must not appear between active characters in a sub-picture");
                        }
                    }
                    continue;
                }
                if (n13 == n6) {
                    if (bl3) {
                        FormatNumber.b("There must only be one decimal separator in a sub-picture");
                    }
                    switch (n12) {
                        case 0: 
                        case 1: 
                        case 2: {
                            n12 = 3;
                            bl3 = true;
                            continue block42;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            if (!bl4) break;
                            FormatNumber.b("Decimal separator must not appear in the exponent part of a sub-picture");
                            continue block42;
                        }
                        case 6: {
                            FormatNumber.b("Decimal separator cannot come after a character in the suffix");
                        }
                    }
                    continue;
                }
                if (n13 == n7) {
                    switch (n12) {
                        case 0: 
                        case 1: 
                        case 2: {
                            if (arrayList == null) {
                                arrayList = new ArrayList<Integer>(3);
                            }
                            if (arrayList.contains(this.b)) {
                                FormatNumber.b("Sub-picture cannot contain adjacent grouping separators");
                            }
                            arrayList.add(this.b);
                            continue block42;
                        }
                        case 3: 
                        case 4: {
                            if (this.d == 0) {
                                FormatNumber.b("Grouping separator cannot be adjacent to decimal separator");
                            }
                            if (arrayList2 == null) {
                                arrayList2 = new ArrayList<Integer>(3);
                            }
                            if (arrayList2.contains(this.d)) {
                                FormatNumber.b("Sub-picture cannot contain adjacent grouping separators");
                            }
                            arrayList2.add(this.d);
                            continue block42;
                        }
                        case 5: {
                            if (!bl4) break;
                            FormatNumber.b("Grouping separator must not appear in the exponent part of a sub-picture");
                            continue block42;
                        }
                        case 6: {
                            FormatNumber.b("Grouping separator found in suffix of sub-picture");
                        }
                    }
                    continue;
                }
                if (n13 == n10) {
                    switch (n12) {
                        case 0: {
                            this.i = this.i + FormatNumber.b(n13);
                            continue block42;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            n12 = 5;
                            bl4 = true;
                            continue block42;
                        }
                        case 5: {
                            if (!bl4) break;
                            bl5 = true;
                            n12 = 6;
                            this.j = this.j + FormatNumber.b(n10);
                            continue block42;
                        }
                        case 6: {
                            this.j = this.j + FormatNumber.b(n13);
                        }
                    }
                    continue;
                }
                switch (n12) {
                    case 0: {
                        this.i = this.i + FormatNumber.b(n13);
                        continue block42;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        if (this.e == 0 && bl4) {
                            n12 = 6;
                            this.j = this.j + FormatNumber.b(n10);
                            this.j = this.j + FormatNumber.b(n13);
                            continue block42;
                        }
                    }
                    case 6: {
                        n12 = 6;
                        this.j = this.j + FormatNumber.b(n13);
                        continue block42;
                    }
                }
            }
            this.f = this.a;
            if (this.b == 0 && this.d == 0) {
                FormatNumber.b("Mantissa contains no digit or zero-digit sign");
            }
            if (this.a == 0 && this.d == 0) {
                if (this.e != 0) {
                    this.c = 1;
                    this.d = 1;
                } else {
                    this.a = 1;
                }
            }
            if (this.e != 0 && this.a == 0 && this.b != 0) {
                this.a = 1;
            }
            if (this.a == 0 && this.c == 0) {
                this.c = 1;
            }
            if (arrayList != null) {
                int n14 = arrayList.size();
                this.k = new int[n14];
                for (n3 = 0; n3 < n14; ++n3) {
                    this.k[n3] = this.b - (Integer)arrayList.get(n14 - n3 - 1);
                }
                if (n14 == 1) {
                    this.m = this.k[0] << 1 >= this.b;
                } else if (n14 > 1) {
                    this.m = true;
                    n3 = this.k[0];
                    for (n2 = 1; n2 < n14; ++n2) {
                        if (this.k[n2] == (n2 + 1) * n3) continue;
                        this.m = false;
                        break;
                    }
                    if (this.m && this.b - this.k[n14 - 1] > n3) {
                        this.m = false;
                    }
                    if (this.m) {
                        this.k = new int[1];
                        this.k[0] = n3;
                    }
                }
                if (this.k[0] == 0) {
                    FormatNumber.b("Cannot have a grouping separator at the end of the integer part");
                }
            }
            if (arrayList2 != null) {
                int n15 = arrayList2.size();
                this.l = new int[n15];
                for (n3 = 0; n3 < n15; ++n3) {
                    this.l[n3] = (Integer)arrayList2.get(n3);
                }
            }
        }

        public final CharSequence a(NumericValue object, DecimalSymbols decimalSymbols, String string) {
            Object object2;
            int n2;
            int n3;
            if (((AtomicValue)object).isNaN()) {
                return decimalSymbols.getNaN();
            }
            int n4 = 1;
            if (this.g) {
                n4 = 100;
            } else if (this.h) {
                n4 = 1000;
            }
            if (n4 != 1) {
                try {
                    object = (NumericValue)ArithmeticExpression.compute((AtomicValue)object, 2, new Int64Value(n4), null);
                }
                catch (XPathException xPathException) {
                    object = new DoubleValue(Double.POSITIVE_INFINITY);
                }
            }
            if ((object instanceof DoubleValue || object instanceof FloatValue) && Double.isInfinite(((NumericValue)object).getDoubleValue())) {
                return string + this.i + decimalSymbols.getInfinity() + this.j;
            }
            FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
            if (object instanceof DoubleValue || object instanceof FloatValue) {
                object = FormatNumber.adjustToDecimal(((NumericValue)object).getDoubleValue(), 2);
                this.a((BigDecimal)object, fastStringBuffer);
            } else if (object instanceof IntegerValue) {
                if (this.e != 0) {
                    this.a(((NumericValue)((IntegerValue)object)).getDecimalValue(), fastStringBuffer);
                } else {
                    FastStringBuffer fastStringBuffer2 = fastStringBuffer;
                    Comparable<NumericValue> comparable = object;
                    object = this;
                    if (((a)object).a != 0 || ((NumericValue)comparable).compareTo(0L) != 0) {
                        fastStringBuffer2.append(((AtomicValue)((Object)comparable)).getStringValueCS());
                        int n5 = ((a)object).a - fastStringBuffer2.length();
                        fastStringBuffer2.prependRepeated('0', n5);
                    }
                    if (((a)object).c != 0) {
                        fastStringBuffer2.append('.');
                        for (int i2 = 0; i2 < ((a)object).c; ++i2) {
                            fastStringBuffer2.append('0');
                        }
                    }
                }
            } else if (object instanceof BigDecimalValue) {
                this.a(((NumericValue)((BigDecimalValue)object)).getDecimalValue(), fastStringBuffer);
            }
            int[] nArray = StringValue.expand(fastStringBuffer);
            object = nArray;
            int n6 = nArray.length;
            int n7 = fastStringBuffer.indexOf('.');
            if (n7 == -1) {
                n7 = fastStringBuffer.length();
            } else {
                object[n7] = decimalSymbols.getDecimalSeparator();
                if (this.d == 0) {
                    --n6;
                }
            }
            if (decimalSymbols.getZeroDigit() != 48) {
                n3 = decimalSymbols.getZeroDigit();
                for (n2 = 0; n2 < n6; ++n2) {
                    object2 = object[n2];
                    if (object2 < 48 || object2 > 57) continue;
                    object[n2] = object2 - 48 + n3;
                }
            }
            if (decimalSymbols.getExponentSeparator() != 101 && (n3 = fastStringBuffer.indexOf('e')) != -1) {
                object[n3] = decimalSymbols.getExponentSeparator();
            }
            if (this.k != null) {
                if (this.m) {
                    n3 = this.k[0];
                    for (n2 = n7 - n3; n2 > 0; n2 -= n3) {
                        object = FormatNumber.a((int[])object, n6++, decimalSymbols.getGroupingSeparator(), n2);
                    }
                } else {
                    int[] nArray2 = this.k;
                    n2 = this.k.length;
                    for (object2 = (Object)false; object2 < n2; ++object2) {
                        int n8 = nArray2[object2];
                        if ((n8 = n7 - n8) <= 0) continue;
                        object = FormatNumber.a((int[])object, n6++, decimalSymbols.getGroupingSeparator(), n8);
                    }
                }
            }
            if (this.l != null) {
                for (int i3 = 0; i3 < this.l.length && (n2 = n7 + 1 + this.l[i3] + i3) < n6; ++i3) {
                    object = FormatNumber.a((int[])object, n6++, decimalSymbols.getGroupingSeparator(), n2);
                }
            }
            FastStringBuffer fastStringBuffer3 = new FastStringBuffer(this.i.length() + string.length() + this.j.length() + n6);
            fastStringBuffer3.append(string);
            fastStringBuffer3.append(this.i);
            for (n2 = 0; n2 < n6; ++n2) {
                fastStringBuffer3.appendWideChar((int)object[n2]);
            }
            fastStringBuffer3.append(this.j);
            return fastStringBuffer3;
        }

        private void a(BigDecimal bigDecimal, FastStringBuffer fastStringBuffer) {
            int n2;
            int n3 = 0;
            if (this.e == 0) {
                bigDecimal = bigDecimal.setScale(this.d, RoundingMode.HALF_EVEN);
            } else {
                n3 = bigDecimal.precision() - bigDecimal.scale() - this.f;
                bigDecimal = bigDecimal.movePointLeft(n3);
                bigDecimal = bigDecimal.setScale(this.d, RoundingMode.HALF_EVEN);
            }
            BigDecimalValue.decimalToString(bigDecimal, fastStringBuffer);
            int n4 = fastStringBuffer.indexOf('.');
            if (n4 >= 0) {
                for (n2 = this.d - this.c; n2 > 0; --n2) {
                    FastStringBuffer fastStringBuffer2 = fastStringBuffer;
                    if (fastStringBuffer2.charAt(fastStringBuffer2.length() - 1) != '0') break;
                    FastStringBuffer fastStringBuffer3 = fastStringBuffer;
                    fastStringBuffer3.setLength(fastStringBuffer3.length() - 1);
                }
                FastStringBuffer fastStringBuffer4 = fastStringBuffer;
                if (fastStringBuffer4.charAt(fastStringBuffer4.length() - 1) == '.') {
                    FastStringBuffer fastStringBuffer5 = fastStringBuffer;
                    fastStringBuffer5.setLength(fastStringBuffer5.length() - 1);
                }
            } else {
                n4 = fastStringBuffer.length();
                if (this.c > 0) {
                    fastStringBuffer.append('.');
                    for (n2 = 0; n2 < this.c; ++n2) {
                        fastStringBuffer.append('0');
                    }
                }
            }
            if (this.a == 0 && n4 == 1 && fastStringBuffer.charAt(0) == '0') {
                fastStringBuffer.removeCharAt(0);
            } else {
                fastStringBuffer.prependRepeated('0', this.a - n4);
            }
            if (this.e != 0) {
                fastStringBuffer.append('e');
                IntegerValue integerValue = (IntegerValue)IntegerValue.makeIntegerValue(n3);
                String string = ((AtomicValue)integerValue).toString();
                char c2 = string.charAt(0);
                n3 = c2;
                if (c2 == '-') {
                    fastStringBuffer.append('-');
                    string = string.substring(1);
                }
                if ((n3 = string.length()) < this.e) {
                    n3 = this.e - n3;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        fastStringBuffer.append('0');
                    }
                }
                fastStringBuffer.append(string);
            }
        }
    }
}

