/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.trans.SymbolicName;

public class FunctionLibraryList
implements FunctionLibrary,
XQueryFunctionBinder {
    public List<FunctionLibrary> libraryList = new ArrayList<FunctionLibrary>(8);

    public int addFunctionLibrary(FunctionLibrary functionLibrary) {
        this.libraryList.add(functionLibrary);
        return this.libraryList.size() - 1;
    }

    public FunctionLibrary get(int n2) {
        return this.libraryList.get(n2);
    }

    @Override
    public boolean isAvailable(SymbolicName.F f2) {
        for (FunctionLibrary functionLibrary : this.libraryList) {
            if (!functionLibrary.isAvailable(f2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Expression bind(SymbolicName.F f2, Expression[] expressionArray, StaticContext staticContext, List<String> list) {
        boolean bl2 = staticContext.getConfiguration().getBooleanProperty(Feature.TRACE_EXTERNAL_FUNCTIONS);
        Logger logger = staticContext.getConfiguration().getLogger();
        if (bl2) {
            logger.info("Looking for function " + f2.getComponentName().getEQName() + "#" + f2.getArity());
        }
        for (FunctionLibrary functionLibrary : this.libraryList) {
            Expression object;
            if (bl2) {
                logger.info("Trying " + functionLibrary.getClass().getName());
            }
            if ((object = functionLibrary.bind(f2, expressionArray, staticContext, list)) == null) continue;
            return object;
        }
        if (bl2) {
            logger.info("Function " + f2.getComponentName().getEQName() + " not found!");
        }
        return null;
    }

    @Override
    public XQueryFunction getDeclaration(StructuredQName structuredQName, int n2) {
        for (FunctionLibrary functionLibrary : this.libraryList) {
            XQueryFunction xQueryFunction;
            if (!(functionLibrary instanceof XQueryFunctionBinder) || (xQueryFunction = ((XQueryFunctionBinder)functionLibrary).getDeclaration(structuredQName, n2)) == null) continue;
            return xQueryFunction;
        }
        return null;
    }

    public List<FunctionLibrary> getLibraryList() {
        return this.libraryList;
    }

    @Override
    public FunctionLibrary copy() {
        FunctionLibraryList functionLibraryList = new FunctionLibraryList();
        new FunctionLibraryList().libraryList = new ArrayList<FunctionLibrary>(this.libraryList.size());
        for (int i2 = 0; i2 < this.libraryList.size(); ++i2) {
            functionLibraryList.libraryList.add(this.libraryList.get(i2).copy());
        }
        return functionLibraryList;
    }
}

