/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CardinalityCheckingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class IntegratedFunctionCall
extends FunctionCall
implements Callable {
    private StructuredQName a;
    private ExtensionFunctionCall b;
    private SequenceType c = SequenceType.ANY_SEQUENCE;
    private int d = 0;

    public IntegratedFunctionCall(StructuredQName structuredQName, ExtensionFunctionCall extensionFunctionCall) {
        this.a = structuredQName;
        this.b = extensionFunctionCall;
    }

    public void setResultType(SequenceType sequenceType) {
        this.c = sequenceType;
    }

    @Override
    public StructuredQName getFunctionName() {
        return this.a;
    }

    @Override
    public Function getTargetFunction(XPathContext xPathContext) {
        return null;
    }

    public ExtensionFunctionCall getFunction() {
        return this.b;
    }

    @Override
    public void checkArguments(ExpressionVisitor expressionVisitor) {
        ExtensionFunctionDefinition extensionFunctionDefinition = this.b.getDefinition();
        this.checkArgumentCount(extensionFunctionDefinition.getMinimumNumberOfArguments(), extensionFunctionDefinition.getMaximumNumberOfArguments());
        int n2 = this.getArity();
        SequenceType[] sequenceTypeArray = extensionFunctionDefinition.getArgumentTypes();
        if (sequenceTypeArray == null || n2 != 0 && sequenceTypeArray.length == 0) {
            throw new XPathException("Integrated function " + this.getDisplayName() + " failed to declare its argument types");
        }
        SequenceType[] sequenceTypeArray2 = new SequenceType[n2];
        TypeChecker typeChecker = expressionVisitor.getConfiguration().getTypeChecker(false);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setArg(i2, typeChecker.staticTypeCheck(this.getArg(i2), i2 < sequenceTypeArray.length ? sequenceTypeArray[i2] : sequenceTypeArray[sequenceTypeArray.length - 1], new RoleDiagnostic(0, ((FunctionCall)this).getFunctionName().getDisplayName(), i2), expressionVisitor));
            sequenceTypeArray2[i2] = SequenceType.makeSequenceType(this.getArg(i2).getItemType(), this.getArg(i2).getCardinality());
        }
        this.c = extensionFunctionDefinition.getResultType(sequenceTypeArray2);
        if (this.d == 0) {
            this.b.supplyStaticContext(expressionVisitor.getStaticContext(), 0, this.getArguments());
        }
        ++this.d;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        Expression expression = super.typeCheck(expressionVisitor, contextItemStaticInfo);
        if (expression instanceof IntegratedFunctionCall) {
            Expression expression2 = ((IntegratedFunctionCall)expression).b.rewrite(expressionVisitor.getStaticContext(), this.getArguments());
            if (expression2 == null) {
                return expression;
            }
            ExpressionTool.copyLocationInfo(this, expression2);
            return expression2.simplify().typeCheck(expressionVisitor, contextItemStaticInfo).optimize(expressionVisitor, contextItemStaticInfo);
        }
        return expression;
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor expressionVisitor) {
        return this;
    }

    @Override
    public ItemType getItemType() {
        return this.c.getPrimaryType();
    }

    @Override
    protected int computeCardinality() {
        return this.c.getCardinality();
    }

    @Override
    public int getIntrinsicDependencies() {
        ExtensionFunctionDefinition extensionFunctionDefinition = this.b.getDefinition();
        if (extensionFunctionDefinition.dependsOnFocus()) {
            return 30;
        }
        return 0;
    }

    @Override
    protected int computeSpecialProperties() {
        ExtensionFunctionDefinition extensionFunctionDefinition = this.b.getDefinition();
        if (extensionFunctionDefinition.hasSideEffects()) {
            return 0x2000000;
        }
        return 0x800000;
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        Callable callable = this.b.getDefinition().makeCallExpression();
        ((ExtensionFunctionCall)callable).setDefinition(this.b.getDefinition());
        this.b.copyLocalData((ExtensionFunctionCall)callable);
        callable = new IntegratedFunctionCall(((FunctionCall)this).getFunctionName(), (ExtensionFunctionCall)callable);
        Expression[] expressionArray = new Expression[this.getArity()];
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            expressionArray[i2] = this.getArg(i2).copy(rebindingMap);
        }
        ((FunctionCall)((Object)callable)).setArguments(expressionArray);
        ((IntegratedFunctionCall)callable).c = this.c;
        ((IntegratedFunctionCall)callable).d = this.d;
        ExpressionTool.copyLocationInfo(this, (Expression)((Object)callable));
        return callable;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("ifCall", this);
        expressionPresenter.emitAttribute("name", ((FunctionCall)this).getFunctionName());
        expressionPresenter.emitAttribute("type", this.c.toExportString());
        for (Operand operand : ((Expression)this).operands()) {
            operand.getChildExpression().export(expressionPresenter);
        }
        expressionPresenter.endElement();
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        Object object = this.b.getDefinition();
        Object object2 = new Sequence[this.getArity()];
        for (int i2 = 0; i2 < ((Sequence[])object2).length; ++i2) {
            object2[i2] = SequenceTool.toLazySequence(this.getArg(i2).iterate(xPathContext));
        }
        RoleDiagnostic roleDiagnostic = new RoleDiagnostic(5, ((FunctionCall)this).getFunctionName().getDisplayName(), 0);
        Object object3 = xPathContext.getConfiguration();
        object3 = ((Configuration)object3).getTypeHierarchy();
        try {
            object2 = this.b.call(xPathContext, (Sequence[])object2).iterate();
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            throw object;
        }
        if (!((ExtensionFunctionDefinition)object).trustResultType()) {
            ItemType itemType;
            int n2 = this.c.getCardinality();
            if (n2 != 57344) {
                object2 = new CardinalityCheckingIterator(object2, n2, roleDiagnostic, this.getLocation());
            }
            if ((itemType = this.c.getPrimaryType()) != AnyItemType.getInstance()) {
                object2 = new ItemMappingIterator<Item, Item>((SequenceIterator<Item>)object2, arg_0 -> this.a(itemType, (TypeHierarchy)object3, roleDiagnostic, arg_0), true);
            }
            if (((TypeHierarchy)object3).relationship(itemType, AnyNodeTest.getInstance()) != 4) {
                object2 = new ItemMappingIterator(object2, new ConfigurationCheckingFunction(xPathContext.getConfiguration()), true);
            }
        }
        return object2;
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        Sequence[] sequenceArray = new Sequence[this.getArity()];
        for (int i2 = 0; i2 < sequenceArray.length; ++i2) {
            sequenceArray[i2] = SequenceTool.toLazySequence(this.getArg(i2).iterate(xPathContext));
        }
        try {
            return this.b.effectiveBooleanValue(xPathContext, sequenceArray);
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            throw xPathException2;
        }
    }

    public Sequence<?> call(XPathContext xPathContext, Sequence[] sequenceArray) {
        return this.b.call(xPathContext, sequenceArray);
    }

    private /* synthetic */ Item a(ItemType object, TypeHierarchy typeHierarchy, RoleDiagnostic roleDiagnostic, Item item) {
        if (!object.matches(item, typeHierarchy)) {
            object = roleDiagnostic.composeErrorMessage((ItemType)object, item, typeHierarchy);
            object = new XPathException((String)object, "XPTY0004");
            ((XPathException)object).setLocation(this.getLocation());
            throw object;
        }
        return item;
    }

    public static class ConfigurationCheckingFunction
    implements ItemMappingFunction<Item<?>, Item<?>> {
        private Configuration a;

        public ConfigurationCheckingFunction(Configuration configuration) {
            this.a = configuration;
        }

        @Override
        public Item mapItem(Item item) {
            if (item instanceof NodeInfo && !this.a.isCompatible(((NodeInfo)item).getConfiguration())) {
                throw new XPathException("Node returned by extension function was created with an incompatible Configuration", "SXXP0004");
            }
            return item;
        }
    }
}

