/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Arrays;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.EncodeForUri;
import net.sf.saxon.functions.ScalarSystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class IriToUri
extends ScalarSystemFunction {
    public static boolean[] allowedASCII = new boolean[128];

    @Override
    public AtomicValue evaluate(Item object, XPathContext xPathContext) {
        object = object.getStringValueCS();
        return StringValue.makeStringValue(IriToUri.iriToUri((CharSequence)object));
    }

    @Override
    public ZeroOrOne<? extends AtomicValue> resultWhenEmpty() {
        return ZERO_LENGTH_STRING;
    }

    public static CharSequence iriToUri(CharSequence charSequence) {
        boolean bl2;
        char c2;
        int n2;
        CharSequence charSequence2;
        block4: {
            charSequence2 = charSequence;
            for (n2 = 0; n2 < charSequence2.length(); ++n2) {
                c2 = charSequence2.charAt(n2);
                if (c2 < '\u007f' && allowedASCII[c2]) continue;
                bl2 = false;
                break block4;
            }
            bl2 = true;
        }
        if (bl2) {
            return charSequence;
        }
        charSequence2 = new FastStringBuffer(charSequence.length() + 20);
        for (n2 = 0; n2 < charSequence.length(); ++n2) {
            c2 = charSequence.charAt(n2);
            if (c2 >= '\u007f' || !allowedASCII[c2]) {
                EncodeForUri.escapeChar(c2, n2 + 1 < charSequence.length() ? charSequence.charAt(n2 + 1) : (char)' ', (FastStringBuffer)charSequence2);
                continue;
            }
            ((FastStringBuffer)charSequence2).append(c2);
        }
        return charSequence2;
    }

    static {
        Arrays.fill(allowedASCII, 0, 32, false);
        Arrays.fill(allowedASCII, 33, 127, true);
        IriToUri.allowedASCII[34] = false;
        IriToUri.allowedASCII[60] = false;
        IriToUri.allowedASCII[62] = false;
        IriToUri.allowedASCII[92] = false;
        IriToUri.allowedASCII[94] = false;
        IriToUri.allowedASCII[96] = false;
        IriToUri.allowedASCII[123] = false;
        IriToUri.allowedASCII[124] = false;
        IriToUri.allowedASCII[125] = false;
    }
}

