/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.UnionEnumeration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.sort.LocalOrderComparer;
import net.sf.saxon.functions.StatefulSystemFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeSetPattern;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.value.AtomicValue;

public class KeyFn
extends SystemFunction
implements StatefulSystemFunction {
    private KeyDefinitionSet a = null;

    public KeyManager getKeyManager() {
        return this.getRetainedStaticContext().getPackageData().getKeyManager();
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.getRetainedStaticContext();
    }

    public static Expression internalKeyCall(KeyManager object, KeyDefinitionSet keyDefinitionSet, String string, Expression expression, Expression expression2, RetainedStaticContext retainedStaticContext) {
        object = (KeyFn)SystemFunction.makeFunction("key", retainedStaticContext, 3);
        assert (object != null);
        ((KeyFn)object).a = keyDefinitionSet;
        try {
            ((SystemFunction)object).fixArguments(new StringLiteral(string), expression, expression2);
        }
        catch (XPathException xPathException) {}
        return ((SystemFunction)object).makeFunctionCall(new StringLiteral(string), expression, expression2);
    }

    @Override
    public int getSpecialProperties(Expression[] expressionArray) {
        int n2 = 25296896;
        if (this.getArity() == 2 || (expressionArray[2].getSpecialProperties() & 0x10000) != 0) {
            n2 = 25362432;
        }
        return n2;
    }

    @Override
    public SystemFunction copy() {
        KeyFn keyFn = (KeyFn)SystemFunction.makeFunction(this.getFunctionName().getLocalPart(), this.getRetainedStaticContext(), this.getArity());
        ((KeyFn)SystemFunction.makeFunction(this.getFunctionName().getLocalPart(), this.getRetainedStaticContext(), this.getArity())).a = this.a;
        return keyFn;
    }

    @Override
    public Expression fixArguments(Expression ... object) {
        if (object[0] instanceof StringLiteral && this.a == null) {
            KeyManager keyManager = this.getKeyManager();
            object = ((StringLiteral)object[0]).getStringValue();
            this.a = this.a(keyManager, (String)object);
        }
        return null;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        if (this.a != null) {
            PathMap.PathMapNodeSet pathMapNodeSet2 = new PathMap.PathMapNodeSet();
            for (KeyDefinition keyDefinition : this.a.getKeyDefinitions()) {
                Object object = keyDefinition.getMatch();
                if (object instanceof NodeSetPattern) {
                    object = ((NodeSetPattern)object).getSelectionExpression();
                    object = ((Expression)object).addToPathMap(pathMap, pathMapNodeSet);
                    Expression object2 = keyDefinition.getUse();
                    object2.addToPathMap(pathMap, (PathMap.PathMapNodeSet)object);
                    pathMapNodeSet2.addNodeSet((PathMap.PathMapNodeSet)object);
                    continue;
                }
                throw new IllegalStateException("Can't add key() call to pathmap");
            }
            return pathMapNodeSet2;
        }
        throw new IllegalStateException("Can't add dynamic key() call to pathmap");
    }

    @Override
    public Sequence<?> call(XPathContext xPathContext, Sequence[] sequenceArray) {
        Item<?> item;
        Object object;
        if (sequenceArray.length == 3) {
            object = (NodeInfo)KeyFn.a(xPathContext, sequenceArray[2]);
        } else {
            object = xPathContext;
            item = object.getContextItem();
            if (item == null) {
                throw new XPathException("Cannot call the key() function when there is no context item", "XTDE1270", (XPathContext)object);
            }
            if (!(item instanceof NodeInfo)) {
                throw new XPathException("Cannot call the key() function when the context item is not a node", "XTDE1270", (XPathContext)object);
            }
            object = ((NodeInfo)item).getRoot();
        }
        if (object.getRoot().getNodeKind() != 9) {
            throw new XPathException("In the key() function, the node supplied in the third argument (or the context node if absent) must be in a tree whose root is a document node", "XTDE1270", xPathContext);
        }
        item = this.a;
        KeyManager keyManager = this.getKeyManager();
        if (item == null) {
            item = this.a(keyManager, sequenceArray[0].head().getStringValue());
        }
        return KeyFn.search(keyManager, xPathContext, sequenceArray[1], (NodeInfo)object, (KeyDefinitionSet)((Object)item));
    }

    private static Item a(XPathContext xPathContext, Sequence<?> sequence) {
        Object obj;
        try {
            obj = sequence.head();
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            String string = xPathException.getErrorCodeLocalPart();
            if ("XPDY0002".equals(string) && sequence instanceof RootExpression) {
                throw new XPathException("Cannot call the key() function when there is no context node", "XTDE1270", xPathContext);
            }
            if ("XPDY0050".equals(string)) {
                throw new XPathException("In the key() function, the node supplied in the third argument (or the context node if absent) must be in a tree whose root is a document node", "XTDE1270", xPathContext);
            }
            if ("XPTY0020".equals(string) || "XPTY0019".equals(string)) {
                throw new XPathException("Cannot call the key() function when the context item is an atomic value", "XTDE1270", xPathContext);
            }
            throw xPathException2;
        }
        return obj;
    }

    private KeyDefinitionSet a(KeyManager object, String string) {
        StructuredQName structuredQName;
        try {
            structuredQName = StructuredQName.fromLexicalQName(string, false, true, this.getNamespaceResolver());
        }
        catch (XPathException xPathException) {
            throw new XPathException("Invalid key name: " + xPathException.getMessage(), "XTDE1260");
        }
        object = ((KeyManager)object).getKeyDefinitionSet(structuredQName);
        if (object == null) {
            throw new XPathException("Key '" + string + "' has not been defined", "XTDE1260");
        }
        return object;
    }

    protected static Sequence<NodeInfo> search(KeyManager keyManager, XPathContext xPathContext, Sequence<? extends AtomicValue> object, NodeInfo nodeInfo, KeyDefinitionSet keyDefinitionSet) {
        Object object2;
        NodeInfo nodeInfo2 = nodeInfo.getRoot();
        if (keyDefinitionSet.isComposite()) {
            SequenceIterator<? extends AtomicValue> sequenceIterator = object.iterate();
            object = keyManager.selectByCompositeKey(keyDefinitionSet, nodeInfo2.getTreeInfo(), sequenceIterator, xPathContext);
            if (nodeInfo.equals(nodeInfo2)) {
                return new LazySequence<NodeInfo>((SequenceIterator<NodeInfo>)object);
            }
            return new LazySequence<NodeInfo>(new ItemMappingIterator<NodeInfo, NodeInfo>((SequenceIterator<NodeInfo>)object, new SubtreeFilter(nodeInfo)));
        }
        Object object3 = null;
        object = object.iterate();
        while ((object2 = (AtomicValue)object.next()) != null) {
            object2 = keyManager.selectByKey(keyDefinitionSet, nodeInfo2.getTreeInfo(), (AtomicValue)object2, xPathContext);
            if (object3 == null) {
                object3 = object2;
                continue;
            }
            object3 = new UnionEnumeration((SequenceIterator<? extends NodeInfo>)object3, (SequenceIterator<? extends NodeInfo>)object2, LocalOrderComparer.getInstance());
        }
        if (object3 == null) {
            object3 = EmptyIterator.OfNodes.THE_INSTANCE;
        }
        if (nodeInfo.equals(nodeInfo2)) {
            return new LazySequence<NodeInfo>((SequenceIterator<NodeInfo>)object3);
        }
        return new LazySequence<NodeInfo>(new ItemMappingIterator<NodeInfo, NodeInfo>((SequenceIterator<NodeInfo>)object3, new SubtreeFilter(nodeInfo)));
    }

    public static class SubtreeFilter
    implements ItemMappingFunction<NodeInfo, NodeInfo> {
        private NodeInfo a;

        public SubtreeFilter(NodeInfo nodeInfo) {
            this.a = nodeInfo;
        }

        @Override
        public NodeInfo mapItem(NodeInfo nodeInfo) {
            if (Navigator.isAncestorOrSelf(this.a, nodeInfo)) {
                return nodeInfo;
            }
            return null;
        }
    }
}

