/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.om.One;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;

public class MathFunctionSet
extends BuiltInFunctionSet {
    private static MathFunctionSet a = new MathFunctionSet();

    public static MathFunctionSet getInstance() {
        return a;
    }

    private MathFunctionSet() {
        MathFunctionSet mathFunctionSet = this;
        mathFunctionSet.register("pi", 0, PiFn.class, BuiltInAtomicType.DOUBLE, 16384, 0, 0);
        mathFunctionSet.a("sin", SinFn.class);
        mathFunctionSet.a("cos", CosFn.class);
        mathFunctionSet.a("tan", TanFn.class);
        mathFunctionSet.a("asin", AsinFn.class);
        mathFunctionSet.a("acos", AcosFn.class);
        mathFunctionSet.a("atan", AtanFn.class);
        mathFunctionSet.a("sqrt", SqrtFn.class);
        mathFunctionSet.a("log", LogFn.class);
        mathFunctionSet.a("log10", Log10Fn.class);
        mathFunctionSet.a("exp", ExpFn.class);
        mathFunctionSet.a("exp10", Exp10Fn.class);
        mathFunctionSet.register("pow", 2, PowFn.class, BuiltInAtomicType.DOUBLE, 24576, 0, 32768).arg(0, BuiltInAtomicType.DOUBLE, 24576, EMPTY).arg(1, BuiltInAtomicType.DOUBLE, 16384, null);
        mathFunctionSet.register("atan2", 2, Atan2Fn.class, BuiltInAtomicType.DOUBLE, 16384, 0, 0).arg(0, BuiltInAtomicType.DOUBLE, 16384, null).arg(1, BuiltInAtomicType.DOUBLE, 16384, null);
    }

    private void a(String string, Class<? extends SystemFunction> clazz) {
        this.register(string, 1, clazz, BuiltInAtomicType.DOUBLE, 24576, 0, 32768).arg(0, BuiltInAtomicType.DOUBLE, 24576, EMPTY);
    }

    @Override
    public String getNamespace() {
        return "http://www.w3.org/2005/xpath-functions/math";
    }

    @Override
    public String getConventionalPrefix() {
        return "math";
    }

    public static class Atan2Fn
    extends SystemFunction {
        public DoubleValue call(XPathContext object, Sequence[] object2) {
            object = (DoubleValue)object2[0].head();
            assert (object != null);
            object2 = (DoubleValue)object2[1].head();
            assert (object2 != null);
            double d2 = Math.atan2(((NumericValue)object).getDoubleValue(), ((NumericValue)object2).getDoubleValue());
            return new DoubleValue(d2);
        }
    }

    public static class PowFn
    extends SystemFunction {
        public ZeroOrOne<DoubleValue> call(XPathContext object, Sequence[] sequenceArray) {
            object = (DoubleValue)sequenceArray[0].head();
            if (object == null) {
                object = null;
            } else {
                double d2 = ((NumericValue)object).getDoubleValue();
                if (d2 != 1.0) {
                    object = (NumericValue)sequenceArray[1].head();
                    assert (object != null);
                    double d3 = ((NumericValue)object).getDoubleValue();
                    object = d2 == -1.0 && Double.isInfinite(d3) ? new DoubleValue(1.0) : new DoubleValue(Math.pow(d2, d3));
                }
            }
            return new ZeroOrOne<Object>(object);
        }
    }

    public static class Exp10Fn
    extends a {
        public Exp10Fn() {
            super((byte)0);
        }

        @Override
        protected double compute(double d2) {
            return Math.pow(10.0, d2);
        }
    }

    public static class ExpFn
    extends a {
        public ExpFn() {
            super((byte)0);
        }

        @Override
        protected double compute(double d2) {
            return Math.exp(d2);
        }
    }

    public static class Log10Fn
    extends a {
        public Log10Fn() {
            super((byte)0);
        }

        @Override
        protected double compute(double d2) {
            return Math.log10(d2);
        }
    }

    public static class LogFn
    extends a {
        public LogFn() {
            super((byte)0);
        }

        @Override
        protected double compute(double d2) {
            return Math.log(d2);
        }
    }

    public static class SqrtFn
    extends a {
        public SqrtFn() {
            super((byte)0);
        }

        @Override
        protected double compute(double d2) {
            return Math.sqrt(d2);
        }
    }

    public static class AtanFn
    extends a {
        public AtanFn() {
            super((byte)0);
        }

        @Override
        protected double compute(double d2) {
            return Math.atan(d2);
        }
    }

    public static class AcosFn
    extends a {
        public AcosFn() {
            super((byte)0);
        }

        @Override
        protected double compute(double d2) {
            return Math.acos(d2);
        }
    }

    public static class AsinFn
    extends a {
        public AsinFn() {
            super((byte)0);
        }

        @Override
        protected double compute(double d2) {
            return Math.asin(d2);
        }
    }

    public static class TanFn
    extends a {
        public TanFn() {
            super((byte)0);
        }

        @Override
        protected double compute(double d2) {
            return Math.tan(d2);
        }
    }

    public static class CosFn
    extends a {
        public CosFn() {
            super((byte)0);
        }

        @Override
        protected double compute(double d2) {
            return Math.cos(d2);
        }
    }

    public static class SinFn
    extends a {
        public SinFn() {
            super((byte)0);
        }

        @Override
        protected double compute(double d2) {
            return Math.sin(d2);
        }
    }

    private static abstract class a
    extends SystemFunction {
        private a() {
        }

        protected abstract double compute(double var1);

        public ZeroOrOne<DoubleValue> call(XPathContext object, Sequence[] sequenceArray) {
            object = (DoubleValue)sequenceArray[0].head();
            if (object == null) {
                return ZeroOrOne.empty();
            }
            return One.dbl(this.compute(((NumericValue)object).getDoubleValue()));
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }

    public static class PiFn
    extends SystemFunction {
        @Override
        public Expression makeFunctionCall(Expression ... expressionArray) {
            return Literal.makeLiteral(new DoubleValue(Math.PI));
        }

        public DoubleValue call(XPathContext xPathContext, Sequence[] sequenceArray) {
            return new DoubleValue(Math.PI);
        }
    }
}

