/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Properties;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.UntypedSequenceConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.DescendingComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public abstract class Minimax
extends CollatingFunctionFixed {
    private PlainType a = BuiltInAtomicType.ANY_ATOMIC;
    private boolean b = false;

    public abstract boolean isMaxFunction();

    public void setIgnoreNaN(boolean bl2) {
        this.b = bl2;
    }

    public boolean isIgnoreNaN() {
        return this.b;
    }

    public AtomicComparer getComparer() {
        return this.getPreAllocatedAtomicComparer();
    }

    public PlainType getArgumentType() {
        return this.a;
    }

    @Override
    public void supplyTypeInformation(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object, Expression[] expressionArray) {
        object = expressionArray[0].getItemType();
        this.a = object.getAtomizedItemType();
        if (this.a instanceof AtomicType) {
            if (this.a == BuiltInAtomicType.UNTYPED_ATOMIC) {
                this.a = BuiltInAtomicType.DOUBLE;
            }
            Minimax minimax = this;
            minimax.preAllocateComparer((AtomicType)minimax.a, (AtomicType)this.a, expressionVisitor.getStaticContext());
        }
    }

    @Override
    public ItemType getResultItemType(Expression[] object) {
        TypeHierarchy typeHierarchy = this.getRetainedStaticContext().getConfiguration().getTypeHierarchy();
        if ((object = Atomizer.getAtomizedItemType(object[0], false, typeHierarchy)).equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            object = BuiltInAtomicType.DOUBLE;
        }
        return object.getPrimitiveItemType();
    }

    @Override
    public int getCardinality(Expression[] expressionArray) {
        if (!Cardinality.allowsZero(expressionArray[0].getCardinality())) {
            return 16384;
        }
        return 24576;
    }

    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo, Expression ... expressionArray) {
        ItemType itemType;
        int n2 = expressionArray[0].getCardinality();
        if (!Cardinality.allowsMany(n2) && (itemType = expressionArray[0].getItemType().getPrimitiveItemType()) instanceof BuiltInAtomicType && ((BuiltInAtomicType)itemType).isOrdered(false)) {
            TypeHierarchy typeHierarchy = expressionVisitor.getConfiguration().getTypeHierarchy();
            if (typeHierarchy.relationship(itemType, BuiltInAtomicType.UNTYPED_ATOMIC) != 4) {
                return ((Expression)UntypedSequenceConverter.makeUntypedSequenceConverter(expressionVisitor.getConfiguration(), expressionArray[0], BuiltInAtomicType.DOUBLE)).typeCheck(expressionVisitor, contextItemStaticInfo);
            }
            return expressionArray[0];
        }
        return null;
    }

    @Override
    public AtomicComparer getAtomicComparer(XPathContext xPathContext) {
        Object object = this.getPreAllocatedAtomicComparer();
        if (object != null) {
            return object;
        }
        object = this.a.getPrimitiveItemType();
        if (object.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            object = BuiltInAtomicType.DOUBLE;
        }
        object = (BuiltInAtomicType)object;
        return GenericAtomicComparer.makeAtomicComparer((BuiltInAtomicType)object, (BuiltInAtomicType)object, this.getStringCollator(), xPathContext);
    }

    public static AtomicValue minimax(SequenceIterator object, boolean bl2, AtomicComparer atomicComparer, boolean bl3, XPathContext xPathContext) {
        AtomicValue atomicValue;
        AtomicValue atomicValue2;
        AtomicValue atomicValue3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        StringToDouble stringToDouble;
        ConversionRules conversionRules;
        block40: {
            block39: {
                conversionRules = xPathContext.getConfiguration().getConversionRules();
                stringToDouble = xPathContext.getConfiguration().getConversionRules().getStringToDoubleConverter();
                bl7 = false;
                bl6 = false;
                bl5 = false;
                bl4 = false;
                if (bl2) {
                    atomicComparer = new DescendingComparer(atomicComparer);
                }
                atomicComparer = atomicComparer.provideContext(xPathContext);
                do {
                    if ((atomicValue3 = (AtomicValue)object.next()) == null) {
                        return null;
                    }
                    atomicValue2 = atomicValue3;
                    if (atomicValue3 instanceof UntypedAtomicValue) {
                        try {
                            atomicValue2 = atomicValue3 = new DoubleValue(stringToDouble.stringToNumber(atomicValue3.getStringValueCS()));
                            bl7 = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            XPathException xPathException = new XPathException("Failure converting " + Err.wrap(atomicValue3.getStringValueCS()) + " to a number");
                            xPathException.setErrorCode("FORG0001");
                            xPathException.setXPathContext(xPathContext);
                            throw xPathException;
                        }
                    } else if (atomicValue2 instanceof DoubleValue) {
                        bl7 = true;
                    } else if (atomicValue2 instanceof FloatValue) {
                        bl6 = true;
                    } else if (atomicValue2 instanceof StringValue && !(atomicValue2 instanceof AnyURIValue)) {
                        bl4 = true;
                    }
                    if (!atomicValue2.isNaN()) break block39;
                } while (bl3);
                if (atomicValue2 instanceof DoubleValue) {
                    return atomicValue3;
                }
                bl5 = true;
                atomicValue3 = FloatValue.NaN;
                break block40;
            }
            if (!atomicValue2.getPrimitiveType().isOrdered(false)) {
                XPathException xPathException = new XPathException("Type " + atomicValue2.getPrimitiveType() + " is not an ordered type");
                xPathException.setErrorCode("FORG0006");
                xPathException.setIsTypeError(true);
                xPathException.setXPathContext(xPathContext);
                throw xPathException;
            }
        }
        while ((atomicValue = (AtomicValue)object.next()) != null) {
            AtomicValue atomicValue4;
            atomicValue2 = atomicValue4 = atomicValue;
            if (atomicValue instanceof UntypedAtomicValue) {
                try {
                    atomicValue4 = new DoubleValue(stringToDouble.stringToNumber(atomicValue.getStringValueCS()));
                    if (bl5) {
                        return DoubleValue.NaN;
                    }
                    atomicValue2 = atomicValue4;
                    bl7 = true;
                }
                catch (NumberFormatException numberFormatException) {
                    object = new XPathException("Failure converting " + Err.wrap(atomicValue.getStringValueCS()) + " to a number");
                    ((XPathException)object).setErrorCode("FORG0001");
                    ((XPathException)object).setXPathContext(xPathContext);
                    throw object;
                }
            } else if (atomicValue2 instanceof DoubleValue) {
                if (bl5) {
                    return DoubleValue.NaN;
                }
                bl7 = true;
            } else if (atomicValue2 instanceof FloatValue) {
                bl6 = true;
            } else if (atomicValue2 instanceof StringValue && !(atomicValue2 instanceof AnyURIValue)) {
                bl4 = true;
            }
            if (atomicValue2.isNaN()) {
                if (bl3) continue;
                if (bl7) {
                    return DoubleValue.NaN;
                }
                bl5 = true;
                continue;
            }
            try {
                if (atomicComparer.compareAtomicValues(atomicValue2, atomicValue3) >= 0) continue;
                atomicValue3 = atomicValue4;
            }
            catch (ClassCastException classCastException) {
                if (atomicValue3.getItemType() == atomicValue4.getItemType()) {
                    throw classCastException;
                }
                XPathException xPathException = new XPathException("Cannot compare " + atomicValue3.getItemType() + " with " + atomicValue4.getItemType());
                xPathException.setErrorCode("FORG0006");
                xPathException.setIsTypeError(true);
                xPathException.setXPathContext(xPathContext);
                throw xPathException;
            }
        }
        if (bl5) {
            return FloatValue.NaN;
        }
        if (bl7) {
            if (!(atomicValue3 instanceof DoubleValue)) {
                atomicValue3 = Converter.convert(atomicValue3, BuiltInAtomicType.DOUBLE, conversionRules);
            }
        } else if (bl6) {
            if (!(atomicValue3 instanceof FloatValue)) {
                atomicValue3 = Converter.convert(atomicValue3, BuiltInAtomicType.FLOAT, conversionRules);
            }
        } else if (atomicValue3 instanceof AnyURIValue && bl4) {
            atomicValue3 = Converter.convert(atomicValue3, BuiltInAtomicType.STRING, conversionRules);
        }
        return atomicValue3;
    }

    public ZeroOrOne<AtomicValue> call(XPathContext xPathContext, Sequence[] sequenceArray) {
        return new ZeroOrOne<AtomicValue>(Minimax.minimax(sequenceArray[0].iterate(), this.isMaxFunction(), ((CollatingFunctionFixed)this).getAtomicComparer(xPathContext), this.b, xPathContext));
    }

    @Override
    public void exportAttributes(ExpressionPresenter expressionPresenter) {
        super.exportAttributes(expressionPresenter);
        if (this.b) {
            expressionPresenter.emitAttribute("flags", "i");
        }
    }

    @Override
    public void importAttributes(Properties object) {
        super.importAttributes((Properties)object);
        object = ((Properties)object).getProperty("flags");
        if (object != null && ((String)object).contains("i")) {
            this.setIgnoreNaN(true);
        }
    }

    @Override
    public String getStreamerName() {
        return "Minimax";
    }

    public static class Max
    extends Minimax {
        @Override
        public boolean isMaxFunction() {
            return true;
        }
    }

    public static class Min
    extends Minimax {
        @Override
        public boolean isMaxFunction() {
            return false;
        }
    }
}

