/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ScalarSystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.One;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class NormalizeSpace_1
extends ScalarSystemFunction {
    @Override
    public ZeroOrOne<? extends AtomicValue> resultWhenEmpty() {
        return One.string("");
    }

    @Override
    public AtomicValue evaluate(Item item, XPathContext xPathContext) {
        return NormalizeSpace_1.normalizeSpace((StringValue)item);
    }

    public static StringValue normalizeSpace(StringValue stringValue) {
        if (stringValue == null) {
            return StringValue.EMPTY_STRING;
        }
        return StringValue.makeStringValue(Whitespace.collapseWhitespace(stringValue.getStringValueCS()));
    }

    @Override
    public Expression makeFunctionCall(Expression[] expressionArray) {
        NormalizeSpace_1 normalizeSpace_1 = this;
        return new SystemFunctionCall(normalizeSpace_1, normalizeSpace_1, expressionArray){
            private /* synthetic */ NormalizeSpace_1 a;
            {
                this.a = normalizeSpace_1;
                super(normalizeSpace_12, expressionArray);
            }

            @Override
            public final boolean effectiveBooleanValue(XPathContext object) {
                object = (AtomicValue)this.getArg(0).evaluateItem((XPathContext)object);
                if (object == null) {
                    return false;
                }
                return !Whitespace.isWhite((CharSequence)(object = ((AtomicValue)object).getStringValueCS()));
            }
        };
    }

    @Override
    public String getCompilerName() {
        return "NormalizeSpaceCompiler";
    }
}

