/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.serialize.codenorm.Normalizer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class NormalizeUnicode
extends SystemFunction {
    public StringValue call(XPathContext xPathContext, Sequence[] object) {
        StringValue stringValue = (StringValue)object[0].head();
        if (stringValue == null) {
            return StringValue.EMPTY_STRING;
        }
        object = ((Sequence[])object).length == 1 ? "NFC" : Whitespace.trim(object[1].head().getStringValue());
        return NormalizeUnicode.normalize(stringValue, (String)object, xPathContext);
    }

    public static StringValue normalize(StringValue object, String string, XPathContext xPathContext) {
        int n2;
        if (string.equalsIgnoreCase("NFC")) {
            n2 = 2;
        } else if (string.equalsIgnoreCase("NFD")) {
            n2 = 0;
        } else if (string.equalsIgnoreCase("NFKC")) {
            n2 = 3;
        } else if (string.equalsIgnoreCase("NFKD")) {
            n2 = 1;
        } else {
            if (string.isEmpty()) {
                return object;
            }
            String string2 = "Normalization form " + string + " is not supported";
            XPathException xPathException = new XPathException(string2);
            xPathException.setErrorCode("FOCH0003");
            xPathException.setXPathContext(xPathContext);
            throw xPathException;
        }
        boolean bl2 = true;
        CharSequence charSequence = ((AtomicValue)object).getStringValueCS();
        if (charSequence instanceof CompressedWhitespace) {
            return object;
        }
        for (int i2 = charSequence.length() - 1; i2 >= 0; --i2) {
            if (charSequence.charAt(i2) <= '\u007f') continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            return object;
        }
        Normalizer normalizer = Normalizer.make(n2, xPathContext.getConfiguration());
        object = normalizer.normalize(((AtomicValue)object).getStringValueCS());
        return StringValue.makeStringValue((CharSequence)object);
    }
}

