/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Negatable;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;

public class NotFn
extends SystemFunction {
    @Override
    public void supplyTypeInformation(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo, Expression[] expressionArray) {
        if ((object = TypeChecker.ebvError(expressionArray[0], ((ExpressionVisitor)object).getConfiguration().getTypeHierarchy())) != null) {
            throw object;
        }
    }

    public BooleanValue call(XPathContext xPathContext, Sequence[] sequenceArray) {
        return BooleanValue.get(!ExpressionTool.effectiveBooleanValue(sequenceArray[0].iterate()));
    }

    @Override
    public Expression makeFunctionCall(Expression[] expressionArray) {
        NotFn notFn = this;
        return new SystemFunctionCall(notFn, notFn, expressionArray){
            private /* synthetic */ NotFn a;
            {
                this.a = notFn;
                super(notFn2, expressionArray);
            }

            @Override
            public final boolean effectiveBooleanValue(XPathContext xPathContext) {
                try {
                    return !this.getArg(0).effectiveBooleanValue(xPathContext);
                }
                catch (XPathException xPathException) {
                    XPathException xPathException2 = xPathException;
                    xPathException.maybeSetLocation(this.getLocation());
                    xPathException2.maybeSetContext(xPathContext);
                    throw xPathException2;
                }
            }
        };
    }

    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo, Expression ... expressionArray) {
        Object object = expressionVisitor.getStaticContext().getConfiguration().getTypeHierarchy();
        if (expressionArray[0] instanceof Negatable && ((Negatable)((Object)expressionArray[0])).isNegatable((TypeHierarchy)object)) {
            return ((Negatable)((Object)expressionArray[0])).negate();
        }
        if (expressionArray[0].getItemType() instanceof NodeTest) {
            object = SystemFunction.makeFunction("empty", this.getRetainedStaticContext(), 1);
            return ((SystemFunction)object).makeFunctionCall(expressionArray[0]).optimize(expressionVisitor, contextItemStaticInfo);
        }
        return null;
    }

    @Override
    public String getCompilerName() {
        return "NotFnCompiler";
    }

    @Override
    public String getStreamerName() {
        return "NotFn";
    }
}

