/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.ScalarSystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.One;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringToDouble11;
import net.sf.saxon.value.StringValue;

public class Number_1
extends ScalarSystemFunction {
    @Override
    public AtomicValue evaluate(Item item, XPathContext xPathContext) {
        return Number_1.toNumber((AtomicValue)item);
    }

    public ZeroOrOne<NumericValue> resultWhenEmpty() {
        return new One<NumericValue>(DoubleValue.NaN);
    }

    @Override
    public Expression typeCheckCaller(FunctionCall functionCall, ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        if (functionCall.getArg(0).isCallOn(Number_1.class)) {
            functionCall.setArg(0, ((FunctionCall)functionCall.getArg(0)).getArg(0));
        }
        return functionCall;
    }

    public static DoubleValue toNumber(AtomicValue conversionResult) {
        if (conversionResult instanceof BooleanValue) {
            return Converter.BooleanToDouble.INSTANCE.convert((BooleanValue)conversionResult);
        }
        if (conversionResult instanceof NumericValue) {
            return (DoubleValue)Converter.NumericToDouble.INSTANCE.convert((NumericValue)conversionResult).asAtomic();
        }
        if (conversionResult instanceof StringValue && !(conversionResult instanceof AnyURIValue)) {
            conversionResult = ((Converter)StringToDouble11.getInstance()).convert((StringValue)conversionResult);
            if (conversionResult instanceof ValidationFailure) {
                return DoubleValue.NaN;
            }
            return (DoubleValue)conversionResult;
        }
        return DoubleValue.NaN;
    }

    public static DoubleValue convert(AtomicValue atomicValue, Configuration configuration) {
        try {
            if (atomicValue == null) {
                return DoubleValue.NaN;
            }
            if (atomicValue instanceof BooleanValue) {
                return new DoubleValue(((BooleanValue)atomicValue).getBooleanValue() ? 1.0 : 0.0);
            }
            if (atomicValue instanceof DoubleValue) {
                return (DoubleValue)atomicValue;
            }
            if (atomicValue instanceof NumericValue) {
                return new DoubleValue(((NumericValue)atomicValue).getDoubleValue());
            }
            if (atomicValue instanceof StringValue && !(atomicValue instanceof AnyURIValue)) {
                double d2 = configuration.getConversionRules().getStringToDoubleConverter().stringToNumber(atomicValue.getStringValueCS());
                return new DoubleValue(d2);
            }
            return DoubleValue.NaN;
        }
        catch (NumberFormatException numberFormatException) {
            return DoubleValue.NaN;
        }
    }

    @Override
    public String getCompilerName() {
        return "NumberFnCompiler";
    }
}

