/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class OptionsParameter {
    private Map<String, SequenceType> a = new HashMap<String, SequenceType>(8);
    private Map<String, Sequence<?>> b = new HashMap(8);
    private Set<String> c = new HashSet<String>(4);
    private Map<String, Set<String>> d = new HashMap<String, Set<String>>(8);
    private String e;
    private String f = "SXJE9999";
    private boolean g = false;

    public void addAllowedOption(String string, SequenceType sequenceType) {
        this.a.put(string, sequenceType);
    }

    public void addRequiredOption(String string, SequenceType sequenceType) {
        this.a.put(string, sequenceType);
        this.c.add(string);
    }

    public void addAllowedOption(String string, SequenceType sequenceType, Sequence<?> sequence) {
        this.a.put(string, sequenceType);
        if (sequence != null) {
            this.b.put(string, sequence);
        }
    }

    public void setAllowedValues(String string, String string2, String ... object) {
        object = new HashSet<String>(Arrays.asList(object));
        this.d.put(string, (Set<String>)object);
        this.e = string2;
    }

    public Map<String, Sequence<?>> processSuppliedOptions(MapItem mapItem, XPathContext object) {
        Object object2 = new HashMap();
        TypeHierarchy typeHierarchy = object.getConfiguration().getTypeHierarchy();
        for (String object3 : this.c) {
            if (mapItem.get(new StringValue(object3)) != null) continue;
            throw new XPathException("No value supplied for required option: " + object3, this.f);
        }
        for (Map.Entry entry : this.a.entrySet()) {
            Object object3;
            String string = (String)entry.getKey();
            Sequence<AtomicValue> sequence = string.startsWith("Q{") ? new QNameValue(StructuredQName.fromEQName(string), BuiltInAtomicType.QNAME) : new StringValue(string);
            SequenceType sequenceType = (SequenceType)entry.getValue();
            if ((sequence = mapItem.get((AtomicValue)sequence)) != null) {
                Object object4;
                if (!sequenceType.matches(sequence, typeHierarchy)) {
                    boolean bl2 = false;
                    if (sequence instanceof StringValue && this.g && sequenceType.getPrimaryType() instanceof AtomicType) {
                        try {
                            object4 = object.getConfiguration().getConversionRules();
                            sequence = Converter.convert(sequence, (AtomicType)sequenceType.getPrimaryType(), (ConversionRules)object4);
                            bl2 = true;
                        }
                        catch (XPathException xPathException) {
                            bl2 = false;
                        }
                    }
                    if (!bl2) {
                        object4 = new RoleDiagnostic(15, string, 0);
                        ((RoleDiagnostic)object4).setErrorCode("XPTY0004");
                        sequence = typeHierarchy.applyFunctionConversionRules(sequence, sequenceType, (RoleDiagnostic)object4, ExplicitLocation.UNKNOWN_LOCATION);
                    }
                }
                sequence = sequence.materialize();
                object3 = this.d.get(string);
                if (!(object3 == null || sequence instanceof AtomicValue && object3.contains(((AtomicValue)sequence).getStringValue()))) {
                    object4 = new StringBuilder("Invalid option " + string + "=" + Err.depictSequence(sequence) + ". Valid values are:");
                    int n2 = 0;
                    object = object3.iterator();
                    while (object.hasNext()) {
                        object2 = (String)object.next();
                        ((StringBuilder)object4).append(n2++ == 0 ? " " : ", ").append((String)object2);
                    }
                    throw new XPathException(((StringBuilder)object4).toString(), this.e);
                }
                object2.put((String)string, sequence);
                continue;
            }
            object3 = this.b.get(string);
            if (object3 == null) continue;
            object2.put((String)string, object3);
        }
        return object2;
    }

    public Map<String, Sequence<?>> getDefaultOptions() {
        HashMap hashMap = new HashMap();
        for (Map.Entry<String, Sequence<?>> entry : this.b.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    public String getErrorCodeForAbsentValue() {
        return this.f;
    }

    public void setErrorCodeForAbsentValue(String string) {
        this.f = string;
    }

    public boolean isAllowCastFromString() {
        return this.g;
    }

    public void setAllowCastFromString(boolean bl2) {
        this.g = bl2;
    }
}

