/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.IgnorableSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class ParseXml
extends SystemFunction
implements Callable {
    public ZeroOrOne<NodeInfo> call(XPathContext xPathContext, Sequence[] object) {
        if ((object = (StringValue)object[0].head()) == null) {
            return ZeroOrOne.empty();
        }
        return new ZeroOrOne<NodeInfo>(this.a((StringValue)object, xPathContext));
    }

    private TinyDocumentImpl a(StringValue object, XPathContext xPathContext) {
        String string = this.getRetainedStaticContext().getStaticBaseUriString();
        RetentiveErrorHandler retentiveErrorHandler = new RetentiveErrorHandler();
        try {
            Object object2 = xPathContext.getController();
            if (object2 == null) {
                throw new XPathException("parse-xml() function is not available in this environment");
            }
            Configuration configuration = ((Controller)object2).getConfiguration();
            object = new StringReader(((AtomicValue)object).getStringValue());
            object = new InputSource((Reader)object);
            ((InputSource)object).setSystemId(string);
            object = new SAXSource((InputSource)object);
            object.setSystemId(string);
            object2 = TreeModel.TINY_TREE.makeBuilder(((Controller)object2).makePipelineConfiguration());
            Receiver receiver = object2;
            ParseOptions parseOptions = new ParseOptions(configuration.getParseOptions());
            PackageData packageData = this.getRetainedStaticContext().getPackageData();
            if (packageData instanceof StylesheetPackage) {
                parseOptions.setSpaceStrippingRule(((StylesheetPackage)packageData).getSpaceStrippingRule());
                if (((StylesheetPackage)packageData).isStripsTypeAnnotations()) {
                    receiver = configuration.getAnnotationStripper(receiver);
                }
            } else {
                parseOptions.setSpaceStrippingRule(IgnorableSpaceStrippingRule.getInstance());
            }
            parseOptions.setErrorHandler(retentiveErrorHandler);
            receiver.setPipelineConfiguration(((Builder)object2).getPipelineConfiguration());
            Sender.send((Source)object, receiver, parseOptions);
            object = (TinyDocumentImpl)((Builder)object2).getCurrentRoot();
            ((TinyDocumentImpl)object).setBaseURI(string);
            ((TinyNodeImpl)object).getTreeInfo().setUserData("saxon:document-uri", "");
            ((Builder)object2).reset();
            return object;
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = new XPathException("First argument to parse-xml() is not a well-formed and namespace-well-formed XML document. XML parser reported: " + xPathException.getMessage(), "FODC0006");
            retentiveErrorHandler.captureRetainedErrors(xPathException2);
            xPathException2.maybeSetContext(xPathContext);
            throw xPathException2;
        }
    }

    public static class RetentiveErrorHandler
    implements ErrorHandler {
        public List<SAXParseException> errors = new ArrayList<SAXParseException>();
        public boolean failed = false;

        @Override
        public void error(SAXParseException sAXParseException) {
            this.errors.add(sAXParseException);
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) {
            this.errors.add(sAXParseException);
            this.failed = true;
        }

        public void captureRetainedErrors(XPathException xPathException) {
            List<SAXParseException> list = this.errors;
            if (!list.isEmpty()) {
                ArrayList<ObjectValue<SAXParseException>> arrayList = new ArrayList<ObjectValue<SAXParseException>>();
                for (SAXParseException sAXParseException : list) {
                    arrayList.add(new ObjectValue<SAXParseException>(sAXParseException));
                }
                xPathException.setErrorObject(SequenceExtent.makeSequenceExtent(arrayList));
            }
        }
    }
}

