/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ScalarSystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class Path_1
extends ScalarSystemFunction {
    @Override
    public AtomicValue evaluate(Item item, XPathContext xPathContext) {
        return Path_1.makePath((NodeInfo)item, xPathContext);
    }

    public static StringValue makePath(NodeInfo object, XPathContext xPathContext) {
        NodeInfo nodeInfo;
        if (object.getNodeKind() == 9) {
            return StringValue.makeStringValue("/");
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
        object = object.iterateAxis((byte)1);
        block9: while ((nodeInfo = object.next()) != null) {
            if (nodeInfo.getParent() == null) {
                if (nodeInfo.getNodeKind() == 9) {
                    return new StringValue(fastStringBuffer);
                }
                fastStringBuffer.prepend("Q{http://www.w3.org/2005/xpath-functions}root()");
                return new StringValue(fastStringBuffer);
            }
            FastStringBuffer fastStringBuffer2 = new FastStringBuffer(256);
            switch (nodeInfo.getNodeKind()) {
                case 9: {
                    return new StringValue(fastStringBuffer);
                }
                case 1: {
                    fastStringBuffer2.append("/Q{");
                    fastStringBuffer2.append(nodeInfo.getURI());
                    fastStringBuffer2.append("}");
                    fastStringBuffer2.append(nodeInfo.getLocalPart());
                    fastStringBuffer2.append("[" + Navigator.getNumberSimple(nodeInfo, xPathContext) + "]");
                    fastStringBuffer2.append(fastStringBuffer);
                    fastStringBuffer = fastStringBuffer2;
                    continue block9;
                }
                case 2: {
                    fastStringBuffer2.append("/@");
                    String string = nodeInfo.getURI();
                    if (!"".equals(string)) {
                        fastStringBuffer2.append("Q{");
                        fastStringBuffer2.append(string);
                        fastStringBuffer2.append("}");
                    }
                    fastStringBuffer2.append(nodeInfo.getLocalPart());
                    fastStringBuffer2.append(fastStringBuffer);
                    fastStringBuffer = fastStringBuffer2;
                    continue block9;
                }
                case 3: {
                    fastStringBuffer2.append("/text()[");
                    fastStringBuffer2.append(Navigator.getNumberSimple(nodeInfo, xPathContext) + "]");
                    fastStringBuffer2.append(fastStringBuffer);
                    fastStringBuffer = fastStringBuffer2;
                    continue block9;
                }
                case 8: {
                    fastStringBuffer2.append("/comment()[");
                    fastStringBuffer2.append(Navigator.getNumberSimple(nodeInfo, xPathContext) + "]");
                    fastStringBuffer2.append(fastStringBuffer);
                    fastStringBuffer = fastStringBuffer2;
                    continue block9;
                }
                case 7: {
                    fastStringBuffer2.append("/processing-instruction(");
                    fastStringBuffer2.append(nodeInfo.getLocalPart());
                    fastStringBuffer2.append(")[");
                    fastStringBuffer2.append(Navigator.getNumberSimple(nodeInfo, xPathContext) + "]");
                    fastStringBuffer2.append(fastStringBuffer);
                    fastStringBuffer = fastStringBuffer2;
                    continue block9;
                }
                case 13: {
                    fastStringBuffer2.append("/namespace::");
                    if (nodeInfo.getLocalPart().isEmpty()) {
                        fastStringBuffer2.append("*[Q{http://www.w3.org/2005/xpath-functions}local-name()=\"\"]");
                    } else {
                        fastStringBuffer.append(nodeInfo.getLocalPart());
                    }
                    fastStringBuffer2.append(fastStringBuffer);
                    fastStringBuffer = fastStringBuffer2;
                    continue block9;
                }
            }
            throw new AssertionError();
        }
        fastStringBuffer.prepend("Q{http://www.w3.org/2005/xpath-functions}root()");
        return new StringValue(fastStringBuffer);
    }
}

