/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.functions.ConstantFunction;
import net.sf.saxon.functions.ContextAccessorFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public abstract class PositionAndLast
extends ContextAccessorFunction {
    private boolean a = true;

    @Override
    public int getNetCost() {
        return 0;
    }

    @Override
    public Function bindContext(XPathContext object) {
        try {
            object = this.evaluateItem((XPathContext)object);
        }
        catch (XPathException xPathException) {
            SymbolicName.F f2 = new SymbolicName.F(this.getFunctionName(), this.getArity());
            Callable callable = (xPathContext, sequenceArray) -> {
                throw xPathException;
            };
            return new CallableFunction(f2, callable, this.getFunctionItemType());
        }
        object = new ConstantFunction((GroundedValue<?>)object);
        ((SystemFunction)object).setDetails(this.getDetails());
        ((SystemFunction)object).setRetainedStaticContext(this.getRetainedStaticContext());
        return object;
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        return new IntegerValue[]{Int64Value.PLUS_ONE, Expression.MAX_SEQUENCE_LENGTH};
    }

    @Override
    public void supplyTypeInformation(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo, Expression[] expressionArray) {
        super.supplyTypeInformation((ExpressionVisitor)object, contextItemStaticInfo, expressionArray);
        if (contextItemStaticInfo.getItemType() == ErrorType.getInstance()) {
            object = new XPathException("The context item is absent at this point");
            ((XPathException)object).setErrorCode("XPDY0002");
            throw object;
        }
        this.a = contextItemStaticInfo.isPossiblyAbsent();
    }

    public boolean isContextPossiblyUndefined() {
        return this.a;
    }

    public abstract Int64Value evaluateItem(XPathContext var1);

    public IntegerValue call(XPathContext xPathContext, Sequence[] sequenceArray) {
        return this.evaluateItem(xPathContext);
    }

    public static class Last
    extends PositionAndLast {
        @Override
        public Int64Value evaluateItem(XPathContext xPathContext) {
            return Int64Value.makeIntegerValue(xPathContext.getLast());
        }

        @Override
        public String getCompilerName() {
            return "LastCompiler";
        }

        @Override
        public String getStreamerName() {
            return "Last";
        }
    }

    public static class Position
    extends PositionAndLast {
        @Override
        public Int64Value evaluateItem(XPathContext xPathContext) {
            FocusIterator<?> focusIterator = xPathContext.getCurrentIterator();
            if (focusIterator == null) {
                focusIterator = new XPathException("The context item is absent, so position() is undefined");
                ((XPathException)((Object)focusIterator)).setXPathContext(xPathContext);
                ((XPathException)((Object)focusIterator)).setErrorCode("XPDY0002");
                throw focusIterator;
            }
            return Int64Value.makeIntegerValue(focusIterator.position());
        }

        @Override
        public String getCompilerName() {
            return "PositionCompiler";
        }
    }
}

