/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;

public class QNameFn
extends SystemFunction {
    public static QNameValue expandedQName(StringValue object, StringValue stringArray) {
        object = object == null ? null : ((AtomicValue)object).getStringValue();
        try {
            stringArray = stringArray.getStringValue();
            stringArray = NameChecker.getQNameParts((CharSequence)stringArray);
            if (!stringArray[0].isEmpty() && !NameChecker.isValidNCName(stringArray[0])) {
                object = new XPathException("Malformed prefix in QName: '" + stringArray[0] + '\'');
                ((XPathException)object).setErrorCode("FOCA0002");
                throw object;
            }
            return new QNameValue(stringArray[0], (String)object, stringArray[1], BuiltInAtomicType.QNAME, true);
        }
        catch (QNameException qNameException) {
            throw new XPathException(qNameException.getMessage(), "FOCA0002");
        }
        catch (XPathException xPathException) {
            stringArray = xPathException;
            if (xPathException.getErrorCodeLocalPart().equals("FORG0001")) {
                stringArray.setErrorCode("FOCA0002");
            }
            throw stringArray;
        }
    }

    public QNameValue call(XPathContext xPathContext, Sequence[] sequenceArray) {
        return QNameFn.expandedQName((StringValue)sequenceArray[0].head(), (StringValue)sequenceArray[1].head());
    }

    @Override
    public String getCompilerName() {
        return "QNameFnCompiler";
    }
}

