/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public class Remove
extends SystemFunction {
    @Override
    public Expression makeFunctionCall(Expression[] expressionArray) {
        GroundedValue<?> groundedValue;
        if (Literal.isAtomic(expressionArray[1]) && (groundedValue = ((Literal)expressionArray[1]).getValue()) instanceof IntegerValue) {
            try {
                long l2 = ((IntegerValue)groundedValue).longValue();
                if (l2 <= 0L) {
                    return expressionArray[0];
                }
                if (l2 == 1L) {
                    return new TailExpression(expressionArray[0], 2);
                }
            }
            catch (XPathException xPathException) {}
        }
        return super.makeFunctionCall(expressionArray);
    }

    @Override
    public Sequence<?> call(XPathContext object, Sequence[] sequenceArray) {
        object = (NumericValue)sequenceArray[1].head();
        int n2 = (int)((NumericValue)object).longValue();
        if (n2 <= 0) {
            return sequenceArray[0];
        }
        return SequenceTool.toLazySequence2(new RemoveIterator(sequenceArray[0].iterate(), n2));
    }

    @Override
    public String getStreamerName() {
        return "Remove";
    }

    public static class RemoveIterator<T extends Item<?>>
    implements LastPositionFinder,
    SequenceIterator<T> {
        private SequenceIterator<T> a;
        private int b;
        private int c = 0;
        private T d = null;

        public RemoveIterator(SequenceIterator<T> sequenceIterator, int n2) {
            this.a = sequenceIterator;
            this.b = n2;
        }

        @Override
        public T next() {
            this.d = this.a.next();
            ++this.c;
            if (this.d != null && this.c == this.b) {
                this.d = this.a.next();
                ++this.c;
            }
            return this.d;
        }

        @Override
        public void close() {
            this.a.close();
        }

        @Override
        public int getLength() {
            if (this.a instanceof LastPositionFinder) {
                int n2 = ((LastPositionFinder)((Object)this.a)).getLength();
                if (this.b > 0 && this.b <= n2) {
                    return n2 - 1;
                }
                return n2;
            }
            throw new AssertionError((Object)"base of removeIterator is not a LastPositionFinder");
        }

        @Override
        public int getProperties() {
            return this.a.getProperties() & 2;
        }
    }
}

