/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;

public class ResolveURI
extends SystemFunction {
    public ZeroOrOne<AnyURIValue> call(XPathContext xPathContext, Sequence[] object) {
        Object object2 = (AtomicValue)object[0].head();
        if (object2 == null) {
            return ZeroOrOne.empty();
        }
        object2 = ((AtomicValue)object2).getStringValue();
        if (this.getArity() == 2) {
            object = object[1].head().getStringValue();
        } else {
            object = this.getStaticBaseUriString();
            if (object == null) {
                throw new XPathException("Base URI in static context of resolve-uri() is unknown", "FONS0005", xPathContext);
            }
        }
        return new ZeroOrOne<AnyURIValue>(ResolveURI.a((String)object, (String)object2, xPathContext));
    }

    private static AnyURIValue a(String string, String object, XPathContext xPathContext) {
        URI uRI;
        boolean bl2 = false;
        if (((String)object).contains(" ")) {
            object = ResolveURI.escapeSpaces((String)object);
            bl2 = true;
        }
        if (string.contains(" ")) {
            string = ResolveURI.escapeSpaces(string);
            bl2 = true;
        }
        try {
            uRI = new URI((String)object);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XPathException("Relative URI " + Err.wrap((CharSequence)object) + " is invalid: " + uRISyntaxException.getMessage(), "FORG0002", xPathContext);
        }
        if (uRI.isAbsolute()) {
            return new AnyURIValue((CharSequence)object);
        }
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XPathException("Base URI " + Err.wrap(string) + " is invalid: " + uRISyntaxException.getMessage(), "FORG0002", xPathContext);
        }
        if (!uRI.isAbsolute()) {
            throw new XPathException("Base URI " + Err.wrap(string) + " is not an absolute URI", "FORG0002", xPathContext);
        }
        if (uRI.isOpaque() && !string.startsWith("jar:")) {
            throw new XPathException("Base URI " + Err.wrap(string) + " is a non-hierarchic URI", "FORG0002", xPathContext);
        }
        if (uRI.getRawFragment() != null) {
            throw new XPathException("Base URI " + Err.wrap(string) + " contains a fragment identifier", "FORG0002", xPathContext);
        }
        if (!string.startsWith("jar:") && uRI.getPath() != null && uRI.getPath().isEmpty()) {
            try {
                uRI = new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), "/", uRI.getQuery(), uRI.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new XPathException("Failed to parse JAR scheme URI " + Err.wrap(uRI.toASCIIString()), "FORG0002", xPathContext);
            }
            string = uRI.toString();
        }
        try {
            object = ResolveURI.makeAbsolute((String)object, string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XPathException(uRISyntaxException.getMessage(), "FORG0002");
        }
        if (!((URI)object).toASCIIString().startsWith("file:////")) {
            object = ((URI)object).normalize();
        }
        String string2 = string = bl2 ? ResolveURI.unescapeSpaces(((URI)object).toString()) : ((URI)object).toString();
        while (string2.endsWith("..")) {
            string2 = string.substring(0, string.length() - 2);
        }
        while (string.endsWith("../")) {
            string = string.substring(0, string.length() - 3);
        }
        return new AnyURIValue(string);
    }

    public static String tryToExpand(String string) {
        if (string == null) {
            string = "";
        }
        try {
            new URL(string);
            return string;
        }
        catch (MalformedURLException malformedURLException) {
            Object object;
            try {
                object = System.getProperty("user.dir");
            }
            catch (Exception exception) {
                return string;
            }
            if (!((String)object).endsWith("/") && !string.startsWith("/")) {
                object = (String)object + '/';
            }
            try {
                object = new File((String)object).toURI();
                object = ((URI)object).resolve(string);
                return ((URI)object).toString();
            }
            catch (Exception exception) {
                return string;
            }
        }
    }

    public static URI makeAbsolute(String string, String string2) {
        Serializable serializable;
        block20: {
            if (string == null) {
                if (string2 == null) {
                    throw new URISyntaxException("", "Relative and Base URI must not both be null");
                }
                URI uRI = new URI(ResolveURI.escapeSpaces(string2));
                if (!uRI.isAbsolute()) {
                    throw new URISyntaxException(string2, "Relative URI not supplied, so base URI must be absolute");
                }
                return uRI;
            }
            try {
                URI uRI;
                if (string2 == null || string2.isEmpty()) {
                    String string3;
                    serializable = new URI(string);
                    if (!serializable.isAbsolute() && !(string3 = ResolveURI.tryToExpand(string2)).equals(string2)) {
                        return ResolveURI.makeAbsolute(string, string3);
                    }
                    break block20;
                }
                if (string2.startsWith("jar:") || string2.startsWith("file:////")) {
                    try {
                        URL uRL = new URL(string2);
                        serializable = new URL(uRL, string);
                        serializable = ((URL)serializable).toURI();
                        break block20;
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new URISyntaxException(string2 + " " + string, malformedURLException.getMessage());
                    }
                }
                if (string2.startsWith("classpath:")) {
                    serializable = new URI(string);
                    if (!serializable.isAbsolute()) {
                        serializable = new URI("classpath:" + string);
                    }
                    break block20;
                }
                try {
                    uRI = new URI(string2);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new URISyntaxException(string2, "Invalid base URI: " + uRISyntaxException.getMessage());
                }
                if (uRI.getFragment() != null) {
                    int n2 = string2.indexOf(35);
                    if (n2 >= 0) {
                        string2 = string2.substring(0, n2);
                    }
                    try {
                        uRI = new URI(string2);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new URISyntaxException(string2, "Invalid base URI: " + uRISyntaxException.getMessage());
                    }
                }
                try {
                    new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new URISyntaxException(string2, "Invalid relative URI: " + uRISyntaxException.getMessage());
                }
                serializable = string.isEmpty() ? uRI : uRI.resolve(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new URISyntaxException(string, "Cannot resolve URI against base " + Err.wrap(string2));
            }
        }
        return serializable;
    }

    public static String escapeSpaces(String string) {
        int n2 = string.indexOf(32);
        if (n2 < 0) {
            return string;
        }
        return (n2 == 0 ? "" : string.substring(0, n2)) + "%20" + (n2 == string.length() - 1 ? "" : ResolveURI.escapeSpaces(string.substring(n2 + 1)));
    }

    public static String unescapeSpaces(String string) {
        return string.replace("%20", " ");
    }
}

