/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.value.SequenceExtent;

public class Reverse
extends SystemFunction {
    @Override
    public int getSpecialProperties(Expression[] expressionArray) {
        int n2 = expressionArray[0].getSpecialProperties();
        if ((n2 & 0x40000) != 0) {
            return n2 & 0xFFFBFFFF | 0x20000;
        }
        if ((n2 & 0x20000) != 0) {
            return n2 & 0xFFFDFFFF | 0x40000;
        }
        return n2;
    }

    public static <T extends Item<?>> SequenceIterator<T> getReverseIterator(SequenceIterator<T> object) {
        if (object instanceof ReversibleIterator) {
            return ((ReversibleIterator)object).getReverseIterator();
        }
        object = new SequenceExtent<T>(object);
        return ((SequenceExtent)object).reverseIterate();
    }

    @Override
    public Sequence<?> call(XPathContext xPathContext, Sequence[] sequenceArray) {
        return SequenceTool.toLazySequence(Reverse.getReverseIterator(sequenceArray[0].iterate()));
    }

    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo, Expression ... expressionArray) {
        if (expressionArray[0].getCardinality() == 24576) {
            return expressionArray[0];
        }
        return super.makeOptimizedFunctionCall(expressionVisitor, contextItemStaticInfo, expressionArray);
    }

    @Override
    public String getStreamerName() {
        return "Reverse";
    }
}

