/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceCopier;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.functions.OptionsParameter;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.serialize.SerializationParamsHandler;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntHashMap;

public class Serialize
extends SystemFunction
implements Callable {
    private String[] a = new String[]{"allow-duplicate-names", "byte-order-mark", "cdata-section-elements", "doctype-public", "doctype-system", "encoding", "escape-uri-attributes", "html-version", "include-content-type", "indent", "item-separator", "json-node-output-method", "media-type", "method", "normalization-form", "omit-xml-declaration", "standalone", "suppress-indentation", "undeclare-prefixes", "use-character-maps", "version"};
    private String[] b = new String[]{"attribute-order", "character-representation", "double-space", "indent-spaces", "line-length", "property-order", "recognize-binary", "require-well-formed", "single-quotes", "supply-source-locator", "suppress-indentation"};
    private static final Map<String, SequenceType> c = new HashMap<String, SequenceType>(40);
    private static final Map<String, SequenceType> d;

    public static OptionsParameter makeOptionsParameter() {
        SequenceType sequenceType = BuiltInAtomicType.QNAME.zeroOrMore();
        OptionsParameter optionsParameter = new OptionsParameter();
        optionsParameter.addAllowedOption("allow-duplicate-names", SequenceType.SINGLE_BOOLEAN);
        optionsParameter.addAllowedOption("byte-order-mark", SequenceType.SINGLE_BOOLEAN);
        optionsParameter.addAllowedOption("cdata-section-elements", sequenceType, EmptySequence.getInstance());
        optionsParameter.addAllowedOption("doctype-public", SequenceType.SINGLE_STRING);
        optionsParameter.addAllowedOption("doctype-system", SequenceType.SINGLE_STRING);
        optionsParameter.addAllowedOption("encoding", SequenceType.SINGLE_STRING);
        optionsParameter.addAllowedOption("escape-uri-attributes", SequenceType.SINGLE_BOOLEAN);
        optionsParameter.addAllowedOption("html-version", SequenceType.SINGLE_DECIMAL);
        optionsParameter.addAllowedOption("include-content-type", SequenceType.SINGLE_BOOLEAN);
        optionsParameter.addAllowedOption("indent", SequenceType.SINGLE_BOOLEAN);
        optionsParameter.addAllowedOption("item-separator", SequenceType.SINGLE_STRING);
        optionsParameter.addAllowedOption("json-node-output-method", SequenceType.SINGLE_STRING);
        optionsParameter.addAllowedOption("media-type", SequenceType.SINGLE_STRING);
        optionsParameter.addAllowedOption("method", SequenceType.SINGLE_STRING);
        optionsParameter.addAllowedOption("normalization-form", SequenceType.SINGLE_STRING);
        optionsParameter.addAllowedOption("omit-xml-declaration", SequenceType.SINGLE_BOOLEAN);
        optionsParameter.addAllowedOption("standalone", SequenceType.OPTIONAL_BOOLEAN);
        optionsParameter.addAllowedOption("suppress-indentation", sequenceType);
        optionsParameter.addAllowedOption("undeclare-prefixes", SequenceType.SINGLE_BOOLEAN);
        optionsParameter.addAllowedOption("use-character-maps", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        optionsParameter.addAllowedOption("version", SequenceType.SINGLE_STRING);
        optionsParameter.addAllowedOption(Serialize.a("attribute-order"), SequenceType.ATOMIC_SEQUENCE);
        optionsParameter.addAllowedOption(Serialize.a("character-representation"), SequenceType.SINGLE_STRING);
        optionsParameter.addAllowedOption(Serialize.a("double-space"), sequenceType);
        optionsParameter.addAllowedOption(Serialize.a("indent-spaces"), SequenceType.SINGLE_INTEGER);
        optionsParameter.addAllowedOption(Serialize.a("line-length"), SequenceType.SINGLE_INTEGER);
        optionsParameter.addAllowedOption(Serialize.a("property-order"), SequenceType.STRING_SEQUENCE);
        optionsParameter.addAllowedOption(Serialize.a("recognize-binary"), SequenceType.SINGLE_BOOLEAN);
        optionsParameter.addAllowedOption(Serialize.a("require-well-formed"), SequenceType.SINGLE_BOOLEAN);
        optionsParameter.addAllowedOption(Serialize.a("single-quotes"), SequenceType.SINGLE_BOOLEAN);
        optionsParameter.addAllowedOption(Serialize.a("supply-source-locator"), SequenceType.SINGLE_BOOLEAN);
        return optionsParameter;
    }

    private static String a(String string) {
        return "Q{http://saxon.sf.net/}" + string;
    }

    private static String a(Sequence<?> sequence) {
        boolean bl2 = ((BooleanValue)sequence.head()).getBooleanValue();
        String string = bl2 ? "yes" : "no";
        return string;
    }

    private static String a(Sequence object, boolean bl2) {
        Object object2;
        object = object.iterate();
        StringBuilder stringBuilder = new StringBuilder();
        while ((object2 = object.next()) != null) {
            if (object2 instanceof QNameValue) {
                object2 = (QNameValue)object2;
                stringBuilder.append(" Q{").append(((AtomicValue)object2).getComponent(AccessorFn.Component.NAMESPACE).getStringValue()).append('}').append(((AtomicValue)object2).getComponent(AccessorFn.Component.LOCALNAME).getStringValue());
                continue;
            }
            if (bl2 && object2 instanceof StringValue && object2.getStringValue().equals("*")) {
                stringBuilder.append(" *");
                continue;
            }
            throw new XPathException("Invalid serialization parameter value: expected sequence of QNames " + (bl2 ? "(or *) " : ""), "SEPM0017");
        }
        return stringBuilder.toString();
    }

    private static String b(Sequence<?> object) {
        if (object.head() instanceof QNameValue) {
            object = (QNameValue)object.head();
            object = "{" + ((AtomicValue)object).getComponent(AccessorFn.Component.NAMESPACE).toString() + '}' + ((AtomicValue)object).getComponent(AccessorFn.Component.LOCALNAME);
        } else {
            object = object.head().getStringValue();
        }
        return object;
    }

    public static CharacterMap toCharacterMap(MapItem mapItem) {
        Object object;
        AtomicIterator atomicIterator = mapItem.keys();
        IntHashMap<String> intHashMap = new IntHashMap<String>();
        while ((object = atomicIterator.next()) != null) {
            CharSequence charSequence = ((AtomicValue)object).getStringValue();
            object = mapItem.get((AtomicValue)object).head().getStringValue();
            if (((UnicodeString)(charSequence = UnicodeString.makeUnicodeString(charSequence))).uLength() != 1) {
                throw new XPathException("In the serialization parameter for the character map, each character to be mapped must be a single Unicode character", "SEPM0016");
            }
            int n2 = ((UnicodeString)charSequence).uCharAt(0);
            object = intHashMap.put(n2, (String)object);
            if (object == null) continue;
            throw new XPathException("In the serialization parameters, the character map contains two entries for the character \\u" + Integer.toHexString(n2 + 65536).substring(1), "SEPM0018");
        }
        StructuredQName structuredQName = new StructuredQName("output", "http://www.w3.org/2010/xslt-xquery-serialization", "serialization-parameters");
        return new CharacterMap(structuredQName, intHashMap);
    }

    public StringValue call(XPathContext xPathContext, Sequence[] sequenceArray) {
        return this.a(sequenceArray[0].iterate(), sequenceArray.length == 1 ? null : (Item)sequenceArray[1].head(), xPathContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StringValue a(SequenceIterator<?> sequenceIterator, Item object, XPathContext xPathContext) {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (object != null) {
            if (object instanceof NodeInfo) {
                object5 = (NodeInfo)object;
                if (object5.getNodeKind() != 1 || !"http://www.w3.org/2010/xslt-xquery-serialization".equals(object5.getURI()) || !"serialization-parameters".equals(object5.getLocalPart())) {
                    throw new XPathException("Second argument to fn:serialize() must be an element named {http://www.w3.org/2010/xslt-xquery-serialization}serialization-parameters", "XPTY0004");
                }
                object4 = new SerializationParamsHandler();
                ((SerializationParamsHandler)object4).setSerializationParams((NodeInfo)object5);
                object = ((SerializationParamsHandler)object4).getSerializationProperties();
            } else {
                if (!(object instanceof MapItem)) throw new XPathException("Second argument to fn:serialize() must either be an element named {http://www.w3.org/2010/xslt-xquery-serialization}serialization-parameters, or a map (if using XPath 3.1)", "XPTY0004");
                object5 = (MapItem)object;
                object4 = ((MapItem)object).keys();
                while ((object3 = object4.next()) != null) {
                    if (!(object3 instanceof QNameValue)) continue;
                    object2 = ((QNameValue)object3).getStructuredQName().getEQName();
                    object5 = object5.addEntry(new StringValue((CharSequence)object2), object5.get((AtomicValue)object3));
                }
                object2 = this.getDetails().optionDetails.processSuppliedOptions((MapItem)object5, xPathContext);
                object4 = xPathContext;
                object5 = object2;
                object = this;
                object2 = new Properties();
                CharacterMapIndex characterMapIndex = new CharacterMapIndex();
                object3 = (Sequence)object5.get("allow-duplicate-names");
                if (object3 != null) {
                    ((Properties)object2).setProperty("allow-duplicate-names", Serialize.a(object3));
                }
                if ((object3 = (Sequence)object5.get("byte-order-mark")) != null) {
                    ((Properties)object2).setProperty("byte-order-mark", Serialize.a(object3));
                }
                if ((object3 = (Sequence)object5.get("cdata-section-elements")) != null) {
                    ((Properties)object2).setProperty("cdata-section-elements", Serialize.a((Sequence)object3, false));
                }
                if ((object3 = (Sequence)object5.get("doctype-public")) != null) {
                    ((Properties)object2).setProperty("doctype-public", object3.head().getStringValue());
                }
                if ((object3 = (Sequence)object5.get("doctype-system")) != null) {
                    ((Properties)object2).setProperty("doctype-system", object3.head().getStringValue());
                }
                if ((object3 = (Sequence)object5.get("encoding")) != null) {
                    ((Properties)object2).setProperty("encoding", object3.head().getStringValue());
                }
                if ((object3 = (Sequence)object5.get("escape-uri-attributes")) != null) {
                    ((Properties)object2).setProperty("escape-uri-attributes", Serialize.a(object3));
                }
                if ((object3 = (Sequence)object5.get("html-version")) != null) {
                    ((Properties)object2).setProperty("html-version", object3.head().getStringValue());
                }
                if ((object3 = (Sequence)object5.get("include-content-type")) != null) {
                    ((Properties)object2).setProperty("include-content-type", Serialize.a(object3));
                }
                if ((object3 = (Sequence)object5.get("indent")) != null) {
                    ((Properties)object2).setProperty("indent", Serialize.a(object3));
                }
                if ((object3 = (Sequence)object5.get("item-separator")) != null) {
                    ((Properties)object2).setProperty("item-separator", object3.head().getStringValue());
                }
                if ((object3 = (Sequence)object5.get("json-node-output-method")) != null) {
                    ((Properties)object2).setProperty("json-node-output-method", Serialize.b(object3));
                }
                if ((object3 = (Sequence)object5.get("media-type")) != null) {
                    ((Properties)object2).setProperty("media-type", object3.head().getStringValue());
                }
                if ((object3 = (Sequence)object5.get("method")) != null) {
                    ((Properties)object2).setProperty("method", Serialize.b(object3));
                }
                if ((object3 = (Sequence)object5.get("normalization-form")) != null) {
                    ((Properties)object2).setProperty("normalization-form", object3.head().getStringValue());
                }
                if ((object3 = (Sequence)object5.get("omit-xml-declaration")) != null) {
                    ((Properties)object2).setProperty("omit-xml-declaration", Serialize.a(object3));
                }
                if ((object3 = (Sequence)object5.get("standalone")) != null) {
                    object = "";
                    if (object3 instanceof EmptySequence) {
                        object = "omit";
                    } else if (object3.head() instanceof BooleanValue) {
                        object = Serialize.a(object3);
                    }
                    ((Properties)object2).setProperty("standalone", (String)object);
                }
                if ((object3 = (Sequence)object5.get("suppress-indentation")) != null) {
                    ((Properties)object2).setProperty("suppress-indentation", Serialize.a((Sequence)object3, false));
                }
                if ((object3 = (Sequence)object5.get("undeclare-prefixes")) != null) {
                    ((Properties)object2).setProperty("undeclare-prefixes", Serialize.a(object3));
                }
                if ((object3 = (Sequence)object5.get("use-character-maps")) != null) {
                    Object object6 = object3;
                    object3 = object4;
                    object = object6;
                    object = object3;
                    object3 = (MapItem)object6.head();
                    object = object.getConfiguration().getTypeHierarchy();
                    for (KeyValuePair keyValuePair : object3.keyValuePairs()) {
                        AtomicValue atomicValue = keyValuePair.key;
                        if (!(atomicValue instanceof StringValue)) {
                            throw new XPathException("Keys in a character map must all be strings. Found a value of type " + atomicValue.getItemType(), "XPTY0004");
                        }
                        if (((StringValue)atomicValue).getStringLength() != 1) {
                            throw new XPathException("Keys in a character map must all be one-character strings. Found " + Err.wrap(atomicValue.toString()), "SEPM0016");
                        }
                        if (SequenceType.SINGLE_STRING.matches(keyValuePair.value, (TypeHierarchy)object)) continue;
                        throw new XPathException("Values in a character map must all be single strings. Found " + Err.wrap(atomicValue.toString()), "XPTY0004");
                    }
                    object4 = object3;
                    object = Serialize.toCharacterMap((MapItem)object4);
                    characterMapIndex.putCharacterMap(new StructuredQName("", "", "charMap"), (CharacterMap)object);
                    ((Properties)object2).setProperty("use-character-maps", "charMap");
                }
                if ((object3 = (Sequence)object5.get("version")) != null) {
                    ((Properties)object2).setProperty("version", object3.head().getStringValue());
                }
                if ((object3 = (Sequence)object5.get(Serialize.a("attribute-order"))) != null) {
                    ((Properties)object2).setProperty("{http://saxon.sf.net/}attribute-order", Serialize.a((Sequence)object3, true));
                }
                if ((object3 = (Sequence)object5.get(Serialize.a("canonical"))) != null) {
                    ((Properties)object2).setProperty("{http://saxon.sf.net/}canonical", Serialize.a(object3));
                }
                if ((object3 = (Sequence)object5.get(Serialize.a("character-representation"))) != null) {
                    ((Properties)object2).setProperty("{http://saxon.sf.net/}character-representation", object3.head().getStringValue());
                }
                if ((object3 = (Sequence)object5.get(Serialize.a("double-space"))) != null) {
                    ((Properties)object2).setProperty("{http://saxon.sf.net/}double-space", Serialize.a((Sequence)object3, false));
                }
                if ((object3 = (Sequence)object5.get(Serialize.a("indent-spaces"))) != null) {
                    ((Properties)object2).setProperty("{http://saxon.sf.net/}indent-spaces", object3.head().getStringValue());
                }
                if ((object3 = (Sequence)object5.get(Serialize.a("line-length"))) != null) {
                    ((Properties)object2).setProperty("{http://saxon.sf.net/}line-length", object3.head().getStringValue());
                }
                if ((object3 = (Sequence)object5.get(Serialize.a("property-order"))) != null) {
                    object = object3;
                    object = object.iterate();
                    object3 = new StringBuilder();
                    while ((object4 = object.next()) != null) {
                        ((StringBuilder)object3).append(" ").append(object4.getStringValue());
                    }
                    ((Properties)object2).setProperty("{http://saxon.sf.net/}property-order", ((StringBuilder)object3).toString());
                }
                if ((object3 = (Sequence)object5.get(Serialize.a("recognize-binary"))) != null) {
                    ((Properties)object2).setProperty("{http://saxon.sf.net/}recognize-binary", Serialize.a(object3));
                }
                if ((object3 = (Sequence)object5.get(Serialize.a("require-well-formed"))) != null) {
                    ((Properties)object2).setProperty("{http://saxon.sf.net/}require-well-formed", Serialize.a(object3));
                }
                if ((object3 = (Sequence)object5.get(Serialize.a("single-quotes"))) != null) {
                    ((Properties)object2).setProperty("{http://saxon.sf.net/}single-quotes", Serialize.a(object3));
                }
                if ((object3 = (Sequence)object5.get(Serialize.a("supply-source-locator"))) != null) {
                    ((Properties)object2).setProperty("{http://saxon.sf.net/}supply-source-locator", Serialize.a(object3));
                }
                object = new SerializationProperties((Properties)object2, characterMapIndex);
            }
        } else {
            object = new SerializationProperties(new Properties());
        }
        object5 = ((SerializationProperties)object).getProperties();
        if (((Properties)object5).getProperty("method") == null) {
            ((Properties)object5).setProperty("method", "xml");
        }
        if (((Properties)object5).getProperty("omit-xml-declaration") == null) {
            ((Properties)object5).setProperty("omit-xml-declaration", "true");
        }
        try {
            object4 = new StringWriter();
            object3 = xPathContext.getConfiguration().getSerializerFactory();
            object2 = xPathContext.getConfiguration().makePipelineConfiguration();
            object = ((SerializerFactory)object3).getReceiver((Result)new StreamResult((Writer)object4), (SerializationProperties)object, (PipelineConfiguration)object2);
            SequenceCopier.copySequence(sequenceIterator, (Receiver)object);
            return new StringValue(((StringWriter)object4).toString());
        }
        catch (XPathException xPathException) {
            object4 = xPathException;
            xPathException.maybeSetErrorCode("SENR0001");
            throw object4;
        }
    }

    static {
        c.put("allow-duplicate-names", SequenceType.SINGLE_BOOLEAN);
        c.put("byte-order-mark", SequenceType.SINGLE_BOOLEAN);
        c.put("cdata-section-elements", BuiltInAtomicType.QNAME.zeroOrMore());
        c.put("doctype-public", SequenceType.SINGLE_STRING);
        c.put("doctype-system", SequenceType.SINGLE_STRING);
        c.put("encoding", SequenceType.SINGLE_STRING);
        c.put("escape-uri-attributes", SequenceType.SINGLE_BOOLEAN);
        c.put("html-version", SequenceType.SINGLE_DECIMAL);
        c.put("include-content-type", SequenceType.SINGLE_BOOLEAN);
        c.put("indent", SequenceType.SINGLE_BOOLEAN);
        c.put("item-separator", SequenceType.SINGLE_STRING);
        c.put("json-node-output-method", SequenceType.SINGLE_STRING);
        c.put("media-type", SequenceType.SINGLE_STRING);
        c.put("method", SequenceType.SINGLE_STRING);
        c.put("normalization-form", SequenceType.SINGLE_STRING);
        c.put("omit-xml-declaration", SequenceType.SINGLE_BOOLEAN);
        c.put("standalone", SequenceType.OPTIONAL_BOOLEAN);
        c.put("suppress-indentation", BuiltInAtomicType.QNAME.zeroOrMore());
        c.put("undeclare-prefixes", SequenceType.SINGLE_BOOLEAN);
        c.put("use-character-maps", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        c.put("version", SequenceType.SINGLE_STRING);
        d = new HashMap<String, SequenceType>(20);
        d.put("attribute-order", BuiltInAtomicType.QNAME.zeroOrMore());
        d.put("character-representation", SequenceType.SINGLE_STRING);
        d.put("double-space", BuiltInAtomicType.QNAME.zeroOrMore());
        d.put("indent-spaces", SequenceType.SINGLE_INTEGER);
        d.put("line-length", SequenceType.SINGLE_INTEGER);
        d.put("recognize-binary", SequenceType.SINGLE_BOOLEAN);
        d.put("require-well-formed", SequenceType.SINGLE_BOOLEAN);
        d.put("single-quotes", SequenceType.SINGLE_BOOLEAN);
        d.put("supply-source-locator", SequenceType.SINGLE_BOOLEAN);
        d.put("suppress-indentation", BuiltInAtomicType.QNAME.zeroOrMore());
    }
}

