/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.BuilderMonitor;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.wrapper.SnapshotNode;
import net.sf.saxon.tree.wrapper.VirtualCopy;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;

public class SnapshotFn
extends SystemFunction {
    @Override
    public int getCardinality(Expression[] expressionArray) {
        return expressionArray[0].getCardinality();
    }

    @Override
    public Sequence<?> call(XPathContext object, Sequence[] object2) {
        object2 = ((Sequence[])object2).length == 0 ? object.getContextItem() : object2[0];
        object = SnapshotFn.snapshotSequence(object2.iterate(), (XPathContext)object);
        return new LazySequence(object);
    }

    public static SequenceIterator<?> snapshotSequence(SequenceIterator<?> sequenceIterator, XPathContext xPathContext) {
        return new ItemMappingIterator(sequenceIterator, SnapshotFn.getMappingFunction());
    }

    public static ItemMappingFunction<Item<?>, Item<?>> getMappingFunction() {
        return SnapshotFn::snapshotSingle;
    }

    public static Item snapshotSingle(Item item) {
        if (item instanceof NodeInfo) {
            if (((NodeInfo)item).getParent() == null) {
                item = VirtualCopy.makeVirtualCopy((NodeInfo)item);
                ((VirtualCopy)item).getTreeInfo().setCopyAccumulators(true);
                return item;
            }
            return SnapshotNode.makeSnapshot((NodeInfo)item);
        }
        return item;
    }

    public static List<NodeInfo> makeAncestorList(NodeInfo nodeInfo) {
        ArrayList<NodeInfo> arrayList = new ArrayList<NodeInfo>(20);
        nodeInfo.iterateAxis((byte)0).forEach(arrayList::add);
        return arrayList;
    }

    public static BuilderMonitor openAncestors(NodeInfo source, List<NodeInfo> list, XPathContext xPathContext) {
        Object object;
        source = source.getRoot();
        TinyBuilder tinyBuilder = new TinyBuilder(xPathContext.getController().makePipelineConfiguration());
        tinyBuilder.setStatistics(xPathContext.getConfiguration().getTreeStatistics().TEMPORARY_TREE_STATISTICS);
        tinyBuilder.setSystemId(source.getSystemId());
        tinyBuilder.setTiming(false);
        BuilderMonitor builderMonitor = ((Builder)tinyBuilder).getBuilderMonitor();
        ((SequenceReceiver)builderMonitor).open();
        source = source.getTreeInfo();
        Object object2 = source.getUnparsedEntityNames();
        while (object2.hasNext()) {
            object = object2.next();
            String[] stringArray = source.getUnparsedEntity((String)object);
            tinyBuilder.setUnparsedEntity((String)object, stringArray[0], stringArray[1]);
        }
        object = xPathContext.getController().getExecutable().isSchemaAware() ? AnyType.getInstance() : Untyped.getInstance();
        block5: for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            source = list.get(i2);
            int n2 = source.getNodeKind();
            switch (n2) {
                case 1: {
                    builderMonitor.startElement(NameOfNode.makeName((NodeInfo)source), (SchemaType)object, ExplicitLocation.UNKNOWN_LOCATION, 0);
                    NamespaceBinding[] namespaceBindingArray = source.getDeclaredNamespaces(null);
                    int n3 = 0;
                    while (n3 < namespaceBindingArray.length && (object2 = namespaceBindingArray[n3++]) != null) {
                        builderMonitor.namespace((NamespaceBindingSet)object2, 0);
                    }
                    source.iterateAxis((byte)2).forEachOrFail(nodeInfo -> nodeInfo.copy(builderMonitor, 0, ExplicitLocation.UNKNOWN_LOCATION));
                    builderMonitor.startContent();
                    continue block5;
                }
                case 9: {
                    builderMonitor.startDocument(0);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Unknown ancestor node kind " + source.getNodeKind());
                }
            }
        }
        return builderMonitor;
    }

    public static void closeAncestors(List<NodeInfo> object, Receiver receiver) {
        object = object.iterator();
        block4: while (object.hasNext()) {
            NodeInfo nodeInfo = (NodeInfo)object.next();
            switch (nodeInfo.getNodeKind()) {
                case 1: {
                    receiver.endElement();
                    continue block4;
                }
                case 9: {
                    receiver.endDocument();
                    continue block4;
                }
            }
            throw new IllegalStateException("Unknown ancestor node kind " + nodeInfo.getNodeKind());
        }
        receiver.close();
    }

    @Override
    public String getStreamerName() {
        return "SnapshotFn";
    }
}

