/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class StartsWith
extends CollatingFunctionFixed {
    @Override
    public boolean isSubstringMatchingFunction() {
        return true;
    }

    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo, Expression ... expressionArray) {
        if (this.getStringCollator() == CodepointCollator.getInstance()) {
            StartsWith startsWith = this;
            return new SystemFunctionCall.Optimized(startsWith, startsWith, expressionArray){
                private /* synthetic */ StartsWith a;
                {
                    this.a = startsWith;
                    super(startsWith2, expressionArray);
                }

                @Override
                public final boolean effectiveBooleanValue(XPathContext object) {
                    String string = this.getArg(0).evaluateAsString((XPathContext)object).toString();
                    object = this.getArg(1).evaluateAsString((XPathContext)object).toString();
                    return string.startsWith((String)object);
                }
            };
        }
        return super.makeOptimizedFunctionCall(expressionVisitor, contextItemStaticInfo, expressionArray);
    }

    public static boolean startsWith(StringValue object, StringValue object2, SubstringMatcher substringMatcher) {
        if (object2 == null || ((StringValue)object2).isZeroLength() || substringMatcher.comparesEqual(((StringValue)object2).getPrimitiveStringValue(), "")) {
            return true;
        }
        if (object == null || ((StringValue)object).isZeroLength()) {
            return false;
        }
        object = ((AtomicValue)object).getStringValue();
        object2 = ((AtomicValue)object2).getStringValue();
        return substringMatcher.startsWith((String)object, (String)object2);
    }

    public BooleanValue call(XPathContext object, Sequence[] object2) {
        object = (StringValue)object2[0].head();
        object2 = (StringValue)object2[1].head();
        return BooleanValue.get(StartsWith.startsWith((StringValue)object, (StringValue)object2, (SubstringMatcher)this.getStringCollator()));
    }

    @Override
    public String getCompilerName() {
        return "StartsWithCompiler";
    }
}

