/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public abstract class StaticContextAccessor
extends SystemFunction {
    public abstract AtomicValue evaluate(RetainedStaticContext var1);

    public AtomicValue call(XPathContext xPathContext, Sequence[] sequenceArray) {
        StaticContextAccessor staticContextAccessor = this;
        return staticContextAccessor.evaluate(staticContextAccessor.getRetainedStaticContext());
    }

    @Override
    public Expression makeFunctionCall(Expression[] expressionArray) {
        StaticContextAccessor staticContextAccessor = this;
        return Literal.makeLiteral(staticContextAccessor.evaluate(staticContextAccessor.getRetainedStaticContext()));
    }

    public static class DefaultCollation
    extends StaticContextAccessor {
        @Override
        public AtomicValue evaluate(RetainedStaticContext retainedStaticContext) {
            return new StringValue(retainedStaticContext.getDefaultCollationName());
        }
    }

    public static class StaticBaseUri
    extends StaticContextAccessor {
        @Override
        public AtomicValue evaluate(RetainedStaticContext retainedStaticContext) {
            return new AnyURIValue(retainedStaticContext.getStaticBaseUriString());
        }
    }
}

