/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.Fold;
import net.sf.saxon.functions.FoldingFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.One;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.Cardinality;

public class StringJoin
extends FoldingFunction {
    private boolean a;

    public void setReturnEmptyIfEmpty(boolean bl2) {
        this.a = bl2;
    }

    public boolean isReturnEmptyIfEmpty() {
        return this.a;
    }

    @Override
    public int getCardinality(Expression[] expressionArray) {
        if (this.a) {
            return 24576;
        }
        return 16384;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof StringJoin && super.equals(object) && this.a == ((StringJoin)object).a;
    }

    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo, Expression ... expressionArray) {
        if ((object = super.makeOptimizedFunctionCall((ExpressionVisitor)object, contextItemStaticInfo, expressionArray)) != null) {
            return object;
        }
        int n2 = expressionArray[0].getCardinality();
        if (!Cardinality.allowsMany(n2)) {
            if (Cardinality.allowsZero(n2) || expressionArray[0].getItemType().getPrimitiveItemType() != BuiltInAtomicType.STRING) {
                return SystemFunction.makeCall("string", this.getRetainedStaticContext(), expressionArray[0]);
            }
            return expressionArray[0];
        }
        return null;
    }

    @Override
    public Fold getFold(XPathContext object, Sequence ... sequenceArray) {
        object = "";
        if (sequenceArray.length > 0) {
            object = sequenceArray[0].head().getStringValueCS();
        }
        return new a(this, (CharSequence)object);
    }

    @Override
    public String getCompilerName() {
        return "StringJoinCompiler";
    }

    private final class a
    implements Fold {
        private int a = 0;
        private CharSequence b;
        private FastStringBuffer c;
        private /* synthetic */ StringJoin d;

        public a(StringJoin stringJoin, CharSequence charSequence) {
            this.d = stringJoin;
            this.b = charSequence;
            this.c = new FastStringBuffer(64);
        }

        @Override
        public final void processItem(Item<?> item) {
            if (this.a == 0) {
                this.c.append(item.getStringValueCS());
                this.a = 1;
                return;
            }
            this.c.append(this.b);
            this.c.append(item.getStringValueCS());
        }

        @Override
        public final boolean isFinished() {
            return false;
        }

        public final /* synthetic */ Sequence result() {
            a a2 = this;
            if (a2.a == 0 && a2.d.a) {
                return ZeroOrOne.empty();
            }
            return One.string(a2.c.toString());
        }
    }
}

