/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;

public class Subsequence_2
extends SystemFunction
implements Callable {
    @Override
    public int getSpecialProperties(Expression[] expressionArray) {
        return expressionArray[0].getSpecialProperties();
    }

    @Override
    public int getCardinality(Expression[] expressionArray) {
        return expressionArray[0].getCardinality() | 0x6000;
    }

    @Override
    public Sequence<?> call(XPathContext xPathContext, Sequence[] sequenceArray) {
        return SequenceTool.toLazySequence(Subsequence_2.subSequence(sequenceArray[0].iterate(), (NumericValue)sequenceArray[1].head()));
    }

    public static SequenceIterator<?> subSequence(SequenceIterator<?> sequenceIterator, NumericValue numericValue) {
        long l2;
        if (numericValue instanceof Int64Value) {
            l2 = numericValue.longValue();
            if (l2 <= 1L) {
                return sequenceIterator;
            }
        } else {
            if (numericValue.isNaN()) {
                return EmptyIterator.emptyIterator();
            }
            if ((numericValue = numericValue.round(0)).compareTo(Int64Value.PLUS_ONE) <= 0) {
                return sequenceIterator;
            }
            if (numericValue.compareTo(Int64Value.MAX_LONG) > 0) {
                return EmptyIterator.emptyIterator();
            }
            l2 = numericValue.longValue();
        }
        if (l2 > Integer.MAX_VALUE) {
            return EmptyIterator.emptyIterator();
        }
        return TailIterator.make(sequenceIterator, (int)l2);
    }

    @Override
    public Expression makeFunctionCall(Expression[] expressionArray) {
        try {
            if (Literal.isAtomic(expressionArray[1]) && !(expressionArray[0] instanceof ErrorExpression)) {
                NumericValue numericValue = (NumericValue)((Literal)expressionArray[1]).getValue();
                long l2 = (numericValue = numericValue.round(0)).longValue();
                if (l2 > Integer.MAX_VALUE) {
                    return super.makeFunctionCall(expressionArray);
                }
                if (l2 <= 0L) {
                    return expressionArray[0];
                }
                return new TailExpression(expressionArray[0], (int)l2);
            }
        }
        catch (Exception exception) {}
        return super.makeFunctionCall(expressionArray);
    }

    @Override
    public String getStreamerName() {
        return "Subsequence";
    }
}

