/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SubsequenceIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;

public class Subsequence_3
extends SystemFunction
implements Callable {
    @Override
    public int getSpecialProperties(Expression[] expressionArray) {
        return expressionArray[0].getSpecialProperties();
    }

    @Override
    public Sequence<?> call(XPathContext xPathContext, Sequence[] sequenceArray) {
        return SequenceTool.toLazySequence(Subsequence_3.subSequence(sequenceArray[0].iterate(), (NumericValue)sequenceArray[1].head(), (NumericValue)sequenceArray[2].head(), xPathContext));
    }

    public static SequenceIterator<?> subSequence(SequenceIterator sequenceIterator, NumericValue numericValue, NumericValue numericValue2, XPathContext xPathContext) {
        if (numericValue instanceof Int64Value && numericValue2 instanceof Int64Value) {
            long l2 = numericValue.longValue();
            if (l2 > Integer.MAX_VALUE) {
                return EmptyIterator.emptyIterator();
            }
            long l3 = numericValue2.longValue();
            if (l3 > Integer.MAX_VALUE) {
                l3 = Integer.MAX_VALUE;
            }
            if (l3 < 1L) {
                return EmptyIterator.emptyIterator();
            }
            long l4 = l2 + l3 - 1L;
            if (l4 < 1L) {
                return EmptyIterator.emptyIterator();
            }
            int n2 = l2 < 1L ? 1 : (int)l2;
            return SubsequenceIterator.make(sequenceIterator, n2, (int)l4);
        }
        if (numericValue.isNaN()) {
            return EmptyIterator.emptyIterator();
        }
        if (numericValue.compareTo(Int64Value.MAX_LONG) > 0) {
            return EmptyIterator.emptyIterator();
        }
        numericValue = numericValue.round(0);
        if (numericValue2.isNaN()) {
            return EmptyIterator.emptyIterator();
        }
        if ((numericValue2 = numericValue2.round(0)).compareTo(Int64Value.ZERO) <= 0) {
            return EmptyIterator.emptyIterator();
        }
        NumericValue numericValue3 = (NumericValue)ArithmeticExpression.compute(numericValue, 0, numericValue2, xPathContext);
        if (numericValue3.isNaN()) {
            return EmptyIterator.emptyIterator();
        }
        if ((numericValue3 = (NumericValue)ArithmeticExpression.compute(numericValue3, 1, Int64Value.PLUS_ONE, xPathContext)).compareTo(Int64Value.ZERO) <= 0) {
            return EmptyIterator.emptyIterator();
        }
        long l5 = numericValue.compareTo(Int64Value.PLUS_ONE) <= 0 ? 1L : numericValue.longValue();
        if (l5 > Integer.MAX_VALUE) {
            return EmptyIterator.emptyIterator();
        }
        long l6 = numericValue3.compareTo(Int64Value.MAX_LONG) >= 0 ? Integer.MAX_VALUE : numericValue3.longValue();
        return SubsequenceIterator.make(sequenceIterator, (int)l5, (int)l6);
    }

    @Override
    public String getStreamerName() {
        return "Subsequence";
    }
}

