/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.StaticFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.Number_1;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.One;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.regex.EmptyString;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class Substring
extends SystemFunction
implements Callable {
    @Override
    public Expression typeCheckCaller(FunctionCall functionCall, ExpressionVisitor object, ContextItemStaticInfo object2) {
        if ((object2 = super.typeCheckCaller(functionCall, (ExpressionVisitor)object, (ContextItemStaticInfo)object2)) != functionCall) {
            return object2;
        }
        object = ((ExpressionVisitor)object).getConfiguration().getTypeHierarchy();
        if (functionCall.getArg(1).isCallOn(Number_1.class) && ((TypeHierarchy)object).isSubType(((Expression)(object2 = ((StaticFunctionCall)functionCall.getArg(1)).getArg(0))).getItemType(), BuiltInAtomicType.INTEGER)) {
            functionCall.setArg(1, (Expression)object2);
        }
        if (this.getArity() > 2 && functionCall.getArg(2).isCallOn(Number_1.class) && ((TypeHierarchy)object).isSubType(((Expression)(object2 = ((StaticFunctionCall)functionCall.getArg(2)).getArg(0))).getItemType(), BuiltInAtomicType.INTEGER)) {
            functionCall.setArg(2, (Expression)object2);
        }
        return functionCall;
    }

    public static UnicodeString substring(StringValue object, NumericValue numericValue) {
        long l2;
        object = ((StringValue)object).getUnicodeString();
        int n2 = ((UnicodeString)object).uLength();
        if (numericValue instanceof Int64Value) {
            l2 = ((NumericValue)((Int64Value)numericValue)).longValue();
            if (l2 > (long)n2) {
                return EmptyString.THE_INSTANCE;
            }
            if (l2 <= 0L) {
                l2 = 1L;
            }
        } else {
            if (numericValue.isNaN()) {
                return EmptyString.THE_INSTANCE;
            }
            if (numericValue.signum() <= 0) {
                return object;
            }
            if (numericValue.compareTo(n2) > 0) {
                return EmptyString.THE_INSTANCE;
            }
            l2 = Math.round(numericValue.getDoubleValue());
        }
        if (l2 > (long)((UnicodeString)object).uLength()) {
            return EmptyString.THE_INSTANCE;
        }
        return ((UnicodeString)object).uSubstring((int)l2 - 1, ((UnicodeString)object).uLength());
    }

    public static UnicodeString substring(StringValue object, NumericValue numericValue, NumericValue numericValue2) {
        long l2;
        long l3;
        long l4;
        int n2 = ((StringValue)object).getStringLengthUpperBound();
        if (numericValue instanceof Int64Value) {
            l4 = ((NumericValue)((Int64Value)numericValue)).longValue();
            if (l4 > (long)n2) {
                return EmptyString.THE_INSTANCE;
            }
        } else {
            if (numericValue.isNaN()) {
                return EmptyString.THE_INSTANCE;
            }
            if (numericValue.compareTo(n2) > 0) {
                return EmptyString.THE_INSTANCE;
            }
            double d2 = numericValue.getDoubleValue();
            long l5 = l4 = Double.isInfinite(d2) ? -2147483647L : Math.round(d2);
        }
        if (numericValue2 instanceof Int64Value) {
            l3 = ((NumericValue)((Int64Value)numericValue2)).longValue();
            if (l3 <= 0L) {
                return EmptyString.THE_INSTANCE;
            }
        } else {
            if (numericValue2.isNaN()) {
                return EmptyString.THE_INSTANCE;
            }
            if (numericValue2.signum() <= 0) {
                return EmptyString.THE_INSTANCE;
            }
            double d3 = numericValue2.getDoubleValue();
            l3 = Double.isInfinite(d3) ? Integer.MAX_VALUE : Math.round(numericValue2.getDoubleValue());
        }
        if ((l2 = l4 + l3) < l4) {
            return EmptyString.THE_INSTANCE;
        }
        int n3 = (int)l4 - 1;
        int n4 = ((UnicodeString)(object = ((StringValue)object).getUnicodeString())).uLength();
        if (n3 >= n4) {
            return EmptyString.THE_INSTANCE;
        }
        n4 = Math.min(n4, (int)l2 - 1);
        if (n3 < 0) {
            if (n4 < 0) {
                return EmptyString.THE_INSTANCE;
            }
            n3 = 0;
        }
        return ((UnicodeString)object).uSubstring(n3, n4);
    }

    public ZeroOrOne<StringValue> call(XPathContext object, Sequence[] object2) {
        object = (StringValue)object2[0].head();
        if (object == null) {
            return One.string("");
        }
        NumericValue numericValue = (NumericValue)object2[1].head();
        if (((Sequence[])object2).length == 2) {
            return new ZeroOrOne<StringValue>(StringValue.makeStringValue(Substring.substring((StringValue)object, numericValue)));
        }
        object2 = (NumericValue)object2[2].head();
        return new ZeroOrOne<StringValue>(StringValue.makeStringValue(Substring.substring((StringValue)object, numericValue, (NumericValue)object2)));
    }

    @Override
    public String getCompilerName() {
        return "SubstringCompiler";
    }
}

