/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.functions.Fold;
import net.sf.saxon.functions.FoldingFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.YearMonthDurationValue;

public class Sum
extends FoldingFunction {
    @Override
    public ItemType getResultItemType(Expression[] expressionArray) {
        TypeHierarchy typeHierarchy = this.getRetainedStaticContext().getConfiguration().getTypeHierarchy();
        ItemType itemType = Atomizer.getAtomizedItemType(expressionArray[0], false, typeHierarchy);
        if (itemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            itemType = BuiltInAtomicType.DOUBLE;
        }
        if (Cardinality.allowsZero(expressionArray[0].getCardinality())) {
            if (this.getArity() == 1) {
                return Type.getCommonSuperType(itemType, BuiltInAtomicType.INTEGER, typeHierarchy);
            }
            return Type.getCommonSuperType(itemType, expressionArray[1].getItemType(), typeHierarchy);
        }
        return itemType.getPrimitiveItemType();
    }

    @Override
    public int getCardinality(Expression[] expressionArray) {
        if (this.getArity() == 1 || expressionArray[1].getCardinality() == 1) {
            return 16384;
        }
        return 24576;
    }

    @Override
    public Fold getFold(XPathContext xPathContext, Sequence ... object) {
        if (((Sequence[])object).length > 0) {
            object = (AtomicValue)object[0].head();
            return new a(xPathContext, (AtomicValue)object);
        }
        return new a(xPathContext, Int64Value.ZERO);
    }

    public static AtomicValue total(SequenceIterator<?> sequenceIterator, XPathContext object, Location location) {
        try {
            object = new a((XPathContext)object, null);
            sequenceIterator.forEachOrFail(((a)object)::processItem);
            return (AtomicValue)((a)object).result().head();
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.maybeSetLocation(location);
            throw object;
        }
    }

    @Override
    public String getCompilerName() {
        return "SumCompiler";
    }

    private static final class a
    implements Fold {
        private XPathContext a;
        private AtomicValue b;
        private AtomicValue c;
        private boolean d = true;
        private ConversionRules e;
        private StringConverter f;

        public a(XPathContext xPathContext, AtomicValue atomicValue) {
            this.a = xPathContext;
            this.b = atomicValue;
            this.e = xPathContext.getConfiguration().getConversionRules();
            this.f = BuiltInAtomicType.DOUBLE.getStringConverter(this.e);
        }

        @Override
        public final void processItem(Item<?> object) {
            object = (AtomicValue)object;
            if (this.d) {
                this.d = false;
                if (object instanceof UntypedAtomicValue) {
                    this.c = ((Converter)this.f).convert((AtomicValue)object).asAtomic();
                    return;
                }
                if (object instanceof NumericValue || object instanceof DayTimeDurationValue || object instanceof YearMonthDurationValue) {
                    this.c = object;
                    return;
                }
                object = new XPathException("Input to sum() contains a value of type " + ((AtomicValue)object).getPrimitiveType().getDisplayName() + " which is neither numeric, nor a duration");
                ((XPathException)object).setXPathContext(this.a);
                ((XPathException)object).setErrorCode("FORG0006");
                throw object;
            }
            if (this.c instanceof NumericValue) {
                if (object instanceof UntypedAtomicValue) {
                    object = ((Converter)this.f).convert((AtomicValue)object).asAtomic();
                } else if (!(object instanceof NumericValue)) {
                    object = new XPathException("Input to sum() contains a mix of numeric and non-numeric values");
                    ((XPathException)object).setXPathContext(this.a);
                    ((XPathException)object).setErrorCode("FORG0006");
                    throw object;
                }
                this.c = ArithmeticExpression.compute(this.c, 0, (AtomicValue)object, this.a);
                return;
            }
            if (this.c instanceof DurationValue) {
                if (!(this.c instanceof DayTimeDurationValue) && !(this.c instanceof YearMonthDurationValue)) {
                    object = new XPathException("Input to sum() contains a duration that is neither a dayTimeDuration nor a yearMonthDuration");
                    ((XPathException)object).setXPathContext(this.a);
                    ((XPathException)object).setErrorCode("FORG0006");
                    throw object;
                }
                if (!(object instanceof DurationValue)) {
                    object = new XPathException("Input to sum() contains a mix of duration and non-duration values");
                    ((XPathException)object).setXPathContext(this.a);
                    ((XPathException)object).setErrorCode("FORG0006");
                    throw object;
                }
                this.c = ((DurationValue)this.c).add((DurationValue)object);
                return;
            }
            object = new XPathException("Input to sum() contains a value of type " + this.c.getPrimitiveType().getDisplayName() + " which is neither numeric, nor a duration");
            ((XPathException)object).setXPathContext(this.a);
            ((XPathException)object).setErrorCode("FORG0006");
            throw object;
        }

        @Override
        public final boolean isFinished() {
            return this.c instanceof DoubleValue && this.c.isNaN();
        }

        @Override
        public final Sequence<?> result() {
            if (this.d) {
                if (this.b == null) {
                    return EmptySequence.getInstance();
                }
                return this.b;
            }
            return this.c;
        }
    }
}

