/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Properties;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.AbstractFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public abstract class SystemFunction
extends AbstractFunction {
    private int a;
    private BuiltInFunctionSet.Entry b;
    private RetainedStaticContext c;

    public static Expression makeCall(String object, RetainedStaticContext retainedStaticContext, Expression ... expressionArray) {
        if ((object = SystemFunction.makeFunction((String)object, retainedStaticContext, expressionArray.length)) == null) {
            return null;
        }
        object = ((SystemFunction)object).makeFunctionCall(expressionArray);
        ((Expression)object).setRetainedStaticContext(retainedStaticContext);
        return object;
    }

    public static SystemFunction makeFunction(String string, RetainedStaticContext retainedStaticContext, int n2) {
        if (retainedStaticContext == null) {
            throw new NullPointerException();
        }
        SystemFunction systemFunction = retainedStaticContext.getConfiguration().makeSystemFunction(string, n2);
        if (systemFunction == null) {
            retainedStaticContext.getConfiguration().makeSystemFunction(string, n2);
            throw new IllegalStateException(string);
        }
        systemFunction.setRetainedStaticContext(retainedStaticContext);
        return systemFunction;
    }

    public Expression makeFunctionCall(Expression ... object) {
        object = new SystemFunctionCall(this, (Expression[])object);
        object.setRetainedStaticContext(this.getRetainedStaticContext());
        return object;
    }

    public void setArity(int n2) {
        this.a = n2;
    }

    public int getNetCost() {
        return 1;
    }

    public Expression makeOptimizedFunctionCall(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo, Expression ... expressionArray) {
        return this.fixArguments(expressionArray);
    }

    public Expression fixArguments(Expression ... expressionArray) {
        for (int i2 = 0; i2 < this.getArity(); ++i2) {
            if (!Literal.isEmptySequence(expressionArray[i2]) || this.resultIfEmpty(i2) == null) continue;
            return Literal.makeLiteral(this.b.resultIfEmpty[i2].materialize());
        }
        return null;
    }

    protected Sequence<?> resultIfEmpty(int n2) {
        return this.b.resultIfEmpty[n2];
    }

    public RetainedStaticContext getRetainedStaticContext() {
        return this.c;
    }

    public void setRetainedStaticContext(RetainedStaticContext retainedStaticContext) {
        this.c = retainedStaticContext;
    }

    public boolean dependsOnContextItem() {
        return (this.b.properties & 0x4004) != 0;
    }

    public void setDetails(BuiltInFunctionSet.Entry entry) {
        this.b = entry;
    }

    public BuiltInFunctionSet.Entry getDetails() {
        return this.b;
    }

    @Override
    public StructuredQName getFunctionName() {
        return this.b.name;
    }

    @Override
    public String getDescription() {
        return this.b.name.getDisplayName();
    }

    @Override
    public int getArity() {
        return this.a;
    }

    @Override
    public OperandRole[] getOperandRoles() {
        OperandRole[] operandRoleArray = new OperandRole[this.getArity()];
        OperandUsage[] operandUsageArray = this.b.usage;
        try {
            for (int i2 = 0; i2 < this.getArity(); ++i2) {
                operandRoleArray[i2] = new OperandRole(0, operandUsageArray[i2], this.getRequiredType(i2));
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2 = arrayIndexOutOfBoundsException;
            arrayIndexOutOfBoundsException.printStackTrace();
        }
        return operandRoleArray;
    }

    public IntegerValue[] getIntegerBounds() {
        return null;
    }

    public void supplyTypeInformation(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo, Expression[] expressionArray) {
    }

    public boolean equals(Object object) {
        return object instanceof SystemFunction && super.equals(object);
    }

    public String getErrorCodeForTypeErrors() {
        return "XPTY0004";
    }

    public SequenceType getRequiredType(int n2) {
        if (this.b == null) {
            return SequenceType.ANY_SEQUENCE;
        }
        return this.b.argumentTypes[n2];
    }

    public ItemType getResultItemType() {
        return this.b.itemType;
    }

    @Override
    public FunctionItemType getFunctionItemType() {
        SequenceType sequenceType = SequenceType.makeSequenceType(this.getResultItemType(), this.b.cardinality);
        return new SpecificFunctionType(this.b.argumentTypes, sequenceType);
    }

    public ItemType getResultItemType(Expression[] expressionArray) {
        if ((this.b.properties & 1) != 0) {
            return expressionArray[0].getItemType();
        }
        if ((this.b.properties & 2) != 0) {
            return expressionArray[0].getItemType().getPrimitiveItemType();
        }
        return this.b.itemType;
    }

    public int getCardinality(Expression[] expressionArray) {
        int n2 = this.b.cardinality;
        if (n2 == 24576 && (this.b.properties & 0x8000) != 0 && !Cardinality.allowsZero(expressionArray[0].getCardinality())) {
            return 16384;
        }
        return n2;
    }

    public int getSpecialProperties(Expression[] expressionArray) {
        if ((this.b.properties & 0x10000) != 0) {
            return 0x400000;
        }
        int n2 = 0x800000;
        if ((this.b.properties & 0x2000) != 0) {
            n2 = 0x2800000;
        }
        return n2;
    }

    protected NodeInfo getContextNode(XPathContext xPathContext) {
        Item<?> item = xPathContext.getContextItem();
        if (item == null) {
            item = new XPathException("Context item for " + this.getFunctionName() + "() is absent", "XPDY0002");
            ((XPathException)((Object)item)).maybeSetContext(xPathContext);
            throw item;
        }
        if (!(item instanceof NodeInfo)) {
            item = new XPathException("Context item for " + this.getFunctionName() + "() is not a node", "XPTY0004");
            ((XPathException)((Object)item)).maybeSetContext(xPathContext);
            throw item;
        }
        return (NodeInfo)item;
    }

    public static Sequence<?> dynamicCall(Function function, XPathContext xPathContext, Sequence[] sequenceArray) {
        xPathContext = function.makeNewContext(xPathContext, null);
        return function.call(xPathContext, sequenceArray);
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("fnRef");
        Object object = this.getFunctionName();
        object = ((StructuredQName)object).hasURI("http://www.w3.org/2005/xpath-functions") ? ((StructuredQName)object).getLocalPart() : ((StructuredQName)object).getEQName();
        expressionPresenter.emitAttribute("name", (String)object);
        expressionPresenter.emitAttribute("arity", "" + this.getArity());
        if ((this.getDetails().properties & 0x38) != 0) {
            expressionPresenter.emitRetainedStaticContext(this.getRetainedStaticContext(), null);
        }
        expressionPresenter.endElement();
    }

    public Expression typeCheckCaller(FunctionCall functionCall, ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        return functionCall;
    }

    @Override
    public boolean isTrustedResultType() {
        return true;
    }

    public String getStaticBaseUriString() {
        return this.getRetainedStaticContext().getStaticBaseUriString();
    }

    public void exportAttributes(ExpressionPresenter expressionPresenter) {
    }

    public void exportAdditionalArguments(SystemFunctionCall systemFunctionCall, ExpressionPresenter expressionPresenter) {
    }

    public void importAttributes(Properties properties) {
    }

    public String getCompilerName() {
        return null;
    }

    public String getStreamerName() {
        return null;
    }

    @Override
    public String toShortString() {
        return this.getFunctionName().getDisplayName() + '#' + this.getArity();
    }

    public String toString() {
        return this.getFunctionName().getDisplayName() + '#' + this.getArity();
    }
}

