/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class SystemProperty
extends SystemFunction
implements Callable {
    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor object, ContextItemStaticInfo object2, Expression ... expressionArray) {
        if (expressionArray[0] instanceof Literal) {
            try {
                object = (StringValue)((Literal)expressionArray[0]).getValue();
                object = StructuredQName.fromLexicalQName(((AtomicValue)object).getStringValue(), false, true, this.getRetainedStaticContext());
                object2 = ((StructuredQName)object).getURI();
                object = ((StructuredQName)object).getLocalPart();
                if (((String)object2).equals("http://www.w3.org/1999/XSL/Transform") && (((String)object).equals("version") || ((String)object).equals("vendor") || ((String)object).equals("vendor-url") || ((String)object).equals("product-name") || ((String)object).equals("product-version") || ((String)object).equals("supports-backwards-compatibility") || ((String)object).equals("xpath-version") || ((String)object).equals("xsd-version"))) {
                    object = SystemProperty.getProperty((String)object2, (String)object, this.getRetainedStaticContext());
                    return new StringLiteral((CharSequence)object);
                }
            }
            catch (XPathException xPathException) {}
        }
        return null;
    }

    public StringValue call(XPathContext xPathContext, Sequence[] object) {
        object = (StringValue)object[0].head();
        try {
            object = StructuredQName.fromLexicalQName(((AtomicValue)object).getStringValue(), false, true, this.getRetainedStaticContext());
            return new StringValue(SystemProperty.getProperty(((StructuredQName)object).getURI(), ((StructuredQName)object).getLocalPart(), this.getRetainedStaticContext()));
        }
        catch (XPathException xPathException) {
            throw new XPathException("Invalid system property name. " + xPathException.getMessage(), "XTDE1390", xPathContext);
        }
    }

    public static String yesOrNo(boolean bl2) {
        if (bl2) {
            return "yes";
        }
        return "no";
    }

    public static String getProperty(String string, String string2, RetainedStaticContext retainedStaticContext) {
        Configuration configuration = retainedStaticContext.getConfiguration();
        String string3 = retainedStaticContext.getPackageData().getTargetEdition();
        if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
            switch (string2) {
                case "version": {
                    return "3.0";
                }
                case "vendor": {
                    return Version.getProductVendor();
                }
                case "vendor-url": {
                    return Version.getWebSiteAddress();
                }
                case "product-name": {
                    return Version.getProductName();
                }
                case "product-version": {
                    return Version.getProductVariantAndVersion(string3);
                }
                case "is-schema-aware": {
                    boolean bl2 = retainedStaticContext.getPackageData().isSchemaAware();
                    return SystemProperty.yesOrNo(bl2);
                }
                case "supports-serialization": {
                    return SystemProperty.yesOrNo(!"JS".equals(string3));
                }
                case "supports-backwards-compatibility": {
                    return "yes";
                }
                case "supports-namespace-axis": {
                    return "yes";
                }
                case "supports-streaming": {
                    return SystemProperty.yesOrNo("EE".equals(string3) && configuration.isLicensedFeature(2) && !configuration.getConfigurationProperty(Feature.STREAMABILITY).equals("off"));
                }
                case "supports-dynamic-evaluation": {
                    return SystemProperty.yesOrNo(!"JS".equals(string3) && configuration.isLicensedFeature(8) && !configuration.getBooleanProperty(Feature.DISABLE_XSL_EVALUATE));
                }
                case "supports-higher-order-functions": {
                    return SystemProperty.yesOrNo(!"JS".equals(string3) && !"HE".equals(string3) && configuration.isLicensedFeature(8));
                }
                case "xpath-version": {
                    return "3.1";
                }
                case "xsd-version": {
                    if (retainedStaticContext.getConfiguration().getXsdVersion() == 10) {
                        return "1.0";
                    }
                    return "1.1";
                }
            }
            return "";
        }
        if (string.isEmpty() && configuration.getBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS)) {
            string = System.getProperty(string2);
            if (string == null) {
                return "";
            }
            return string;
        }
        return "";
    }
}

