/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.InstructionDetails;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;

public class Trace
extends SystemFunction {
    private Location a = ExplicitLocation.UNKNOWN_LOCATION;

    @Override
    public int getSpecialProperties(Expression[] expressionArray) {
        return expressionArray[0].getSpecialProperties();
    }

    @Override
    public int getCardinality(Expression[] expressionArray) {
        return expressionArray[0].getCardinality();
    }

    public void notifyListener(String object, Sequence<?> sequence, SourceLocator sourceLocator, XPathContext xPathContext) {
        InstructionDetails instructionDetails = new InstructionDetails();
        instructionDetails.setConstructType(2041);
        instructionDetails.setLineNumber(sourceLocator.getLineNumber());
        instructionDetails.setSystemId(sourceLocator.getSystemId());
        instructionDetails.setProperty("label", object);
        instructionDetails.setProperty("value", sequence);
        object = xPathContext.getController().getTraceListener();
        object.enter(instructionDetails, xPathContext);
        object.leave(instructionDetails);
    }

    @Override
    public Expression makeFunctionCall(Expression ... object) {
        object = super.makeFunctionCall((Expression[])object);
        this.a = ((Expression)object).getLocation();
        return object;
    }

    public static void traceItem(Item item, String string, Logger logger) {
        if (item == null) {
            logger.info(string);
            return;
        }
        if (item instanceof NodeInfo) {
            logger.info(string + ": " + Type.displayTypeName(item) + ": " + Navigator.getPath((NodeInfo)item));
            return;
        }
        if (item instanceof AtomicValue) {
            logger.info(string + ": " + Type.displayTypeName(item) + ": " + item.getStringValue());
            return;
        }
        if (item instanceof ArrayItem || item instanceof MapItem) {
            logger.info(string + ": " + item.toShortString());
            return;
        }
        if (item instanceof Function) {
            StructuredQName structuredQName = ((Function)item).getFunctionName();
            logger.info(string + ": function " + (structuredQName == null ? "(anon)" : structuredQName.getDisplayName()) + "#" + ((Function)item).getArity());
            return;
        }
        if (item instanceof ObjectValue) {
            Object t2 = ((ObjectValue)item).getObject();
            logger.info(string + ": " + t2.getClass().getName() + " = " + Err.truncate30(t2.toString()));
            return;
        }
        logger.info(string + ": " + item.toShortString());
    }

    @Override
    public Sequence<?> call(XPathContext xPathContext, Sequence[] sequenceArray) {
        String string;
        GroundedValue groundedValue = xPathContext.getController();
        String string2 = string = sequenceArray.length == 1 ? "*" : sequenceArray[1].head().getStringValue();
        if (((Controller)((Object)groundedValue)).isTracing()) {
            groundedValue = sequenceArray[0].iterate().materialize();
            this.notifyListener(string, groundedValue, this.a, xPathContext);
            return groundedValue;
        }
        if ((groundedValue = ((Controller)((Object)groundedValue)).getTraceFunctionDestination()) == null) {
            return sequenceArray[0];
        }
        return SequenceTool.toLazySequence(new a(this, sequenceArray[0].iterate(), string, (Logger)((Object)groundedValue)));
    }

    @Override
    public String getStreamerName() {
        return "Trace";
    }

    private final class a
    implements SequenceIterator {
        private SequenceIterator a;
        private String b;
        private Logger c;
        private boolean d = true;
        private int e = 0;
        private /* synthetic */ Trace f;

        public a(Trace trace, SequenceIterator sequenceIterator, String string, Logger logger) {
            this.f = trace;
            this.a = sequenceIterator;
            this.b = string;
            this.c = logger;
        }

        public final Item next() {
            Object t2 = this.a.next();
            ++this.e;
            if (t2 == null) {
                if (this.d) {
                    Trace.traceItem(null, this.b + ": empty sequence", this.c);
                }
            } else {
                Trace.traceItem(t2, this.b + " [" + this.e + ']', this.c);
                this.d = false;
            }
            return t2;
        }

        @Override
        public final void close() {
            this.a.close();
        }

        @Override
        public final int getProperties() {
            return 0;
        }
    }
}

