/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.OptionsParameter;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.Serialize;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.ResultDocumentResolver;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.s9api.AbstractDestination;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.RawDestination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltPackage;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.StylesheetCache;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.wrapper.RebasedDocument;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;
import org.xml.sax.InputSource;

public class TransformFn
extends SystemFunction
implements Callable {
    private static String[] a = new String[]{"package-name", "package-version", "package-node", "package-location", "static-params", "global-context-item", "template-params", "tunnel-params", "initial-function", "function-params"};

    public static OptionsParameter makeOptionsParameter() {
        OptionsParameter optionsParameter = new OptionsParameter();
        optionsParameter.addAllowedOption("xslt-version", SequenceType.SINGLE_DECIMAL);
        optionsParameter.addAllowedOption("stylesheet-location", SequenceType.SINGLE_STRING);
        optionsParameter.addAllowedOption("stylesheet-node", SequenceType.SINGLE_NODE);
        optionsParameter.addAllowedOption("stylesheet-text", SequenceType.SINGLE_STRING);
        optionsParameter.addAllowedOption("stylesheet-base-uri", SequenceType.SINGLE_STRING);
        optionsParameter.addAllowedOption("base-output-uri", SequenceType.SINGLE_STRING);
        optionsParameter.addAllowedOption("stylesheet-params", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        optionsParameter.addAllowedOption("source-node", SequenceType.SINGLE_NODE);
        optionsParameter.addAllowedOption("source-location", SequenceType.SINGLE_STRING);
        optionsParameter.addAllowedOption("initial-mode", SequenceType.SINGLE_QNAME);
        optionsParameter.addAllowedOption("initial-match-selection", SequenceType.ANY_SEQUENCE);
        optionsParameter.addAllowedOption("initial-template", SequenceType.SINGLE_QNAME);
        optionsParameter.addAllowedOption("delivery-format", SequenceType.SINGLE_STRING);
        optionsParameter.addAllowedOption("serialization-params", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        optionsParameter.addAllowedOption("vendor-options", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        optionsParameter.addAllowedOption("cache", SequenceType.SINGLE_BOOLEAN);
        optionsParameter.addAllowedOption("package-name", SequenceType.SINGLE_STRING);
        optionsParameter.addAllowedOption("package-version", SequenceType.SINGLE_STRING);
        optionsParameter.addAllowedOption("package-node", SequenceType.SINGLE_NODE);
        optionsParameter.addAllowedOption("package-location", SequenceType.SINGLE_STRING);
        optionsParameter.addAllowedOption("static-params", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        optionsParameter.addAllowedOption("global-context-item", SequenceType.SINGLE_ITEM);
        optionsParameter.addAllowedOption("template-params", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        optionsParameter.addAllowedOption("tunnel-params", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        optionsParameter.addAllowedOption("initial-function", SequenceType.SINGLE_QNAME);
        optionsParameter.addAllowedOption("function-params", ArrayItemType.SINGLE_ARRAY);
        optionsParameter.addAllowedOption("requested-properties", SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384));
        optionsParameter.addAllowedOption("post-process", SequenceType.makeSequenceType(new SpecificFunctionType(new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.ANY_SEQUENCE}, SequenceType.ANY_SEQUENCE), 16384));
        return optionsParameter;
    }

    private String a(Map<String, Sequence<?>> map, String ... stringArray) {
        String string = null;
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray2[i2];
            if (map.get(string2) == null) continue;
            if (string != null) {
                throw new XPathException("The following transform options are mutually exclusive: " + TransformFn.a(stringArray), "FOXT0002");
            }
            string = string2;
        }
        return string;
    }

    private static String a(String ... stringArray) {
        boolean bl2 = true;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
        for (String string : stringArray) {
            if (bl2) {
                bl2 = false;
            } else {
                fastStringBuffer.append(" | ");
            }
            fastStringBuffer.append(string);
        }
        return fastStringBuffer.toString();
    }

    private static void a(String string, String string2) {
        throw new XPathException("No XSLT processor is available with xsl:" + string + " = " + string2, "FOXT0001");
    }

    private static boolean a(AtomicValue atomicValue) {
        if (atomicValue instanceof BooleanValue) {
            return ((BooleanValue)atomicValue).getBooleanValue();
        }
        if (atomicValue instanceof StringValue) {
            String string = Whitespace.normalizeWhitespace(atomicValue.getStringValue()).toString();
            if (string.equals("yes") || string.equals("true") || string.equals("1")) {
                return true;
            }
            if (string.equals("no") || string.equals("false") || string.equals("0")) {
                return false;
            }
        }
        throw new XPathException("Unrecognized boolean value " + atomicValue, "FOXT0002");
    }

    private XsltExecutable a(Map<String, Sequence<?>> object, XsltCompiler xsltCompiler, String object2, XPathContext object3) {
        boolean bl2;
        Object object4;
        Object object5 = object.get(object2).head();
        URI uRI = null;
        Sequence<?> sequence = object.get("stylesheet-base-uri");
        if (sequence != null && !(uRI = URI.create(((AtomicValue)(sequence = (StringValue)sequence.head())).getStringValue())).isAbsolute()) {
            object4 = this.getRetainedStaticContext().getStaticBaseUri();
            uRI = ((URI)object4).resolve(((AtomicValue)sequence).getStringValue());
        }
        sequence = new ArrayList();
        object4 = xsltCompiler.getErrorListener();
        xsltCompiler.setErrorListener(new ErrorListener(this, (ErrorListener)object4, (List)((Object)sequence)){
            private /* synthetic */ ErrorListener a;
            private /* synthetic */ List b;
            private /* synthetic */ TransformFn c;
            {
                this.c = transformFn;
                this.a = errorListener;
                this.b = list;
            }

            @Override
            public final void warning(TransformerException transformerException) {
                this.a.warning(transformerException);
            }

            @Override
            public final void error(TransformerException transformerException) {
                this.b.add(transformerException);
                this.a.error(transformerException);
            }

            @Override
            public final void fatalError(TransformerException transformerException) {
                this.b.add(transformerException);
                this.a.fatalError(transformerException);
            }
        });
        boolean bl3 = bl2 = object.get("static-params") == null;
        if (object.get("cache") != null) {
            bl2 &= ((BooleanValue)object.get("cache").head()).getBooleanValue();
        }
        object3 = object3.getController().getStylesheetCache();
        XsltExecutable xsltExecutable = null;
        int n2 = -1;
        switch (((String)object2).hashCode()) {
            case -1999358892: {
                if (!((String)object2).equals("stylesheet-location")) break;
                n2 = 0;
                break;
            }
            case 188836385: {
                if (!((String)object2).equals("stylesheet-node")) break;
                n2 = 1;
                break;
            }
            case -1923328215: {
                if (!((String)object2).equals("package-node")) break;
                n2 = 2;
                break;
            }
            case 189006156: {
                if (!((String)object2).equals("stylesheet-text")) break;
                n2 = 3;
                break;
            }
            case -1923341390: {
                if (!((String)object2).equals("package-name")) break;
                n2 = 4;
            }
        }
        switch (n2) {
            case 0: {
                object = object5.getStringValue();
                if (bl2) {
                    xsltExecutable = ((StylesheetCache)object3).getStylesheetByLocation((String)object);
                }
                if (xsltExecutable != null) break;
                try {
                    object5 = this.getStaticBaseUriString();
                    object2 = xsltCompiler.getURIResolver().resolve((String)object, (String)object5);
                    if (object2 == null) {
                        object2 = xsltCompiler.getProcessor().getUnderlyingConfiguration().getSystemURIResolver().resolve((String)object, (String)object5);
                    }
                }
                catch (TransformerException transformerException) {
                    throw new XPathException(transformerException);
                }
                try {
                    xsltExecutable = xsltCompiler.compile((Source)object2);
                }
                catch (SaxonApiException saxonApiException) {
                    object5 = saxonApiException;
                    return TransformFn.a(saxonApiException, (List<TransformerException>)((Object)sequence));
                }
                if (!bl2) break;
                ((StylesheetCache)object3).setStylesheetByLocation((String)object, xsltExecutable);
                break;
            }
            case 1: 
            case 2: {
                object2 = (NodeInfo)object5;
                if (uRI != null && !object2.getBaseURI().equals(uRI.toASCIIString())) {
                    object5 = uRI.toASCIIString();
                    RebasedDocument rebasedDocument = new RebasedDocument(object2.getTreeInfo(), nodeInfo -> object5, nodeInfo -> object5);
                    object2 = rebasedDocument.getRootNode();
                }
                if (bl2) {
                    xsltExecutable = ((StylesheetCache)object3).getStylesheetByNode((NodeInfo)object2);
                }
                if (xsltExecutable != null) break;
                object5 = object2;
                if (uRI != null) {
                    object5 = AugmentedSource.makeAugmentedSource(object5);
                    object5.setSystemId(uRI.toASCIIString());
                }
                try {
                    xsltExecutable = xsltCompiler.compile((Source)object5);
                }
                catch (SaxonApiException saxonApiException) {
                    SaxonApiException saxonApiException2 = saxonApiException;
                    TransformFn.a(saxonApiException, (List<TransformerException>)((Object)sequence));
                }
                if (!bl2) break;
                ((StylesheetCache)object3).setStylesheetByNode((NodeInfo)object2, xsltExecutable);
                break;
            }
            case 3: {
                object5 = object5.getStringValue();
                if (bl2) {
                    xsltExecutable = ((StylesheetCache)object3).getStylesheetByText((String)object5);
                }
                if (xsltExecutable != null) break;
                StringReader stringReader = new StringReader((String)object5);
                object2 = new SAXSource(new InputSource(stringReader));
                if (uRI != null) {
                    ((SAXSource)object2).setSystemId(uRI.toASCIIString());
                }
                try {
                    xsltExecutable = xsltCompiler.compile((Source)object2);
                }
                catch (SaxonApiException saxonApiException) {
                    object = saxonApiException;
                    TransformFn.a(saxonApiException, (List<TransformerException>)((Object)sequence));
                }
                if (!bl2) break;
                ((StylesheetCache)object3).setStylesheetByText((String)object5, xsltExecutable);
                break;
            }
            case 4: {
                String string = Whitespace.trim(object5.getStringValue());
                object2 = null;
                if (object.get("package-version") != null) {
                    object2 = ((Sequence)object.get("package-version")).head().getStringValue();
                }
                try {
                    object = xsltCompiler.obtainPackage(string, (String)object2);
                    if (object == null) {
                        throw new XPathException("Cannot locate package " + string + " version " + (String)object2, "FOXT0002");
                    }
                    xsltExecutable = ((XsltPackage)object).link();
                    break;
                }
                catch (SaxonApiException saxonApiException) {
                    object = saxonApiException;
                    if (saxonApiException.getCause() instanceof XPathException) {
                        throw (XPathException)((Throwable)object).getCause();
                    }
                    throw new XPathException((Throwable)object);
                }
            }
        }
        return xsltExecutable;
    }

    private static XsltExecutable a(SaxonApiException saxonApiException, List<TransformerException> object) {
        object = object.iterator();
        while (object.hasNext()) {
            TransformerException transformerException = (TransformerException)object.next();
            if (!(transformerException instanceof XPathException)) continue;
            if (((XPathException)transformerException).getErrorCodeLocalPart() == null) {
                ((XPathException)transformerException).setErrorCode("FOXT0002");
            }
            throw (XPathException)transformerException;
        }
        if (saxonApiException.getCause() instanceof XPathException) {
            throw (XPathException)saxonApiException.getCause();
        }
        throw new XPathException(saxonApiException);
    }

    @Override
    public Sequence<?> call(XPathContext xPathContext, Sequence[] object) {
        Object object2;
        Object object3;
        GroundedValue<?> groundedValue;
        Object object42;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        GroundedValue<?> groundedValue2;
        Sequence<?> sequence = (object = this.getDetails().optionDetails.processSuppliedOptions((MapItem)object[0].head(), xPathContext)).get("vendor-options");
        sequence = sequence == null ? null : (MapItem)sequence.head();
        Configuration configuration = xPathContext.getConfiguration();
        boolean bl2 = true;
        int n2 = 0;
        if (sequence != null) {
            groundedValue2 = sequence.get(new QNameValue("", "http://saxon.sf.net/", "configuration"));
            if (groundedValue2 != null) {
                groundedValue2 = (NodeInfo)groundedValue2.head();
                configuration = Configuration.readConfiguration((Source)((Object)groundedValue2), configuration);
                bl2 = false;
                if (!xPathContext.getConfiguration().getBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS)) {
                    configuration.setBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS, false);
                }
            }
            if ((groundedValue2 = sequence.get(new QNameValue("", "http://saxon.sf.net/", "schema-validation"))) != null) {
                groundedValue2 = groundedValue2.head().getStringValue();
                n2 = Validation.getCode((String)((Object)groundedValue2));
            }
        }
        groundedValue2 = new Processor(true);
        ((Processor)((Object)groundedValue2)).setConfigurationProperty(Feature.CONFIGURATION, configuration);
        boolean bl3 = true;
        Object object9 = object;
        Object object10 = this;
        if (object9.isEmpty()) {
            throw new XPathException("No transformation options supplied", "FOXT0002");
        }
        object10 = object9.keySet().iterator();
        block72: while (object10.hasNext()) {
            boolean bl4;
            object8 = object9 = (String)object10.next();
            object7 = a;
            int n3 = a.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                String string = object7[i2];
                if (!string.equals(object8)) continue;
                bl4 = true;
                continue block72;
            }
            bl4 = false;
        }
        boolean bl5 = true;
        if (object.get("xslt-version") != null) {
            object6 = (BigDecimalValue)((Sequence)object.get("xslt-version")).head();
            ((NumericValue)object6).compareTo(BigDecimalValue.THREE);
            if (((NumericValue)object6).compareTo(BigDecimalValue.THREE) > 0) {
                throw new XPathException("The transform option xslt-version is higher than the XSLT version supported by this processor", "FOXT0002");
            }
            bl5 = ((NumericValue)object6).compareTo(BigDecimalValue.THREE) == 0;
        }
        object6 = this.a((Map<String, Sequence<?>>)object, "source-node", "source-location", "initial-match-selection");
        Object object11 = "invocation";
        object9 = object;
        object10 = this;
        if ((object10 = ((TransformFn)object10).a((Map<String, Sequence<?>>)object9, "initial-mode", "initial-template", "initial-function")) != null) {
            object11 = object10;
        }
        if (!((String)object11).equals("initial-template") && !((String)object11).equals("initial-function") && object6 == null) {
            object11 = "initial-template";
            object.put("initial-template", new QNameValue("", "http://www.w3.org/1999/XSL/Transform", "initial-template"));
        }
        if (((String)object11).equals("initial-function") && object.get("function-params") == null) {
            throw new XPathException("Use of the transform option initial-function requires the function parameters to be supplied using the option function-params", "FOXT0002");
        }
        if (!((String)object11).equals("initial-function") && object.get("function-params") != null) {
            throw new XPathException("The transform option function-params can only be used if the option initial-function is also used", "FOXT0002");
        }
        TransformFn transformFn = this;
        object9 = object;
        object10 = transformFn;
        Object object12 = object9;
        object9 = new String[]{"stylesheet-location", "stylesheet-node", "stylesheet-text", "package-name", "package-node", "package-location"};
        object10 = object12;
        Function function = transformFn;
        object8 = transformFn.a((Map<String, Sequence<?>>)object10, (String[])object9);
        if (object8 == null) {
            throw new XPathException("One of the following transform options must be present: " + TransformFn.a((String[])object9));
        }
        object11 = object8;
        if (((String)object11).equals("package-location")) {
            throw new XPathException("The transform option " + (String)object11 + " is not implemented in Saxon", "FOXT0002");
        }
        object6 = object11;
        if (object.get("requested-properties") != null) {
            object11 = groundedValue2;
            object9 = object;
            object10 = this;
            function = (MapItem)((Sequence)object9.get("requested-properties")).head();
            object10 = function.keys();
            while ((object9 = object10.next()) != null) {
                object8 = ((QNameValue)((AtomicValue)object9).head()).getStructuredQName();
                object5 = (AtomicValue)function.get((AtomicValue)object9).head();
                if (((StructuredQName)object8).hasURI("http://www.w3.org/1999/XSL/Transform")) {
                    object7 = ((StructuredQName)object8).getLocalPart();
                    switch (object7) {
                        case "vendor-url": {
                            if (((AtomicValue)object5).getStringValue().contains("saxonica.com") || ((AtomicValue)object5).getStringValue().equals("Saxonica")) break;
                            TransformFn.a("vendor-url", ((AtomicValue)object5).getStringValue());
                            break;
                        }
                        case "product-name": {
                            if (((AtomicValue)object5).getStringValue().equals("SAXON")) break;
                            TransformFn.a("vendor-url", ((AtomicValue)object5).getStringValue());
                            break;
                        }
                        case "product-version": {
                            if (Version.getProductVersion().startsWith(((AtomicValue)object5).getStringValue())) break;
                            TransformFn.a("product-version", ((AtomicValue)object5).getStringValue());
                            break;
                        }
                        case "is-schema-aware": {
                            boolean bl6 = TransformFn.a((AtomicValue)object5);
                            if (bl6) {
                                if (((Processor)object11).getUnderlyingConfiguration().isLicensedFeature(2)) {
                                    ((Processor)object11).setConfigurationProperty(Feature.XSLT_SCHEMA_AWARE, Boolean.TRUE);
                                    break;
                                }
                                TransformFn.a("is-schema-aware", ((AtomicValue)object5).getStringValue());
                                break;
                            }
                            if (!((Processor)object11).getUnderlyingConfiguration().isLicensedFeature(2)) break;
                            TransformFn.a("is-schema-aware", ((AtomicValue)object5).getStringValue());
                            break;
                        }
                        case "supports-serialization": {
                            boolean bl6 = TransformFn.a((AtomicValue)object5);
                            if (bl6) break;
                            TransformFn.a("supports-serialization", ((AtomicValue)object5).getStringValue());
                            break;
                        }
                        case "supports-backwards-compatibility": {
                            boolean bl6 = TransformFn.a((AtomicValue)object5);
                            if (bl6) break;
                            TransformFn.a("supports-backwards-compatibility", ((AtomicValue)object5).getStringValue());
                            break;
                        }
                        case "supports-namespace-axis": {
                            boolean bl6 = TransformFn.a((AtomicValue)object5);
                            if (bl6) break;
                            TransformFn.a("supports-namespace-axis", ((AtomicValue)object5).getStringValue());
                            break;
                        }
                        case "supports-streaming": {
                            boolean bl6 = TransformFn.a((AtomicValue)object5);
                            if (bl6) {
                                if (((Processor)object11).getUnderlyingConfiguration().isLicensedFeature(2)) break;
                                TransformFn.a("supports-streaming", ((AtomicValue)object5).getStringValue());
                                break;
                            }
                            if (!((Processor)object11).getUnderlyingConfiguration().isLicensedFeature(2)) break;
                            ((Processor)object11).setConfigurationProperty(Feature.STREAMABILITY, "off");
                            break;
                        }
                        case "supports-dynamic-evaluation": {
                            boolean bl6 = TransformFn.a((AtomicValue)object5);
                            if (bl6) {
                                if (((Processor)object11).getUnderlyingConfiguration().isLicensedFeature(8)) break;
                                TransformFn.a("supports-dynamic-evaluation", ((AtomicValue)object5).getStringValue());
                                break;
                            }
                            if (!((Processor)object11).getUnderlyingConfiguration().isLicensedFeature(8)) break;
                            ((Processor)object11).setConfigurationProperty(Feature.DISABLE_XSL_EVALUATE, Boolean.TRUE);
                            break;
                        }
                        case "supports-higher-order-functions": {
                            boolean bl6 = TransformFn.a((AtomicValue)object5);
                            if (bl6 == ((Processor)object11).getUnderlyingConfiguration().isLicensedFeature(8)) break;
                            TransformFn.a("supports-higher-order-functions", ((AtomicValue)object5).getStringValue());
                            break;
                        }
                        case "xpath-version": {
                            String string = ((AtomicValue)object5).getStringValue();
                            try {
                                if (!(Double.parseDouble(string) > 3.1)) break;
                                TransformFn.a("xpath-version", ((AtomicValue)object5).getStringValue());
                            }
                            catch (NumberFormatException numberFormatException) {
                                TransformFn.a("xpath-version", ((AtomicValue)object5).getStringValue());
                            }
                            break;
                        }
                        case "xsd-version": {
                            String string = ((AtomicValue)object5).getStringValue();
                            try {
                                if (!(Double.parseDouble(string) > 1.1)) break;
                                TransformFn.a("xsd-version", ((AtomicValue)object5).getStringValue());
                                break;
                            }
                            catch (NumberFormatException numberFormatException) {
                                TransformFn.a("xsd-version", ((AtomicValue)object5).getStringValue());
                            }
                        }
                    }
                }
            }
        }
        groundedValue2 = ((Processor)((Object)groundedValue2)).newXsltCompiler();
        ((XsltCompiler)((Object)groundedValue2)).setURIResolver(xPathContext.getURIResolver());
        ((XsltCompiler)((Object)groundedValue2)).setJustInTimeCompilation(false);
        if (object.get("static-params") != null) {
            boolean bl7 = bl2;
            object11 = groundedValue2;
            object9 = object;
            object10 = this;
            object10 = (MapItem)((Sequence)object9.get("static-params")).head();
            object9 = object10.keys();
            while ((object8 = object9.next()) != null) {
                if (!(object8 instanceof QNameValue)) {
                    throw new XPathException("Parameter names in static-params must be supplied as QNames", "FOXT0002");
                }
                object5 = new QName(((QNameValue)object8).getStructuredQName());
                object7 = object10.get((AtomicValue)object8);
                if (!bl7) {
                    TransformFn.a((Sequence)object7);
                }
                XdmValue xdmValue = XdmValue.wrap(object7);
                ((XsltCompiler)object11).setParameter((QName)object5, xdmValue);
            }
        }
        object6 = this.a((Map<String, Sequence<?>>)object, (XsltCompiler)((Object)groundedValue2), (String)object6, xPathContext);
        object6 = ((XsltExecutable)object6).load30();
        object10 = "document";
        object11 = null;
        object9 = null;
        XdmValue xdmValue = null;
        object8 = null;
        object5 = null;
        object7 = null;
        HashMap<QName, XdmValue> hashMap = new HashMap<QName, XdmValue>();
        MapItem mapItem = null;
        XdmItem xdmItem = null;
        HashMap<QName, XdmValue> hashMap2 = new HashMap<QName, XdmValue>();
        HashMap<QName, XdmValue> hashMap3 = new HashMap<QName, XdmValue>();
        QName qName = null;
        XdmValue[] xdmValueArray = null;
        Function function2 = null;
        String string = "output";
        for (Object object42 : object.keySet()) {
            groundedValue = (Sequence)object.get(object42);
            object3 = groundedValue.head();
            int n4 = -1;
            switch (((String)object42).hashCode()) {
                case -130989964: {
                    if (!((String)object42).equals("source-node")) break;
                    n4 = 0;
                    break;
                }
                case 846899495: {
                    if (!((String)object42).equals("source-location")) break;
                    n4 = 1;
                    break;
                }
                case 993322211: {
                    if (!((String)object42).equals("initial-template")) break;
                    n4 = 2;
                    break;
                }
                case -455872884: {
                    if (!((String)object42).equals("initial-mode")) break;
                    n4 = 3;
                    break;
                }
                case -865613061: {
                    if (!((String)object42).equals("initial-match-selection")) break;
                    n4 = 4;
                    break;
                }
                case 545106928: {
                    if (!((String)object42).equals("delivery-format")) break;
                    n4 = 5;
                    break;
                }
                case 154047260: {
                    if (!((String)object42).equals("base-output-uri")) break;
                    n4 = 6;
                    break;
                }
                case 292432387: {
                    if (!((String)object42).equals("serialization-params")) break;
                    n4 = 7;
                    break;
                }
                case 1127885285: {
                    if (!((String)object42).equals("stylesheet-params")) break;
                    n4 = 8;
                    break;
                }
                case -2094989733: {
                    if (!((String)object42).equals("global-context-item")) break;
                    n4 = 9;
                    break;
                }
                case 1538947641: {
                    if (!((String)object42).equals("template-params")) break;
                    n4 = 10;
                    break;
                }
                case -326824309: {
                    if (!((String)object42).equals("tunnel-params")) break;
                    n4 = 11;
                    break;
                }
                case -599159743: {
                    if (!((String)object42).equals("initial-function")) break;
                    n4 = 12;
                    break;
                }
                case 622488859: {
                    if (!((String)object42).equals("function-params")) break;
                    n4 = 13;
                    break;
                }
                case 151255618: {
                    if (!((String)object42).equals("post-process")) break;
                    n4 = 14;
                }
            }
            switch (n4) {
                case 0: {
                    object11 = (NodeInfo)object3;
                    if (bl2) break;
                    TransformFn.a((Sequence)object11);
                    break;
                }
                case 1: {
                    object9 = object3.getStringValue();
                    break;
                }
                case 2: {
                    object8 = new QName(((QNameValue)object3).getStructuredQName());
                    break;
                }
                case 3: {
                    object5 = new QName(((QNameValue)object3).getStructuredQName());
                    break;
                }
                case 4: {
                    xdmValue = XdmValue.wrap(groundedValue);
                    if (bl2) break;
                    TransformFn.a(groundedValue);
                    break;
                }
                case 5: {
                    object10 = object3.getStringValue();
                    if (((String)object10).equals("document") || ((String)object10).equals("serialized") || ((String)object10).equals("raw")) break;
                    throw new XPathException("The transform option delivery-format should be one of: document|serialized|raw ", "FOXT0002");
                }
                case 6: {
                    object7 = object3.getStringValue();
                    string = object7;
                    break;
                }
                case 7: {
                    mapItem = (MapItem)object3;
                    break;
                }
                case 8: {
                    object42 = (MapItem)object3;
                    this.a((MapItem)object42, hashMap, bl2);
                    break;
                }
                case 9: {
                    if (!bl5) break;
                    if (!bl2 && object3 instanceof NodeInfo && ((NodeInfo)object3).getTreeInfo().isTyped()) {
                        throw new XPathException("Schema-validated nodes cannot be passed to fn:transform() when it runs under a different Saxon Configuration", "FOXT0002");
                    }
                    xdmItem = (XdmItem)XdmValue.wrap(object3);
                    break;
                }
                case 10: {
                    object42 = (MapItem)object3;
                    this.a((MapItem)object42, hashMap2, bl2);
                    break;
                }
                case 11: {
                    object42 = (MapItem)object3;
                    this.a((MapItem)object42, hashMap3, bl2);
                    break;
                }
                case 12: {
                    qName = new QName(((QNameValue)object3).getStructuredQName());
                    break;
                }
                case 13: {
                    object42 = (ArrayItem)object3;
                    xdmValueArray = new XdmValue[object42.arrayLength()];
                    for (int i3 = 0; i3 < xdmValueArray.length; ++i3) {
                        groundedValue = object42.get(i3);
                        if (!bl2) {
                            TransformFn.a(groundedValue);
                        }
                        xdmValueArray[i3] = XdmValue.wrap(groundedValue);
                    }
                    break;
                }
                case 14: {
                    function2 = (Function)object3;
                }
            }
        }
        if (object7 == null) {
            object7 = this.getStaticBaseUriString();
        } else {
            try {
                object2 = new URI((String)object7);
                if (!((URI)object2).isAbsolute()) {
                    object2 = this.getRetainedStaticContext().getStaticBaseUri().resolve((String)object7);
                    object7 = ((URI)object2).toASCIIString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new XPathException("Invalid base output URI " + (String)object7, "FOXT0002");
            }
        }
        object2 = net.sf.saxon.functions.TransformFn$a.a((String)object10);
        ((a)object2).a((Xslt30Transformer)object6);
        ((a)object2).b((String)object7);
        ((a)object2).a(function2, xPathContext);
        object42 = ((Xslt30Transformer)object6).getUnderlyingController();
        ((XsltController)object42).setResultDocumentResolver((ResultDocumentResolver)object2);
        groundedValue = ((a)object2).a(mapItem);
        try {
            ((Xslt30Transformer)object6).setStylesheetParameters(hashMap);
            ((Xslt30Transformer)object6).setBaseOutputURI((String)object7);
            ((Xslt30Transformer)object6).setInitialTemplateParameters(hashMap2, false);
            ((Xslt30Transformer)object6).setInitialTemplateParameters(hashMap3, true);
            if (n2 == 1 || n2 == 2) {
                if (object11 != null) {
                    object11 = TransformFn.a((NodeInfo)object11, configuration, n2);
                } else if (object9 != null) {
                    try {
                        object42 = this.getStaticBaseUriString();
                        Source source = ((XsltCompiler)((Object)groundedValue2)).getURIResolver().resolve((String)object9, (String)object42);
                        if (source == null && (source = configuration.getURIResolver().resolve((String)object9, (String)object42)) == null) {
                            throw new XPathException("Cannot locate document at sourceLocation " + (String)object9, "FOXT0003");
                        }
                        object42 = new ParseOptions(configuration.getParseOptions());
                        ((ParseOptions)object42).setSchemaValidationMode(n2);
                        object3 = configuration.buildDocumentTree(source, (ParseOptions)object42);
                        object11 = object3.getRootNode();
                        object9 = null;
                    }
                    catch (TransformerException transformerException) {
                        object42 = transformerException;
                        throw XPathException.makeXPathException(transformerException);
                    }
                }
                if (xdmItem instanceof XdmNode) {
                    object42 = TransformFn.a(((XdmNode)xdmItem).getUnderlyingNode(), configuration, n2);
                    xdmItem = (XdmNode)XdmValue.wrap(object42);
                }
            }
            if (object11 != null && xdmItem == null) {
                ((Xslt30Transformer)object6).setGlobalContextItem(new XdmNode(object11.getRoot()));
            }
            if (xdmItem != null) {
                ((Xslt30Transformer)object6).setGlobalContextItem(xdmItem);
            }
            if (object8 != null) {
                ((Xslt30Transformer)object6).callTemplate((QName)object8, (Destination)((Object)groundedValue));
                object3 = object2.a();
            } else if (qName != null) {
                ((Xslt30Transformer)object6).callFunction(qName, xdmValueArray, (Destination)((Object)groundedValue));
                object3 = object2.a();
            } else {
                if (object5 != null) {
                    ((Xslt30Transformer)object6).setInitialMode((QName)object5);
                }
                if (xdmValue == null && object11 != null) {
                    xdmValue = XdmValue.wrap(object11);
                }
                if (xdmValue == null && object9 != null) {
                    object42 = new StreamSource((String)object9);
                    if (((Xslt30Transformer)object6).getUnderlyingController().getInitialMode().isDeclaredStreamable()) {
                        ((Xslt30Transformer)object6).applyTemplates((Source)object42, (Destination)((Object)groundedValue));
                    } else {
                        ((Xslt30Transformer)object6).transform((Source)object42, (Destination)((Object)groundedValue));
                    }
                    object3 = object2.a();
                } else {
                    ((Xslt30Transformer)object6).applyTemplates(xdmValue, (Destination)((Object)groundedValue));
                    object3 = object2.a();
                }
            }
        }
        catch (SaxonApiException saxonApiException) {
            object42 = saxonApiException;
            if (saxonApiException.getCause() instanceof XPathException) {
                XPathException xPathException = (XPathException)((Throwable)object42).getCause();
                xPathException.setIsGlobalError(false);
                throw xPathException;
            }
            throw new XPathException((Throwable)object42);
        }
        object42 = new HashTrieMap();
        object42 = ((a)object2).a((HashTrieMap)object42);
        if (object3 != null) {
            StringValue stringValue = new StringValue(string);
            object42 = ((HashTrieMap)object42).addEntry((AtomicValue)stringValue, object3.materialize());
        }
        return object42;
    }

    private void a(MapItem mapItem, Map<QName, XdmValue> map, boolean bl2) {
        Iterable<AtomicValue> iterable;
        AtomicIterator atomicIterator = mapItem.keys();
        while ((iterable = atomicIterator.next()) != null) {
            if (!(iterable instanceof QNameValue)) {
                throw new XPathException("The names of parameters must be supplied as QNames", "FOXT0002");
            }
            QName qName = new QName(((QNameValue)iterable).getStructuredQName());
            iterable = mapItem.get((AtomicValue)iterable);
            if (!bl2) {
                TransformFn.a((Sequence)((Object)iterable));
            }
            iterable = XdmValue.wrap(iterable);
            map.put(qName, (XdmValue)iterable);
        }
    }

    private static void a(Sequence object) {
        Object t2;
        object = object.iterate();
        while ((t2 = object.next()) != null) {
            if (!(t2 instanceof NodeInfo) || !((NodeInfo)t2).getTreeInfo().isTyped()) continue;
            throw new XPathException("Schema-validated nodes cannot be passed to fn:transform() when it runs under a different Saxon Configuration", "FOXT0002");
        }
    }

    private static NodeInfo a(NodeInfo nodeInfo, Configuration configuration, int n2) {
        ParseOptions parseOptions = new ParseOptions(configuration.getParseOptions());
        parseOptions.setSchemaValidationMode(n2);
        return configuration.buildDocumentTree(nodeInfo, parseOptions).getRootNode();
    }

    private static final class c
    extends a {
        private Map<String, XdmValue> b = new ConcurrentHashMap<String, XdmValue>();
        private RawDestination c = new RawDestination();

        public c() {
            super((byte)0);
        }

        @Override
        public final AbstractDestination a(MapItem mapItem) {
            return this.c;
        }

        @Override
        public final Sequence<?> a() {
            GroundedValue<?> groundedValue = this.c.getXdmValue().getUnderlyingValue();
            c c2 = this;
            return c2.a(c2.a, groundedValue);
        }

        @Override
        public final Receiver resolve(XPathContext xPathContext, String object, String object2, SerializationProperties serializationProperties) {
            object = net.sf.saxon.functions.TransformFn$c.a((String)object, (String)object2);
            object2 = new RawDestination();
            ((AbstractDestination)object2).onClose(() -> this.a((URI)object, (RawDestination)object2));
            return ((RawDestination)object2).getReceiver(xPathContext.getReceiver().getPipelineConfiguration(), serializationProperties);
        }

        @Override
        public final HashTrieMap a(HashTrieMap mapItem) {
            for (Map.Entry<String, XdmValue> entry : this.b.entrySet()) {
                String string = entry.getKey();
                mapItem = mapItem.addEntry((AtomicValue)new StringValue(string), (GroundedValue)entry.getValue().getUnderlyingValue());
            }
            return mapItem;
        }

        private /* synthetic */ void a(URI uRI, RawDestination rawDestination) {
            this.b.put(uRI.toASCIIString(), rawDestination.getXdmValue());
        }
    }

    private static final class d
    extends a {
        private Map<String, String> b = new ConcurrentHashMap<String, String>();
        private Map<String, StringWriter> c = new ConcurrentHashMap<String, StringWriter>();
        private StringWriter d;

        public d() {
            super((byte)0);
        }

        @Override
        public final AbstractDestination a(MapItem object) {
            object = this.b((MapItem)object);
            this.d = new StringWriter();
            ((Serializer)object).setOutputWriter(this.d);
            return object;
        }

        @Override
        public final Sequence<?> a() {
            String string = this.d.toString();
            if (string.isEmpty()) {
                return null;
            }
            d d2 = this;
            return d2.a(d2.a, new StringValue(string));
        }

        @Override
        public final Receiver resolve(XPathContext object, String object2, String object3, SerializationProperties serializationProperties) {
            if (((URI)(object2 = net.sf.saxon.functions.TransformFn$d.a((String)object2, (String)object3))).getScheme().equals("dummy")) {
                throw new XPathException("The location of output documents is undefined: use the transform option base-output-uri", "FOXT0002");
            }
            object3 = new StringWriter();
            Serializer serializer = this.b((MapItem)null);
            serializer.setCharacterMap(serializationProperties.getCharacterMapIndex());
            serializer.setOutputWriter((Writer)object3);
            serializer.onClose(() -> this.a((URI)object2, (StringWriter)object3));
            try {
                object = serializer.getReceiver(object.getReceiver().getPipelineConfiguration(), serializationProperties);
                object.setSystemId(((URI)object2).toASCIIString());
                return object;
            }
            catch (SaxonApiException saxonApiException) {
                object = saxonApiException;
                throw XPathException.makeXPathException(saxonApiException);
            }
        }

        @Override
        public final HashTrieMap a(HashTrieMap mapItem) {
            for (Map.Entry<String, String> entry : this.b.entrySet()) {
                String string = entry.getKey();
                mapItem = mapItem.addEntry((AtomicValue)new StringValue(string), (GroundedValue)new StringValue(entry.getValue()));
            }
            return mapItem;
        }

        private /* synthetic */ void a(URI uRI, StringWriter stringWriter) {
            this.b.put(uRI.toASCIIString(), stringWriter.toString());
        }
    }

    private static final class b
    extends a {
        private Map<String, TreeInfo> b = new ConcurrentHashMap<String, TreeInfo>();
        private XdmDestination c = new XdmDestination();

        public b() {
            super((byte)0);
        }

        @Override
        public final AbstractDestination a(MapItem mapItem) {
            return this.c;
        }

        @Override
        public final Sequence<?> a() {
            XdmNode xdmNode = this.c.getXdmNode();
            if (xdmNode == null) {
                return null;
            }
            b b2 = this;
            return b2.a(b2.a, xdmNode.getUnderlyingNode());
        }

        @Override
        public final Receiver resolve(XPathContext xPathContext, String object, String object2, SerializationProperties serializationProperties) {
            object = net.sf.saxon.functions.TransformFn$b.a((String)object, (String)object2);
            object2 = new XdmDestination();
            ((AbstractDestination)object2).setDestinationBaseURI((URI)object);
            ((AbstractDestination)object2).onClose(() -> this.a((XdmDestination)object2, (URI)object));
            return ((XdmDestination)object2).getReceiver(xPathContext.getReceiver().getPipelineConfiguration(), serializationProperties);
        }

        @Override
        public final HashTrieMap a(HashTrieMap mapItem) {
            for (Map.Entry<String, TreeInfo> entry : this.b.entrySet()) {
                String string = entry.getKey();
                mapItem = mapItem.addEntry((AtomicValue)new StringValue(string), (GroundedValue)entry.getValue().getRootNode());
            }
            return mapItem;
        }

        private /* synthetic */ void a(XdmDestination object, URI uRI) {
            object = ((XdmDestination)object).getXdmNode();
            this.b.put(uRI.toASCIIString(), ((XdmNode)object).getUnderlyingValue().getTreeInfo());
        }
    }

    private static abstract class a
    implements ResultDocumentResolver {
        private Xslt30Transformer b;
        protected String a;
        private Function c;
        private XPathContext d;
        private HashTrieMap e = new HashTrieMap();

        private a() {
        }

        public static a a(String string) {
            int n2 = -1;
            switch (string.hashCode()) {
                case 861720859: {
                    if (!string.equals("document")) break;
                    n2 = 0;
                    break;
                }
                case -597985916: {
                    if (!string.equals("serialized")) break;
                    n2 = 1;
                    break;
                }
                case 112680: {
                    if (!string.equals("raw")) break;
                    n2 = 2;
                }
            }
            switch (n2) {
                case 0: {
                    return new b();
                }
                case 1: {
                    return new d();
                }
                case 2: {
                    return new c();
                }
            }
            throw new IllegalArgumentException("delivery-format");
        }

        public final void a(Xslt30Transformer xslt30Transformer) {
            this.b = xslt30Transformer;
        }

        public final void b(String string) {
            this.a = string;
        }

        public final void a(Function function, XPathContext xPathContext) {
            this.c = function;
            this.d = xPathContext;
        }

        protected static URI a(String object, String string) {
            try {
                object = ResolveURI.makeAbsolute((String)object, string);
            }
            catch (URISyntaxException uRISyntaxException) {
                object = uRISyntaxException;
                throw XPathException.makeXPathException(uRISyntaxException);
            }
            return object;
        }

        public abstract HashTrieMap a(HashTrieMap var1);

        public abstract AbstractDestination a(MapItem var1);

        protected final Serializer b(MapItem mapItem) {
            Serializer serializer = this.b.newSerializer();
            if (mapItem != null) {
                Object object;
                AtomicIterator atomicIterator = mapItem.keys();
                while ((object = atomicIterator.next()) != null) {
                    Object object2;
                    Object object3;
                    if (object instanceof StringValue) {
                        object3 = new QName(((AtomicValue)object).getStringValue());
                    } else if (object instanceof QNameValue) {
                        object3 = new QName(((QNameValue)((AtomicValue)object).head()).getStructuredQName());
                    } else {
                        throw new XPathException("Serialization parameters must be strings or QNames", "XPTY0004");
                    }
                    String string = null;
                    if ((object = mapItem.get((AtomicValue)object)).getLength() <= 0) continue;
                    if (object.getLength() == 1) {
                        object2 = object.itemAt(0);
                        if (object2 instanceof StringValue) {
                            string = object2.getStringValue();
                        } else if (object2 instanceof BooleanValue) {
                            string = ((BooleanValue)object2).getBooleanValue() ? "yes" : "no";
                        } else if (object2 instanceof DecimalValue) {
                            string = object2.getStringValue();
                        } else if (object2 instanceof QNameValue) {
                            string = ((QNameValue)object2).getClarkName();
                        } else if (object2 instanceof MapItem && ((QName)object3).getClarkName().equals("use-character-maps")) {
                            object = Serialize.toCharacterMap((MapItem)object2);
                            object3 = new CharacterMapIndex();
                            ((CharacterMapIndex)object3).putCharacterMap(((CharacterMap)object).getName(), (CharacterMap)object);
                            serializer.setCharacterMap((CharacterMapIndex)object3);
                            object3 = serializer.getOutputProperty(Serializer.Property.USE_CHARACTER_MAPS);
                            if (object3 == null) {
                                serializer.setOutputProperty(Serializer.Property.USE_CHARACTER_MAPS, ((CharacterMap)object).getName().getClarkName());
                                continue;
                            }
                            serializer.setOutputProperty(Serializer.Property.USE_CHARACTER_MAPS, (String)object3 + " " + ((CharacterMap)object).getName().getClarkName());
                            continue;
                        }
                    }
                    if (string == null) {
                        object2 = object.iterate();
                        string = "";
                        while ((object = object2.next()) != null) {
                            if (object instanceof QNameValue) {
                                string = string + " " + ((QNameValue)object).getClarkName();
                                continue;
                            }
                            throw new XPathException("Value of serialization parameter " + ((QName)object3).getEQName() + " not recognized", "XPTY0004");
                        }
                    }
                    object2 = Serializer.getProperty((QName)object3);
                    if (((QName)object3).getClarkName().equals("cdata-section-elements") || ((QName)object3).getClarkName().equals("suppress-indentation")) {
                        object = serializer.getOutputProperty((QName)object3);
                        if (object == null) {
                            serializer.setOutputProperty((Serializer.Property)((Object)object2), string);
                            continue;
                        }
                        serializer.setOutputProperty((Serializer.Property)((Object)object2), (String)object + string);
                        continue;
                    }
                    serializer.setOutputProperty((Serializer.Property)((Object)object2), string);
                }
            }
            return serializer;
        }

        public abstract Sequence<?> a();

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public final GroundedValue a(String string, GroundedValue sequence) {
            if (this.c != null) {
                sequence = this.c.call((XPathContext)this.d.newCleanContext(), new Sequence[]{new StringValue(string), sequence});
            }
            return sequence.materialize();
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

